/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import sbt.internal.inc.CompileFailed;
import sbt.internal.inc.CompilerArguments;
import sbt.internal.inc.ScalaInstance$;
import sbt.util.Logger;
import scala.Array$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import xsbti.Problem;
import xsbti.compile.ClasspathOptions;
import xsbti.compile.ScalaInstance;

@ScalaSignature(bytes="\u0006\u000154A!\u0003\u0006\u0001#!A\u0001\u0004\u0001BC\u0002\u0013\u0005\u0011\u0004\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003\u001b\u0011!\u0019\u0003A!A!\u0002\u0013!\u0003\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u000b9\u0002A\u0011A\u0018\t\u000bU\u0002A\u0011\u0001\u001c\t\u000b}\u0003A\u0011\u00031\t\u000b!\u0004A\u0011A5\u0003\u0017I\u000bwoQ8na&dWM\u001d\u0006\u0003\u00171\t1!\u001b8d\u0015\tia\"\u0001\u0005j]R,'O\\1m\u0015\u0005y\u0011aA:ci\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fM\u0006i1oY1mC&s7\u000f^1oG\u0016,\u0012A\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\tqaY8na&dWMC\u0001 \u0003\u0015A8O\u0019;j\u0013\t\tCDA\u0007TG\u0006d\u0017-\u00138ti\u0006t7-Z\u0001\u000fg\u000e\fG.Y%ogR\fgnY3!\u0003\t\u0019\u0007\u000f\u0005\u0002\u001cK%\u0011a\u0005\b\u0002\u0011\u00072\f7o\u001d9bi\"|\u0005\u000f^5p]N\f1\u0001\\8h!\tIC&D\u0001+\u0015\tYc\"\u0001\u0003vi&d\u0017BA\u0017+\u0005\u0019aunZ4fe\u00061A(\u001b8jiz\"B\u0001\r\u001a4iA\u0011\u0011\u0007A\u0007\u0002\u0015!)\u0001$\u0002a\u00015!)1%\u0002a\u0001I!)q%\u0002a\u0001Q\u0005)\u0011\r\u001d9msR)qG\u000f)S)B\u00111\u0003O\u0005\u0003sQ\u0011A!\u00168ji\")1H\u0002a\u0001y\u000591o\\;sG\u0016\u001c\bcA\u001fF\u0011:\u0011ah\u0011\b\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003B\ta\u0001\u0010:p_Rt\u0014\"A\u000b\n\u0005\u0011#\u0012a\u00029bG.\fw-Z\u0005\u0003\r\u001e\u00131aU3r\u0015\t!E\u0003\u0005\u0002J\u001d6\t!J\u0003\u0002L\u0019\u0006\u0011\u0011n\u001c\u0006\u0002\u001b\u0006!!.\u0019<b\u0013\ty%J\u0001\u0003GS2,\u0007\"B)\u0007\u0001\u0004a\u0014!C2mCN\u001c\b/\u0019;i\u0011\u0015\u0019f\u00011\u0001I\u0003=yW\u000f\u001e9vi\u0012K'/Z2u_JL\b\"B+\u0007\u0001\u00041\u0016aB8qi&|gn\u001d\t\u0004{\u0015;\u0006C\u0001-]\u001d\tI&\f\u0005\u0002@)%\u00111\fF\u0001\u0007!J,G-\u001a4\n\u0005us&AB*ue&twM\u0003\u0002\\)\u0005y1\r[3dW\u001a{'OR1jYV\u0014X\rF\u00028C\u000eDQAY\u0004A\u0002I\t\u0001B]3q_J$XM\u001d\u0005\u0006I\u001e\u0001\r!Z\u0001\u0005CJ<7\u000fE\u0002\u0014M^K!a\u001a\u000b\u0003\u000b\u0005\u0013(/Y=\u0002#\r|W\u000e]5mKJ\f%oZ;nK:$8/F\u0001k!\t\t4.\u0003\u0002m\u0015\t\t2i\\7qS2,'/\u0011:hk6,g\u000e^:")
public class RawCompiler {
    private final ScalaInstance scalaInstance;
    private final ClasspathOptions cp;
    private final Logger log;

    public ScalaInstance scalaInstance() {
        return this.scalaInstance;
    }

    public void apply(Seq<File> sources, Seq<File> classpath, File outputDirectory, Seq<String> options) {
        String uniqueCompilerVersion = this.scalaInstance().actualVersion();
        Some compilerOut = new Some((Object)outputDirectory);
        Seq<String> arguments = this.compilerArguments().apply(sources, classpath, (Option<File>)compilerOut, options);
        String[] args = (String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class));
        this.log.debug((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(71).append("Creating plain compiler interface for ").append(uniqueCompilerVersion).append(".\n        |  > Arguments: ").append(arguments.mkString("\n\t", "\n\t", "")).append("\n      ").toString())).stripMargin());
        Object reporter = ScalaInstance$.MODULE$.isDotty(this.scalaInstance().version()) ? this.getReporter$1("dotty.tools.dotc.Main", args, true) : this.getReporter$1("scala.tools.nsc.Main", args, false);
        this.checkForFailure(reporter, (String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public void checkForFailure(Object reporter, String[] args) {
        Method hasErrorsMethod = reporter.getClass().getMethod("hasErrors", new Class[0]);
        boolean failed = BoxesRunTime.unboxToBoolean((Object)hasErrorsMethod.invoke(reporter, new Object[0]));
        if (failed) {
            throw new CompileFailed(args, "Plain compile failed", (Problem[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Problem.class)));
        }
    }

    public CompilerArguments compilerArguments() {
        return new CompilerArguments(this.scalaInstance(), this.cp);
    }

    private final Object getReporter$1(String fqn, String[] args, boolean isDotty) {
        Class<?> mainClass = Class.forName(fqn, true, this.scalaInstance().loader());
        Method process = mainClass.getMethod("process", String[].class);
        Object potentialReporter = process.invoke(null, new Object[]{args});
        return isDotty ? potentialReporter : mainClass.getMethod("reporter", new Class[0]).invoke(null, new Object[0]);
    }

    public RawCompiler(ScalaInstance scalaInstance, ClasspathOptions cp, Logger log) {
        this.scalaInstance = scalaInstance;
        this.cp = cp;
        this.log = log;
    }
}

