/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.coursier.paths;

import java.io.File;
import java.io.IOException;
import lmcoursier.internal.shaded.coursier.cache.shaded.io.github.soc.directories.ProjectDirectories;
import lmcoursier.internal.shaded.coursier.paths.Util;

public final class CoursierPaths {
    private static final Object coursierDirectoriesLock = new Object();
    private static ProjectDirectories coursierDirectories0;
    private static final Object cacheDirectoryLock;
    private static volatile File cacheDirectory0;
    private static final Object configDirectoryLock;
    private static volatile File configDirectory0;
    private static final Object dataLocalDirectoryLock;
    private static volatile File dataLocalDirectory0;

    private CoursierPaths() {
        throw new Error();
    }

    private static String computeCacheDirectory() throws IOException {
        File file2;
        String string = System.getenv("COURSIER_CACHE");
        if (string == null) {
            string = System.getProperty("lmcoursier.internal.shaded.coursier.cache");
        }
        if (string != null) {
            return string;
        }
        File file3 = new File(CoursierPaths.coursierDirectories().cacheDir);
        File file4 = new File(file3, "v1");
        String string2 = file4.getAbsolutePath();
        if (file3.isDirectory()) {
            string = string2;
        }
        if (string == null && (file2 = new File(System.getProperty("user.home") + "/.coursier")).isDirectory()) {
            string = System.getProperty("user.home") + "/.coursier/cache/v1/";
        }
        if (string == null) {
            string = string2;
            Util.createDirectories(file4.toPath());
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File cacheDirectory() throws IOException {
        if (cacheDirectory0 == null) {
            Object object = cacheDirectoryLock;
            synchronized (object) {
                if (cacheDirectory0 == null) {
                    cacheDirectory0 = new File(CoursierPaths.computeCacheDirectory()).getAbsoluteFile();
                }
            }
        }
        return cacheDirectory0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProjectDirectories coursierDirectories() throws IOException {
        if (coursierDirectories0 == null) {
            Object object = coursierDirectoriesLock;
            synchronized (object) {
                if (coursierDirectories0 == null) {
                    coursierDirectories0 = ProjectDirectories.from(null, null, "Coursier");
                }
            }
        }
        return coursierDirectories0;
    }

    private static String computeConfigDirectory() throws IOException {
        String string = System.getenv("COURSIER_CONFIG_DIR");
        if (string == null) {
            string = System.getProperty("lmcoursier.internal.shaded.coursier.config-dir");
        }
        if (string != null) {
            return string;
        }
        return CoursierPaths.coursierDirectories().configDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File configDirectory() throws IOException {
        if (configDirectory0 == null) {
            Object object = configDirectoryLock;
            synchronized (object) {
                if (configDirectory0 == null) {
                    configDirectory0 = new File(CoursierPaths.computeConfigDirectory()).getAbsoluteFile();
                }
            }
        }
        return configDirectory0;
    }

    private static String computeDataLocalDirectory() throws IOException {
        String string = System.getenv("COURSIER_DATA_DIR");
        if (string == null) {
            string = System.getProperty("lmcoursier.internal.shaded.coursier.data-dir");
        }
        if (string != null) {
            return string;
        }
        return CoursierPaths.coursierDirectories().dataLocalDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File dataLocalDirectory() throws IOException {
        if (dataLocalDirectory0 == null) {
            Object object = dataLocalDirectoryLock;
            synchronized (object) {
                if (dataLocalDirectory0 == null) {
                    dataLocalDirectory0 = new File(CoursierPaths.computeDataLocalDirectory()).getAbsoluteFile();
                }
            }
        }
        return dataLocalDirectory0;
    }

    static {
        cacheDirectoryLock = new Object();
        cacheDirectory0 = null;
        configDirectoryLock = new Object();
        configDirectory0 = null;
        dataLocalDirectoryLock = new Object();
        dataLocalDirectory0 = null;
    }
}

