/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import net.sf.sdedit.drawable.Arrow;
import net.sf.sdedit.drawable.ArrowStroke;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.drawable.Line;
import net.sf.sdedit.message.Message;
import net.sf.sdedit.util.Direction;
import net.sf.sdedit.util.UIUtilities;

public class LoopArrow
extends Arrow {
    private int xExtent;
    private Drawable from;
    private Drawable to;

    public LoopArrow(Message msg, ArrowStroke stroke, Direction align, int y) {
        super(msg, stroke, align, y);
        this.init();
    }

    private void init() {
        Message message = this.getMessage();
        this.xExtent = this.diagram().selfMessageXExtent;
        this.setWidth(this.diagram().messagePadding + this.xExtent + this.diagram().subLifelineWidth + this.textWidth());
        this.from = message.getCaller().getView();
        this.to = message.getCallee().getView();
        if (this.getAlign() == Direction.LEFT) {
            this.setLeftEndpoint(message.getCallee().getLeftNeighbour().getView());
            if (message.getCaller().getSideLevel() < message.getCallee().getSideLevel()) {
                this.setRightEndpoint(message.getCaller().getView());
            } else {
                this.setRightEndpoint(message.getCallee().getView());
            }
        } else {
            int p = message.getCallee().getPosition();
            if (p < message.getDiagram().getNumberOfLifelines() - 1 && message.getDiagram().getLifelineAt(p + 1).isAlive()) {
                this.setRightEndpoint(message.getCallee().getRightNeighbour().getView());
            } else {
                this.setRightEndpoint((Line)message.getDiagram().getPaintDevice().callSpecial("getRightBound", null));
            }
            if (message.getCaller().getSideLevel() < message.getCallee().getSideLevel()) {
                this.setLeftEndpoint(message.getCaller().getView());
            } else {
                this.setLeftEndpoint(message.getCallee().getView());
            }
        }
    }

    @Override
    protected void drawObject(Graphics2D g) {
        Font font = g.getFont();
        g.setFont(this.getFont(font));
        this.drawMultilineString(g, this.getFontColor(), this.textPoint.x, this.textPoint.y, this.getBackgroundColor());
        g.setFont(font);
        g.setColor(this.getColor());
        int sgn = this.getAlign() == Direction.RIGHT ? 1 : -1;
        g.setStroke(this.getStroke() == ArrowStroke.SOLID ? this.solid() : this.dashed());
        UIUtilities.drawPolyline(g, this.pts);
        this.drawArrowHead(g, this.pts[3].x, this.pts[3].y, sgn);
    }

    @Override
    public int getInnerHeight() {
        return this.textHeight();
    }

    public Point[] getLinePoints() {
        return this.pts;
    }

    @Override
    public Point getAnchor() {
        return this.pts[1];
    }

    @Override
    public void computeLayoutInformation() {
        int x_to;
        int x_from;
        int y_to = this.getTop() + this.textHeight();
        int y_from = this.getTop();
        if (this.getAlign() == Direction.RIGHT) {
            x_from = this.from.getLeft() + this.from.getWidth();
            x_to = this.to.getLeft() + this.to.getWidth();
            this.setLeft(Math.min(x_from, x_to));
        } else {
            x_from = this.from.getLeft();
            x_to = this.to.getLeft();
            this.setLeft(Math.min(x_from - this.getWidth(), x_to - this.getWidth()));
        }
        int outer_x = this.getAlign() == Direction.RIGHT ? Math.max(x_to + this.xExtent, x_from + this.xExtent) : Math.min(x_to - this.xExtent, x_from - this.xExtent);
        this.pts = new Point[4];
        this.pts[0] = new Point(x_from, y_from);
        this.pts[1] = new Point(outer_x, y_from);
        this.pts[2] = new Point(outer_x, y_to);
        this.pts[3] = new Point(x_to, y_to);
        int textOffset = this.getAlign() == Direction.RIGHT ? this.diagram().messagePadding : -this.textWidth() - this.diagram().messagePadding;
        int textY = this.isAnswer ? y_to : y_from + this.textHeight();
        this.textPoint = new Point(outer_x + textOffset, textY);
    }
}

