/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.jsondirect;

import java.lang.reflect.Field;
import org.apache.groovy.json.FastStringService;
import org.apache.groovy.json.FastStringServiceFactory;
import org.apache.groovy.jsondirect.DirectFastStringService;
import sun.misc.Unsafe;

public class DirectFastStringServiceFactory
implements FastStringServiceFactory {
    static final Unsafe UNSAFE;
    static final long STRING_VALUE_FIELD_OFFSET;
    private static final boolean ENABLED;
    static final boolean WRITE_TO_FINAL_FIELDS;
    private static final boolean DISABLE;

    private static Unsafe loadUnsafe() {
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            return (Unsafe)unsafeField.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static long getFieldOffset(String fieldName) {
        if (ENABLED) {
            try {
                return UNSAFE.objectFieldOffset(String.class.getDeclaredField(fieldName));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return -1L;
    }

    public FastStringService getService() {
        if (STRING_VALUE_FIELD_OFFSET != -1L && DirectFastStringServiceFactory.valueFieldIsCharArray()) {
            return new DirectFastStringService();
        }
        return null;
    }

    private static boolean valueFieldIsCharArray() {
        Object o = UNSAFE.getObject("", STRING_VALUE_FIELD_OFFSET);
        return o instanceof char[];
    }

    static {
        WRITE_TO_FINAL_FIELDS = Boolean.parseBoolean(System.getProperty("groovy.json.faststringutils.write.to.final.fields", "false"));
        DISABLE = Boolean.parseBoolean(System.getProperty("groovy.json.faststringutils.disable", "false"));
        UNSAFE = DISABLE ? null : DirectFastStringServiceFactory.loadUnsafe();
        ENABLED = UNSAFE != null;
        STRING_VALUE_FIELD_OFFSET = DirectFastStringServiceFactory.getFieldOffset("value");
    }
}

