/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.dialogs.properties.CopyAllKeyValueAction;
import org.openstreetmap.josm.gui.dialogs.properties.CopyKeyValueAction;
import org.openstreetmap.josm.gui.dialogs.properties.CopyValueAction;
import org.openstreetmap.josm.gui.dialogs.properties.HelpTagAction;
import org.openstreetmap.josm.gui.dialogs.properties.TaginfoAction;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.HistoryViewerPanel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.TagInfoTransferHandler;
import org.openstreetmap.josm.gui.history.TagTableColumnModel;
import org.openstreetmap.josm.gui.history.TagTableModel;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;

public class TagInfoViewer
extends HistoryViewerPanel {
    public TagInfoViewer(HistoryBrowserModel model) {
        super(model);
    }

    @Override
    protected JTable buildReferenceTable() {
        return this.buildTable(PointInTimeType.REFERENCE_POINT_IN_TIME, "table.referencetagtable", this.model::getReferencePointInTime);
    }

    @Override
    protected JTable buildCurrentTable() {
        return this.buildTable(PointInTimeType.CURRENT_POINT_IN_TIME, "table.currenttagtable", this.model::getCurrentPointInTime);
    }

    private JTable buildTable(PointInTimeType pointInTime, String name, Supplier<HistoryOsmPrimitive> histoSp) {
        TagTableModel tagTableModel = this.model.getTagTableModel(pointInTime);
        JTable table = new JTable(tagTableModel, new TagTableColumnModel());
        table.setName(name);
        table.setSelectionMode(0);
        this.selectionSynchronizer.participateInSynchronizedSelection(table.getSelectionModel());
        table.setTransferHandler(new TagInfoTransferHandler());
        table.addFocusListener(new RepaintOnFocusChange());
        JPopupMenu tagMenu = new JPopupMenu();
        IntFunction<String> tagKeyFn = x -> (String)table.getValueAt(x, 0);
        IntFunction<Map<String, Integer>> tagValuesFn = x -> {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            String key = tagTableModel.getValue((String)table.getValueAt(x, 0));
            if (key != null) {
                map.put(key, 1);
            }
            return map;
        };
        Supplier<Collection<? extends Tagged>> objectSp = () -> Arrays.asList((HistoryOsmPrimitive)histoSp.get());
        tagMenu.add(this.trackJosmAction(new CopyValueAction(table, tagKeyFn, objectSp)));
        tagMenu.add(this.trackJosmAction(new CopyKeyValueAction(table, tagKeyFn, objectSp)));
        tagMenu.add(this.trackJosmAction(new CopyAllKeyValueAction(table, tagKeyFn, objectSp)));
        tagMenu.addSeparator();
        tagMenu.add(this.trackJosmAction(new HelpTagAction(table, tagKeyFn, tagValuesFn)));
        tagMenu.add(this.trackJosmAction(new TaginfoAction(table, tagKeyFn, tagValuesFn, null, null)));
        table.addMouseListener(new PopupMenuLauncher(tagMenu));
        return table;
    }

    private static final class RepaintOnFocusChange
    implements FocusListener {
        private RepaintOnFocusChange() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            RepaintOnFocusChange.repaintSelected(e);
        }

        @Override
        public void focusGained(FocusEvent e) {
            RepaintOnFocusChange.repaintSelected(e);
        }

        private static void repaintSelected(FocusEvent e) {
            e.getComponent().repaint();
        }
    }
}

