#------------------------------------------------------------------------------
# File:         ru.pm
#
# Description:  ExifTool Russian language translations
#
# Notes:        This file generated automatically by Image::ExifTool::TagInfoXML
#------------------------------------------------------------------------------

package Image::ExifTool::Lang::ru;

use strict;
use vars qw($VERSION);

$VERSION = '1.06';

%Image::ExifTool::Lang::ru::Translate = (
   'A100DataOffset' => 'Смещение данных (Sony A100)',
   'ARMIdentifier' => 'Идентификатор ARM',
   'ARMVersion' => 'Версия ARM',
   'Acceleration' => 'Ускорение',
   'ActionAdvised' => {
      Description => 'Рекомендуемое действие',
      PrintConv => {
        'Object Append' => 'Добавить объект',
        'Object Kill' => 'Уничтожить объект',
        'Object Reference' => 'Ссылка на объект',
        'Object Replace' => 'Заменить объект',
      },
    },
   'ActiveArea' => 'Активная область',
   'Address' => 'Адресс',
   'AdventRevision' => 'Проверка появления',
   'AdventScale' => 'Масштаб появления',
   'AffineTransformMat' => 'Аффинное матричное преобразование',
   'Album' => 'Альбом',
   'AliasLayerMetadata' => 'Псевдоним метаданных слоя',
   'AlphaByteCount' => 'Число байтов альфа-канала',
   'AlphaDataDiscard' => {
      Description => 'Отброшенные данные альфа-канала',
      PrintConv => {
        'Flexbits Discarded' => 'Гибкие биты отброшены',
        'Full Resolution' => 'Полное разрешение',
        'HighPass Frequency Data Discarded' => 'Данные высоких частот отброшены',
        'Highpass and LowPass Frequency Data Discarded' => 'Данные высоких и низких частот отброшены',
      },
    },
   'AlphaOffset' => 'Смещение альфа-канала',
   'AmbientTemperature' => 'Температура окружающей среды',
   'AnalogBalance' => 'Аналоговый баланс белого',
   'Annotation' => 'Примечание',
   'AnnotationUsageRights' => 'Право использования примечания',
   'Annotations' => 'Примечания',
   'AntiAliasStrength' => 'Сила сглаживания',
   'Aperture' => 'Диафрагма',
   'ApertureValue' => 'Значение диафрагмы',
   'AppleKeywords' => 'Ключевые слова Apple',
   'ApplicationNotes' => 'Заметки приложения',
   'ApplicationRecordVersion' => 'Версия записи приложения',
   'Artist' => 'Артист',
   'AsShotICCProfile' => 'ICC-профиль при съёмке',
   'AsShotNeutral' => 'Нейтральный цвет при съёмке',
   'AsShotPreProfileMatrix' => 'Предварительный профиль матрицы при съёмке',
   'AsShotProfileName' => 'Имя профиля при съёмке',
   'AsShotWhiteXY' => 'XY белого при съёмке',
   'AudioDuration' => 'Продолжительность аудио',
   'AudioOutcue' => 'Выходной сигнал аудио',
   'AudioSamplingRate' => 'Частота дискретизации аудио',
   'AudioSamplingResolution' => 'Разрядность дискретизации аудио',
   'AudioType' => {
      Description => 'Тип аудио',
      PrintConv => {
        'Mono Actuality' => 'Моно — Реальность',
        'Mono Music' => 'Моно — Музыка',
        'Mono Question and Answer Session' => 'Моно — Сессия вопроса и ответа',
        'Mono Raw Sound' => 'Моно — Сырой звук',
        'Mono Response to a Question' => 'Моно — Ответ на вопрос',
        'Mono Scener' => 'Моно — Сценер',
        'Mono Voicer' => 'Моно — Рупор',
        'Mono Wrap' => 'Моно — Обёртка',
        'Stereo Actuality' => 'Стерео — Реальность',
        'Stereo Music' => 'Стерео — Музыка',
        'Stereo Question and Answer Session' => 'Стерео — Сессия вопроса и ответа',
        'Stereo Raw Sound' => 'Стерео — Сырой звук',
        'Stereo Response to a Question' => 'Стерео — Ответ на вопрос',
        'Stereo Scener' => 'Стерео — Сценер',
        'Stereo Voicer' => 'Стерео — Рупор',
        'Stereo Wrap' => 'Стерео — Обёртка',
        'Text Only' => 'Только текст',
      },
    },
   'AuthenticationTime' => 'Время аутентификации',
   'AuthenticationType' => 'Тип аутентификации',
   'Author' => 'Автор',
   'AuthorsPosition' => 'Должность автора',
   'BackgroundColorIndicator' => {
      Description => 'Цвет фона',
      PrintConv => {
        'Specified Background Color' => 'Указанный цвет фона',
        'Unspecified Background Color' => 'Не указанный цвет фона',
      },
    },
   'BackgroundColorValue' => 'Значение цвета фона',
   'BadFaxLines' => 'Количество битых строк',
   'BaselineExposure' => 'Базовая экспозиция',
   'BaselineExposureOffset' => 'Сдвиг базовой экспозиции',
   'BaselineNoise' => 'Базовый уровень шума',
   'BaselineSharpness' => 'Базовая чёткость',
   'BatteryLevel' => 'Уровень заряда аккумулятора',
   'BayerGreenSplit' => 'Разделение зелёных каналов в матрице Байера',
   'BestQualityScale' => 'Оптимальный масштаб',
   'BitsPerComponent' => 'Количество бит на компонент',
   'BitsPerExtendedRunLength' => 'Число битов для кодирования длины длинного запуска',
   'BitsPerRunLength' => 'Число битов для кодирования длины короткого запуска',
   'BitsPerSample' => 'Количество бит на компонент',
   'BlackLevel' => 'Уровень чёрного',
   'BlackLevelBlue' => 'Уровень чёрного — Синий',
   'BlackLevelDeltaH' => 'Уровень чёрного — Delta H',
   'BlackLevelDeltaV' => 'Уровень чёрного — Delta V',
   'BlackLevelGreen' => 'Уровень чёрного — Зелёный',
   'BlackLevelRed' => 'Уровень чёрного — Красный',
   'BlackLevelRepeatDim' => 'Уровень чёрного — Повтор размера патерна',
   'BlueBalance' => 'Баланс синего',
   'BookTitle' => 'Название книги',
   'Brightness' => 'Яркость',
   'BrightnessValue' => 'Значение яркость',
   'By-line' => 'Автор',
   'By-lineTitle' => 'Титул автора',
   'CFALayout' => {
      Description => 'Макет CFA',
      PrintConv => {
        'Even columns offset down 1/2 row' => 'Чётные столбцы смещены вниз на 1/2 строки',
        'Even columns offset up 1/2 row' => 'Чётные столбцы смещены вверх 1/2 строки',
        'Even rows offset down by 1/2 row, even columns offset left by 1/2 column' => 'Чётные строки смещены вниз на 1/2 строки, чётные столбцы смещены влево на 1/2 столбца',
        'Even rows offset down by 1/2 row, even columns offset right by 1/2 column' => 'Чётные строки смещены вниз на 1/2 строки, чётные столбцы смещены вправо на 1/2 столбца',
        'Even rows offset left 1/2 column' => 'Чётные строки смещены влево на 1/2 столбца',
        'Even rows offset right 1/2 column' => 'Чётные строки смещены вправо на 1/2 столбца',
        'Even rows offset up by 1/2 row, even columns offset left by 1/2 column' => 'Чётные строки смещены вверх на 1/2 строки, чётные столбцы смещены влево на 1/2 столбца',
        'Even rows offset up by 1/2 row, even columns offset right by 1/2 column' => 'Чётные строки смещены вверх на 1/2 строки, чётные столбцы смещены вправо на 1/2 столбца',
        'Rectangular' => 'Прямоугольная компоновка',
      },
    },
   'CFAPattern' => {
      Description => 'Образец CFA',
      PrintConv => {
        '[Blue,Green][Green,Red]' => '[Синий, Зелёный][Зелёный, Красный]',
        '[Green,Blue][Red,Green]' => '[Зелёный, Синий][Красный, Зелёный]',
        '[Green,Red][Blue,Green]' => '[Зелёный, Красный][Синий, Зелёный]',
        '[Red,Green][Green,Blue]' => '[Красный, Зелёный][Зелёный, Синий]',
        'n/a' => 'Недоступно',
      },
    },
   'CFAPattern2' => 'Образец CFA 2',
   'CFAPlaneColor' => 'Цветовые плоскости CFA',
   'CFARepeatPatternDim' => 'Повторяющиеся образцы CFA',
   'CIP3DataFile' => 'Файл данных CIP3',
   'CIP3Sheet' => 'Лист CIP3',
   'CIP3Side' => 'Сторона CIP3',
   'CMYKEquivalent' => 'Эквивалент CMYK',
   'CR2CFAPattern' => {
      Description => 'CR2-образец CFA',
      PrintConv => {
        '[Blue,Green][Green,Red]' => '[Синий, Зеленый][Зеленый, Красный]',
        '[Green,Blue][Red,Green]' => '[Зеленый, Синий][Красный, Зеленый]',
        '[Green,Red][Blue,Green]' => '[Зеленый, Красный][Синий, Зеленый]',
        '[Red,Green][Green,Blue]' => '[Красный, Зеленый][Зеленый, Синий]',
      },
    },
   'CacheVersion' => 'Версия кэша',
   'CalibrationIlluminant1' => {
      Description => 'Калибровочное освещение 1',
      PrintConv => {
        'Cloudy' => 'Облачно (6500 К)',
        'Cool White Fluorescent' => 'Флуоресцентная лампа — Холодный свет (4150 К)',
        'D50' => 'D50 (5000 К)',
        'D55' => 'D55 (5500 К)',
        'D65' => 'D65 (6500 К)',
        'D75' => 'D75 (7500 К)',
        'Day White Fluorescent' => 'Флуоресцентная лампа — Дневной белый (5050 К)',
        'Daylight' => 'Дневной свет (5500 К)',
        'Daylight Fluorescent' => 'Флуоресцентная лампа дневного света (6400 К)',
        'Fine Weather' => 'Ясная погода (5500 К)',
        'Flash' => 'Вспышка (5500 К)',
        'Fluorescent' => 'Флуоресцентная лампа (4150 К)',
        'ISO Studio Tungsten' => 'Студийная лампа накаливания (3200 К)',
        'Other' => 'Другой источник света',
        'Shade' => 'Тень (7500 К)',
        'Standard Light A' => 'Стандартное освещение A (2850 К)',
        'Standard Light B' => 'Стандартное освещение B (5500 К)',
        'Standard Light C' => 'Стандартное освещение C (6500 К)',
        'Tungsten (Incandescent)' => 'Лампа накаливания (2850 К)',
        'Unknown' => 'Неизвестно',
        'Warm White Fluorescent' => 'Флуоресцентная лампа — Тёплый свет (2925 К)',
        'White Fluorescent' => 'Флуоресцентная лампа — Белый свет (3525 К)',
      },
    },
   'CalibrationIlluminant2' => {
      Description => 'Калибровочное освещение 2',
      PrintConv => {
        'Cloudy' => 'Облачно (6500 К)',
        'Cool White Fluorescent' => 'Флуоресцентная лампа — Холодный свет (4150 К)',
        'D50' => 'D50 (5000 К)',
        'D55' => 'D55 (5500 К)',
        'D65' => 'D65 (6500 К)',
        'D75' => 'D75 (7500 К)',
        'Day White Fluorescent' => 'Флуоресцентная лампа — Дневной белый (5050 К)',
        'Daylight' => 'Дневной свет (5500 К)',
        'Daylight Fluorescent' => 'Флуоресцентная лампа дневного света (6400 К)',
        'Fine Weather' => 'Ясная погода (5500 К)',
        'Flash' => 'Вспышка (5500 К)',
        'Fluorescent' => 'Флуоресцентная лампа (4150 К)',
        'ISO Studio Tungsten' => 'Студийная лампа накаливания (3200 К)',
        'Other' => 'Другой источник света',
        'Shade' => 'Тень (7500 К)',
        'Standard Light A' => 'Стандартное освещение A (2850 К)',
        'Standard Light B' => 'Стандартное освещение B (5500 К)',
        'Standard Light C' => 'Стандартное освещение C (6500 К)',
        'Tungsten (Incandescent)' => 'Лампа накаливания (2850 К)',
        'Unknown' => 'Неизвестно',
        'Warm White Fluorescent' => 'Флуоресцентная лампа — Тёплый свет (2925 К)',
        'White Fluorescent' => 'Флуоресцентная лампа — Белый свет (3525 К)',
      },
    },
   'CameraCalibration1' => 'Калибровочная матрица фотокамеры 1',
   'CameraCalibration2' => 'Калибровочная матрица фотокамеры 2',
   'CameraCalibrationSig' => 'Сигнатура калибровки камеры',
   'CameraElevationAngle' => 'Угол обзора камеры',
   'CameraLabel' => 'Название камеры',
   'CameraSerialNumber' => 'Серийный номер камеры',
   'Caption-Abstract' => 'Подробное описание',
   'CaptionWriter' => 'Автор подписи',
   'CatalogSets' => 'Наборы каталога',
   'Categories' => 'Категории',
   'Category' => 'Категория',
   'CellLength' => 'Длина матрицы дизеринга или полутонирования',
   'CellWidth' => 'Ширина матрицы дизеринга или полутонирования',
   'Chapter' => 'Часть',
   'ChromaBlurRadius' => 'Радиус сглаживания цветности',
   'ChromaticAberrationCorrParams' => 'Параметры коррекции хроматической аберрации',
   'ChromaticAberrationCorrection' => {
      Description => 'Коррекция хроматической аберрации',
      PrintConv => {
        'Auto' => 'Автоматическая',
        'No correction params available' => 'Недоступна',
        'Off' => 'Отключена',
      },
    },
   'City' => 'Город происхождения данных',
   'ClassifyState' => 'Класификация структуры',
   'CleanFaxData' => {
      Description => 'Наличие битых строк',
      PrintConv => {
        'Clean' => 'Без битых строк',
        'Regenerated' => 'Битые строки восстановлены',
        'Unclean' => 'Битые строки не восстановлены',
      },
    },
   'ClipPath' => 'Обтравочный контур',
   'CodedCharacterSet' => 'Кодовый набор символов',
   'CodingMethods' => {
      Description => 'Метод сжатия',
      PrintConv => {
        'Baseline JPEG' => 'Базовое JPEG',
        'JBIG color' => 'Цветное JBIG',
        'Modified Huffman' => 'Одномерное — Модификация Хаффмана',
        'Modified MR' => 'Двумерное — Modified Modified READ',
        'Modified Read' => 'Двумерное — Modified READ',
        'Unspecified compression' => 'Не указанное сжатие',
      },
    },
   'ColorCalibrationMatrix' => 'Матрица калибровки цвета',
   'ColorCharacterization' => 'Спецификации цвета',
   'ColorEffect' => {
      PrintConv => {
        'Sepia' => 'Сепия',
      },
    },
   'ColorFilter' => 'Цветовой фильтр',
   'ColorMap' => 'Карта цветов',
   'ColorMatrix1' => 'Цветовая матрица 1',
   'ColorMatrix2' => 'Цветовая матрица 2',
   'ColorMode' => {
      Description => 'Творческий Стиль',
      PrintConv => {
        'Autumn Leaves' => 'Осенние листья',
        'B&W' => 'Чёрно-белое',
        'Clear' => 'Прозрачный',
        'Deep' => 'Глубокий',
        'Landscape' => 'Пейзаж',
        'Light' => 'Бледный',
        'Neutral' => 'Нейтральный',
        'Night View' => 'Ночной вид',
        'Night View/Portrait' => 'Ночной вид/портрет',
        'Portrait' => 'Портрет',
        'Standard' => 'Стандартное',
        'Sunset' => 'Закат',
        'Vivid' => 'Яркий цвет',
      },
    },
   'ColorPalette' => 'Цветовая палитра',
   'ColorRepresentation' => {
      Description => 'Цветовое представление',
      PrintConv => {
        '3 Components, Frame Sequential in Multiple Objects' => '3 компонента. Последовательность кадров в нескольких объектах',
        '3 Components, Frame Sequential in One Object' => '3 компонента. Последовательность кадров в одном объекте',
        '3 Components, Line Sequential' => '3 компонента. Последовательная строка',
        '3 Components, Pixel Sequential' => '3 компонента. Последовательность пикселей',
        '3 Components, Single Frame' => '3 компонента. Один кадр',
        '3 Components, Special Interleaving' => '3 компонента. Специальное чередование',
        '4 Components, Frame Sequential in Multiple Objects' => '4 компонента. Последовательность кадров в нескольких объектах',
        '4 Components, Frame Sequential in One Object' => '4 компонента. Последовательность кадров в одном объекте',
        '4 Components, Line Sequential' => '4 компонента. Последовательная строка',
        '4 Components, Pixel Sequential' => '4 компонента. Последовательность пикселей',
        '4 Components, Single Frame' => '4 компонента. Один кадр',
        '4 Components, Special Interleaving' => '4 компонента. Специальное чередование',
        'Monochrome, Single Frame' => 'Монохромное. Один кадр',
        'No Image, Single Frame' => 'Нет изображения. Один кадр',
      },
    },
   'ColorResponseUnit' => 'Единицы цветовой чувствительности',
   'ColorSequence' => 'Последовательность цветов',
   'ColorSpace' => {
      Description => 'Цветовое пространство',
      PrintConv => {
        'ICC Profile' => 'ICC-профиль',
        'Uncalibrated' => 'Некалиброванный',
      },
    },
   'ColorTable' => 'Таблица цвета',
   'ColorTemperature' => 'Цветовая температура',
   'ColorimetricReference' => 'Колориметрический эталон',
   'Comment' => 'Комментарий',
   'ComponentsConfiguration' => 'Параметры каналов',
   'CompositeImage' => {
      Description => 'Составное изображение',
      PrintConv => {
        'Composite Image Captured While Shooting' => 'Полученное во время съёмки',
        'General Composite Image' => 'Созданное в редакторе',
        'Not a Composite Image' => 'Не составное изображение',
        'Unknown' => 'Неизвестно',
      },
    },
   'CompositeImageCount' => 'Составное изображение — Количество',
   'CompositeImageExposureTimes' => 'Составное изображение — Выдержка',
   'CompressedBitsPerPixel' => 'Сжатые биты на пиксель',
   'Compression' => {
      Description => 'Метод сжатия',
      PrintConv => {
        'JPEG (old-style)' => 'JPEG (старый стиль)',
        'Uncompressed' => 'Несжатый',
      },
    },
   'ConfirmedObjectSize' => 'Подтверждённый размер объекта',
   'ConsecutiveBadFaxLines' => 'Количество последовательных битых строк',
   'Contact' => 'Контакт',
   'ContainerVersion' => 'Версия контейнера',
   'ContentLocationCode' => 'Контент — Код страны',
   'ContentLocationName' => 'Контент — Страна',
   'Contrast' => {
      Description => 'Контрастность',
      PrintConv => {
        'High' => 'Высокая',
        'Low' => 'Низкая',
        'Normal' => 'Обычная',
      },
    },
   'Converter' => 'Конвертер',
   'Copyright' => 'Авторское право',
   'CopyrightNotice' => 'Уведомление об авторских правах',
   'Country' => 'Страна',
   'Country-PrimaryLocationCode' => 'Код страны',
   'Country-PrimaryLocationName' => 'Страна',
   'CreateDate' => 'Дата создания',
   'CreationDate' => 'Дата создания',
   'Creator' => 'Создавшее приложение',
   'CreatorVersion' => 'Версия создавшего приложения',
   'Credit' => 'Поставщик',
   'CropBottom' => 'Обрезка снизу',
   'CropLeft' => 'Обрезка слева',
   'CropRight' => 'Обрезка справа',
   'CropTop' => 'Обрезка сверху',
   'CurrentICCProfile' => 'Текущий ICC-профиль',
   'CurrentPreProfileMatrix' => 'Текущий предварительный профиль матрицы',
   'CustomRendered' => {
      Description => 'Пользовательский рендеринг',
      PrintConv => {
        'Custom' => 'Пользовательский',
        'Normal' => 'Обычный',
        'Panorama' => 'Панорама',
        'Portrait' => 'Портрет',
      },
    },
   'DNGAdobeData' => 'DNG — Данные Adobe',
   'DNGBackwardVersion' => 'DNG — Совместимая версия',
   'DNGLensInfo' => 'Минимальное фокусное расстояние',
   'DNGPrivateData' => 'DNG — Данные производителя',
   'DNGVersion' => 'DNG — Версия',
   'DataCompressionMethod' => 'Метод сжатия данных',
   'DataType' => 'Тип данных',
   'DateCreated' => 'Дата создания',
   'DateSent' => 'Дата отправления',
   'DateTimeOriginal' => 'Дата съёмки',
   'Decode' => 'Декодирование',
   'DefaultBlackRender' => {
      Description => 'Приведение чёрного по-умолчанию',
      PrintConv => {
        'Auto' => 'Автоматически',
        'None' => 'Никак',
      },
    },
   'DefaultCropOrigin' => 'Положение обрезанного изображения по-умолчанию',
   'DefaultCropSize' => 'Размер обрезанного изображения по-умолчанию',
   'DefaultImageColor' => 'Цвет изображения по-умолчанию',
   'DefaultScale' => 'Массштаб по-умолчанию',
   'DefaultUserCrop' => 'Область обрезки по умолчанию',
   'Destination' => 'Назначение',
   'DeviceSettingDescription' => 'Описание предустановок камеры',
   'DigitalCreationDate' => 'Дата создания файла',
   'DigitalCreationTime' => 'Время создания файла',
   'DigitalZoom' => 'Цифровое увеличение',
   'DigitalZoomRatio' => 'Коэффициент цифрового увеличения',
   'Directory' => 'Каталог',
   'DistortionCorrParams' => 'Параметры коррекции дисторсии',
   'DistortionCorrection' => {
      Description => 'Коррекция дисторсии',
      PrintConv => {
        'Auto' => 'Автоматическая',
        'Auto fixed by lens' => 'Автоматическая по объективу',
        'No correction params available' => 'Корректирующие параметры недоступны',
        'Off' => 'Отключена',
      },
    },
   'DjVuVersion' => 'Версия DjVu',
   'DocumentHistory' => 'История документа',
   'DocumentName' => 'Имя документа',
   'DocumentNotes' => 'Комментарии к документу',
   'DocumentUsageRights' => 'Права на использование документа',
   'DotRange' => 'Значения компонента соответствующих точке',
   'DriveMode' => 'Режим спуска',
   'DynamicRangeOptimizer' => {
      Description => 'Оптимизатор динамического диапазона',
      PrintConv => {
        'Advanced Auto' => 'Продвинутый автоматический',
        'Advanced Lv1' => 'Продвинутый 1-го уровня',
        'Advanced Lv2' => 'Продвинутый 2-го уровня',
        'Advanced Lv3' => 'Продвинутый 3-го уровня',
        'Advanced Lv4' => 'Продвинутый 4-го уровня',
        'Advanced Lv5' => 'Продвинутый 5-го уровня',
        'Auto' => 'Автоматический',
        'Off' => 'Отключён',
        'Standard' => 'Стандартный',
      },
    },
   'EditStatus' => 'Статус редактирования',
   'Edition' => 'Издание',
   'EditorialUpdate' => {
      Description => 'Тип обновления',
      PrintConv => {
        'Additional language' => 'Дополнительный язык',
      },
    },
   'EmbeddedFileUsageRights' => 'Права на использование встроенных файлов',
   'EmbeddedImage' => 'Встроенное изображение',
   'EmbeddedImageColorSpace' => 'Встроенное изображение — Цветовое пространство',
   'EmbeddedImageFilter' => 'Встроенное изображение — Фильтр',
   'EmbeddedImageHeight' => 'Встроенное изображение — Высота',
   'EmbeddedImageWidth' => 'Встроенное изображение — Ширина',
   'Encryption' => 'Шифрование',
   'EndPoints' => 'Конечные точки',
   'EnvelopeNumber' => 'Номер конверта',
   'EnvelopePriority' => {
      Description => 'Приоритет конверта',
      PrintConv => {
        '0 (reserved)' => '0 (зарезервирован)',
        '1 (most urgent)' => '1 (неотложный)',
        '5 (normal urgency)' => '5 (обычный)',
        '8 (least urgent)' => '8 (несрочный)',
        '9 (user-defined priority)' => '9 (пользовательский приоритет)',
      },
    },
   'EnvelopeRecordVersion' => 'Версия записи конверта',
   'ExcursionTolerance' => {
      Description => 'Выход за пределы диапазона',
      PrintConv => {
        'Allowed' => 'Допускается',
        'Not Allowed' => 'Не допускается',
      },
    },
   'ExifCameraInfo' => 'Сведения о камере из Exif',
   'ExifImageHeight' => 'Exif — Высота изображения',
   'ExifImageWidth' => 'Exif — Ширина изображения',
   'ExifOffset' => 'Exif IFD указатель',
   'ExifVersion' => 'Версия Exif',
   'ExpandFilm' => 'Expand — Плёнка',
   'ExpandFilterLens' => 'Expand — Фильтр объектива',
   'ExpandFlashLamp' => 'Expand — Вспышка',
   'ExpandLens' => 'Expand — Объектив',
   'ExpandScanner' => 'Expand — Сканер',
   'ExpandSoftware' => 'Expand — Приложение',
   'ExpirationDate' => 'Дата истечения срока',
   'ExpirationTime' => 'Время истечения срока',
   'Exposure' => 'Экспозиция',
   'ExposureCompensation' => 'Компенсация экспозиции',
   'ExposureIndex' => 'Индекс экспозиции',
   'ExposureMode' => {
      Description => 'Режим экспозиции',
      PrintConv => {
        'Auto' => 'Автоэкспозиция',
        'Auto bracket' => 'Автобрекетинг',
        'Manual' => 'Ручная экспозиция',
      },
    },
   'ExposureProgram' => {
      Description => 'Программа экспозиции',
      PrintConv => {
        'Action (High speed)' => 'Спорт',
        'Aperture-priority AE' => 'Автоэкспозиция с приоритетом диафрагмы',
        'Bulb' => 'Выдержка от руки',
        'Creative (Slow speed)' => 'Творческая',
        'Landscape' => 'Пейзаж',
        'Manual' => 'Ручная',
        'Not Defined' => 'Не определена',
        'Portrait' => 'Портрет',
        'Program AE' => 'Программная автоэкспозиция',
        'Shutter speed priority AE' => 'Автоэкспозиция с приоритетом выдержки',
      },
    },
   'ExposureTime' => 'Выдержка',
   'ExtraSamples' => {
      Description => 'Описание дополнительных компонентов',
      PrintConv => {
        'Associated Alpha' => 'Связаные альфа-данные',
        'Unassociated Alpha' => 'Несвязанные альфа-данные',
        'Unspecified' => 'Не указаны',
      },
    },
   'FNumber' => 'Относительное отверстие',
   'FaceOrientation' => {
      PrintConv => {
        'Horizontal (normal)' => 'Горизонтально (обычно)',
        'Rotate 180' => 'Поворот на 180°',
        'Rotate 270 CW' => 'Поворот на 270° по часовой стрелке',
        'Rotate 90 CW' => 'Поворот на 90° по часовой стрелке',
      },
    },
   'FaxProfile' => {
      Description => 'Факс-профиль',
      PrintConv => {
        'Extended B&W lossless, F' => 'Расширенный чёрно-белый без потерь, профиль F',
        'Lossless JBIG B&W, J' => 'JBIG чёрно-белый без потерь, профиль J',
        'Lossless color and grayscale, L' => 'Цветной и с оттенками серого без потерь, профиль L',
        'Lossy color and grayscale, C' => 'Цветной и с оттенками серого с потерями, профиль C',
        'Minimal B&W lossless, S' => 'Минимальный чёрно-белый без потерь, профиль S',
        'Mixed raster content, M' => 'Смешанное содержимое растра, профиль M',
        'Multi Profiles' => 'Несколько профилей',
        'Profile T' => 'Профиль T',
        'Unknown' => 'Неизвестно',
      },
    },
   'FaxRecvParams' => 'Параметры получения факсов',
   'FaxRecvTime' => 'Требуемое время для получения факса',
   'FaxSubAddress' => 'Подадрес факса',
   'FieldPermissions' => {
      Description => 'Разрешения доступа к полям',
      PrintConv => {
        'Allow changes to specified form fields' => 'Разрешить изменения в указанных полях формы',
        'Disallow changes to all form fields' => 'Запретить изменения во всех полях формы',
        'Disallow changes to specified form fields' => 'Запретить изменения в указанных полях формы',
      },
    },
   'FileFormat' => 'Формат файла',
   'FileModifyDate' => 'Дата обновления',
   'FileName' => 'Имя файла',
   'FileSize' => 'Размер файла',
   'FileSource' => {
      Description => 'Источник файла',
      PrintConv => {
        'Digital Camera' => 'Цифровая фотокамера',
        'Film Scanner' => 'Плёночный сканер',
        'Reflection Print Scanner' => 'Планшетный сканер',
        'Sigma Digital Camera' => 'Цифровая фотокамера Sigma',
      },
    },
   'FileType' => 'Тип файла',
   'FileVersion' => 'Версия файла',
   'Filename' => 'Имя файла',
   'FillOrder' => {
      Description => 'Порядок битов в байте',
      PrintConv => {
        'Normal' => 'Обычный',
        'Reversed' => 'Обратный',
      },
    },
   'FixtureIdentifier' => 'Узнаваемый идентификатор',
   'Flash' => {
      Description => 'Состояние вспышки при съёмке',
      PrintConv => {
        'Auto, Did not fire' => 'Автоматический режим. Вспышка не сработала',
        'Auto, Did not fire, Red-eye reduction' => 'Автоматический режим. Вспышка не сработала. Включён режим уменьшения эффекта «красных глаз»',
        'Auto, Fired' => 'Автоматический режим. Вспышка сработала',
        'Auto, Fired, Red-eye reduction' => 'Автоматический режим. Вспышка сработала',
        'Auto, Fired, Red-eye reduction, Return detected' => 'Автоматический режим. Вспышка сработала. Включён режим уменьшения эффекта «красных глаз». Отражённый свет обнаружен',
        'Auto, Fired, Red-eye reduction, Return not detected' => 'Автоматический режим. Вспышка сработала. Включён режим уменьшения эффекта «красных глаз». Отражённый свет не обнаружен',
        'Auto, Fired, Return detected' => 'Автоматический режим. Вспышка сработала. Отражённый свет обнаружен',
        'Auto, Fired, Return not detected' => 'Автоматический режим. Вспышка сработала. Отражённый свет не обнаружен',
        'Did not fire' => 'Вспышка не сработала',
        'Fired' => 'Вспышка сработала',
        'Fired, Red-eye reduction' => 'Вспышка сработала. Включён режим уменьшения эффекта «красных глаз»',
        'Fired, Red-eye reduction, Return detected' => 'Вспышка сработала. Включён режим уменьшения эффекта «красных глаз». Отражённый свет обнаружен',
        'Fired, Red-eye reduction, Return not detected' => 'Вспышка сработала. Включён режим уменьшения эффекта «красных глаз». Отражённый свет не обнаружен',
        'Fired, Return detected' => 'Вспышка сработала. Отражённый свет обнаружен',
        'Fired, Return not detected' => 'Вспышка сработала. Отражённый свет не обнаружен',
        'No Flash' => 'Без вспышки',
        'No flash function' => 'Функция вспышки не поддерживается',
        'Off, Did not fire' => 'Отключена. Вспышка не сработала',
        'Off, Did not fire, Return not detected' => 'Отключена. Вспышка не сработала. Отражённый свет не обнаружен',
        'Off, No flash function' => 'Вспышка отключена. Функция вспышки не поддерживается',
        'Off, Red-eye reduction' => 'Вспышка отключена. Включён режим уменьшения эффекта «красных глаз»',
        'On, Did not fire' => 'Принудительный режим. Вспышка не сработала',
        'On, Fired' => 'Принудительный режим. Вспышка сработала',
        'On, Red-eye reduction' => 'Принудительный режим. Включён режим уменьшения эффекта «красных глаз»',
        'On, Red-eye reduction, Return detected' => 'Принудительный режим. Включён режим уменьшения эффекта «красных глаз». Отражённый свет обнаружен',
        'On, Red-eye reduction, Return not detected' => 'Принудительный режим. Включён режим уменьшения эффекта «красных глаз». Отражённый свет не обнаружен',
        'On, Return detected' => 'Принудительный режим. Отражённый свет обнаружен',
        'On, Return not detected' => 'Принудительный режим. Отражённый свет не обнаружен',
      },
    },
   'FlashEnergy' => 'Мощность вспышки',
   'FlashExposureComp' => 'Коррекция вспышки',
   'FlashpixVersion' => 'Версия Flashpix',
   'FocalLength' => 'Фокусное расстояние',
   'FocalLength35efl' => 'Эквивалентное (35 мм) фокусное расстояние',
   'FocalLengthIn35mmFormat' => 'Фокусное расстояние для 35-мм формата',
   'FocalPlaneResolutionUnit' => {
      Description => 'Единицы разрешения в фокальной плоскости',
      PrintConv => {
        'None' => 'Никакая',
        'cm' => 'см',
        'inches' => 'дюймы',
        'mm' => 'мм',
        'um' => 'мкм',
      },
    },
   'FocalPlaneXResolution' => 'Разрешение в фокальной плоскости по X',
   'FocalPlaneYResolution' => 'Разрешение в фокальной плоскости по Y',
   'FocusMode' => 'Фокусировка',
   'FormExtraUsageRights' => 'Права на использование форм Extra',
   'FormFields' => 'Поля форм',
   'FormUsageRights' => 'Права на использование форм',
   'ForwardMatrix1' => 'Прямая матрица 1',
   'ForwardMatrix2' => 'Прямая матрица 2',
   'FovCot' => 'Угол обзора и котангенс',
   'FrameRate' => 'Частота кадров',
   'FrameSize' => 'Размер кадра',
   'FreeByteCounts' => 'Количество байтов в строке неиспользуемых байтов',
   'FreeOffsets' => 'Смещение к строке неиспользуемых байтов',
   'GDALMetadata' => 'GDAL — Метаданные',
   'GDALNoData' => 'GDAL — Прозрачность',
   'GPSAltitude' => 'GPS — Высота',
   'GPSAltitudeRef' => {
      Description => 'GPS — Индекс высоты',
      PrintConv => {
        'Above Sea Level' => 'Над уровнем моря',
        'Below Sea Level' => 'Ниже уровня моря',
      },
    },
   'GPSAreaInformation' => 'GPS — Название области',
   'GPSDOP' => 'GPS — Точность измерения',
   'GPSDateStamp' => 'GPS — Дата и время',
   'GPSDestBearing' => 'GPS — Пеленг объекта съёмки',
   'GPSDestBearingRef' => {
      Description => 'GPS — Ориентир пеленга объекта съёмки',
      PrintConv => {
        'Magnetic North' => 'На магнитный северный полюс',
        'True North' => 'На географический северный полюс',
      },
    },
   'GPSDestDistance' => 'GPS — Расстояние до объекта съёмки',
   'GPSDestDistanceRef' => {
      Description => 'GPS — Единицы измерения расстояния',
      PrintConv => {
        'Kilometers' => 'Километры',
        'Miles' => 'Мили',
        'Nautical Miles' => 'Морские мили',
      },
    },
   'GPSDestLatitude' => 'GPS — Широта объекта съёмки',
   'GPSDestLatitudeRef' => {
      Description => 'GPS — Индекс широты объекта съёмки',
      PrintConv => {
        'North' => 'Северная широта',
        'South' => 'Южная широта',
      },
    },
   'GPSDestLongitude' => 'GPS — Долгота объекта съёмки',
   'GPSDestLongitudeRef' => {
      Description => 'GPS — Индекс долготы объекта съёмки',
      PrintConv => {
        'East' => 'Восточная долгота',
        'West' => 'Западная долгота',
      },
    },
   'GPSDifferential' => {
      Description => 'GPS — Дифференциальная поправка',
      PrintConv => {
        'Differential Corrected' => 'Дифференциальная поправка применена',
        'No Correction' => 'Измерение без дифференциальной поправки',
      },
    },
   'GPSHPositioningError' => 'GPS — Ошибка горизонтального позиционирования',
   'GPSImgDirection' => 'GPS — Направления камеры при съёмке',
   'GPSImgDirectionRef' => {
      Description => 'GPS — Ориентир направления камеры',
      PrintConv => {
        'Magnetic North' => 'На магнитный северный полюс',
        'True North' => 'На географический северный полюс',
      },
    },
   'GPSInfo' => 'IFD указатель информации GPS',
   'GPSLatitude' => 'GPS — Широта',
   'GPSLatitudeRef' => {
      Description => 'GPS — Индекс широты',
      PrintConv => {
        'North' => 'Северная широта',
        'South' => 'Южная широта',
      },
    },
   'GPSLongitude' => 'GPS — Долгота',
   'GPSLongitudeRef' => {
      Description => 'GPS — Индекс долготы',
      PrintConv => {
        'East' => 'Восточная долгота',
        'West' => 'Западная долгота',
      },
    },
   'GPSMapDatum' => 'GPS — Система координат',
   'GPSMeasureMode' => {
      Description => 'GPS — Режим измерения GPS',
      PrintConv => {
        '2-Dimensional Measurement' => '2-мерная навигация',
        '3-Dimensional Measurement' => '3-мерная навигация',
      },
    },
   'GPSProcessingMethod' => 'GPS — Метод вычисления положения',
   'GPSSatellites' => 'GPS — Используемые спутники',
   'GPSSpeed' => 'GPS — Скорость передвижения',
   'GPSSpeedRef' => {
      Description => 'GPS — Единицы измерения скорости',
      PrintConv => {
        'km/h' => 'Км/ч',
        'knots' => 'Узлы',
        'mph' => 'Миля/ч',
      },
    },
   'GPSStatus' => {
      Description => 'GPS — Состояние приёмника во время съёмки',
      PrintConv => {
        'Measurement Active' => 'Координаты актуальные',
        'Measurement Void' => 'Актуальных координат нету',
      },
    },
   'GPSTimeStamp' => 'GPS — Время записанных координат',
   'GPSTrack' => 'GPS — Трек',
   'GPSTrackRef' => {
      Description => 'GPS — Ориентир направления',
      PrintConv => {
        'Magnetic North' => 'На магнитный северный полюс',
        'True North' => 'На географический северный полюс',
      },
    },
   'GPSVersionID' => 'GPS — Версия тегов',
   'GainControl' => {
      Description => 'Управление усилением',
      PrintConv => {
        'High gain down' => 'С большим шагом вниз',
        'High gain up' => 'С большим шагом вверх',
        'Low gain down' => 'С малым шагом вниз',
        'Low gain up' => 'С малым шагом вверх',
        'None' => 'Никакое',
      },
    },
   'Gamma' => 'Гамма',
   'GammaCompensatedValue' => 'Значение гамма-компенсации',
   'GeoTiffAsciiParams' => 'Geo Tiff — Параметры Ascii',
   'GeoTiffDirectory' => 'Geo Tiff — Каталог',
   'GeoTiffDoubleParams' => 'Geo Tiff — Параметры дублирования',
   'GooglePlusUploadCode' => 'Код загрузки Google Plus',
   'Gradation' => 'Градация',
   'GrayResponseCurve' => 'Оптическая плотность серого',
   'GrayResponseUnit' => 'Единицы плотности серого',
   'HCUsage' => 'Использование HC',
   'HDR' => {
      Description => 'HDR',
      PrintConv => {
        'Off' => 'Отключён',
      },
    },
   'HalftoneHints' => 'Подсказки полутонов',
   'HasXFA' => {
      Description => 'Имеет XFA',
      PrintConv => {
        'No' => 'Нет',
        'Yes' => 'Да',
      },
    },
   'Headline' => 'Заголовок',
   'HeightResolution' => 'Разрешение по высоте',
   'HighISOMultiplierBlue' => 'Множитель ISO — Синий',
   'HighISOMultiplierGreen' => 'Множитель ISO — Зелёный',
   'HighISOMultiplierRed' => 'Множитель ISO — Красный',
   'HighISONoiseReduction' => {
      Description => 'Шумоподавление при повышенных ISO',
      PrintConv => {
        'Auto' => 'Автоматическое',
        'High' => 'Высокое',
        'Low' => 'Низкое',
        'Normal' => 'Обычное',
        'Off' => 'Отключено',
      },
    },
   'HostComputer' => 'Узловой компьютер',
   'HowPublished' => 'Метод публикации',
   'Hue' => 'Оттенок',
   'Humidity' => 'Влажность',
   'ICC_Profile' => 'ICC-профиль',
   'INGRReserved' => 'INGR — Резерв',
   'IPTCBitsPerSample' => 'IPTC — Количество бит на компонент',
   'IPTCImageHeight' => 'IPTC — Высота изображения',
   'IPTCImageRotation' => {
      Description => 'IPTC — Вращение изображения',
      PrintConv => {
        '0' => 'Не вращать',
        '180' => 'Повернуть вправо на 180°',
        '270' => 'Повернуть вправо на 270°',
        '90' => 'Повернуть вправо на 90°',
      },
    },
   'IPTCImageWidth' => 'IPTC — Ширина изображения',
   'IPTCPictureNumber' => 'IPTC — Номер изображения',
   'IPTCPixelHeight' => 'IPTC — Высота в пикселях',
   'IPTCPixelWidth' => 'IPTC — Ширина в пикселях',
   'ISO' => 'Значение ISO',
   'ISOSpeed' => 'ISO',
   'ISOSpeedLatitudeyyy' => 'ISO — Фотографическая широта yyy',
   'ISOSpeedLatitudezzz' => 'ISO — Фотографическая широта zzz',
   'IT8Header' => 'IT8-заголовок',
   'Image::ExifTool::DjVu::Form' => 'Форма DjVu',
   'Image::ExifTool::DjVu::Info' => 'Сведения о DjVu',
   'Image::ExifTool::DjVu::Meta' => 'DjVu-метаданные',
   'Image::ExifTool::IPTC::ObjectData' => 'IPTC — Данные объекта',
   'Image::ExifTool::IPTC::PostObjectData' => 'IPTC — Данные Post-объекта',
   'Image::ExifTool::IPTC::PreObjectData' => 'IPTC — Данные Pre-объекта',
   'Image::ExifTool::PDF::Encrypt' => 'PDF зашифрован',
   'Image::ExifTool::PDF::Info' => 'Сведения о PDF',
   'Image::ExifTool::PDF::Pages' => 'Страниц в PDF',
   'Image::ExifTool::PDF::Root' => 'Основные параметры PDF',
   'Image::ExifTool::PDF::Signature' => 'Электронная подпись PDF',
   'Image::ExifTool::PDF::TransformParams' => 'Параметры изменения PDF',
   'ImageByteCount' => 'Число байтов изображения',
   'ImageColorIndicator' => {
      Description => 'Указатель цвета изображения',
      PrintConv => {
        'Specified Image Color' => 'Указанный цвет изображения',
        'Unspecified Image Color' => 'Не указанный цвет изображения',
      },
    },
   'ImageColorValue' => 'Значение цвета изображения',
   'ImageDataDiscard' => {
      Description => 'Отброшенные данные изображения',
      PrintConv => {
        'Flexbits Discarded' => 'Гибкие биты отброшены',
        'Full Resolution' => 'Полное разрешение',
        'HighPass Frequency Data Discarded' => 'Данные высоких частот отброшены',
        'Highpass and LowPass Frequency Data Discarded' => 'Данные высоких и низких частот отброшены',
      },
    },
   'ImageDepth' => 'Глубина изображения',
   'ImageDescription' => 'Описание изображения',
   'ImageFullHeight' => 'Полная высота изображения',
   'ImageFullWidth' => 'Полная ширина изображения',
   'ImageHeight' => 'Высота изображения',
   'ImageHistory' => 'История изображения',
   'ImageID' => 'ID изображения',
   'ImageLayer' => 'Слой изображения',
   'ImageNumber' => 'Номер изображения',
   'ImageOffset' => 'Смещение изображения',
   'ImageOrientation' => {
      Description => 'Ориентация изображения',
      PrintConv => {
        'Landscape' => 'Альбомная',
        'Portrait' => 'Портретная',
        'Square' => 'Квадратная',
      },
    },
   'ImageReferencePoints' => 'Опорные точки изображения',
   'ImageSize' => 'Размер изображения',
   'ImageSourceData' => 'Исходные данные изображения',
   'ImageStabilization' => {
      PrintConv => {
        'CCD Shift' => 'Оптический стабилизатор',
        'High Sensitivity' => 'Движение объекта съёмки',
        'Off' => 'Отключён',
        'Off (1)' => 'Отключён (1)',
      },
    },
   'ImageType' => {
      Description => 'Тип изображения',
      PrintConv => {
        'Page' => 'Страница',
        'Preview' => 'Предпросмотр',
      },
    },
   'ImageUniqueID' => 'Уникальный ID-код снимка',
   'ImageWidth' => 'Ширина изображения',
   'IncludedFileID' => 'ID встроенного файла',
   'Index' => 'Индекс',
   'Indexed' => {
      Description => 'Индексированный',
      PrintConv => {
        'Indexed' => 'Да',
        'Not indexed' => 'Нет',
      },
    },
   'InkNames' => 'Названия чернил',
   'InkSet' => {
      Description => 'Набор чернил',
      PrintConv => {
        'Not CMYK' => 'Не CMYK',
      },
    },
   'Institution' => 'Институт',
   'Instructions' => 'Инструкции',
   'InterchangeColorSpace' => 'Смена цветового пространства',
   'IntergraphFlagRegisters' => 'Intergraph — Флаг регистров',
   'IntergraphMatrix' => 'Intergraph — Матрица',
   'IntergraphPacketData' => 'Intergraph — Данные пакета',
   'Interlace' => 'Чересстрочная развёртка',
   'InteropIndex' => {
      Description => 'Индекс файловой совместимости',
      PrintConv => {
        'R03 - DCF option file (Adobe RGB)' => 'R03 — Альтернативный файл DCF (Adobe RGB)',
        'R98 - DCF basic file (sRGB)' => 'R98 — Основной файл DCF (sRGB)',
        'THM - DCF thumbnail file' => 'THM — Файл миниатюр DCF',
      },
    },
   'InteropOffset' => 'Тэг взаимной совместимости',
   'InteropVersion' => 'Версия файловой совместимости',
   'JBIGOptions' => 'Параметры JBIG',
   'JPEGACTables' => 'Таблицы JPEGAC',
   'JPEGDCTables' => 'Таблицы JPEGDC',
   'JPEGLosslessPredictors' => 'Значения предиктора JPEG без потерь',
   'JPEGPointTransforms' => 'Преобразование точек JPEG',
   'JPEGProc' => {
      Description => 'JPEG-сжатие в старом стиле',
      PrintConv => {
        'Baseline' => 'Базовое последовательное',
        'Lossless' => 'Без потерь с кодированием Хаффмана',
      },
    },
   'JPEGQTables' => 'Таблицы JPEGQ',
   'JPEGQuality' => {
      Description => 'Качество изображения',
      PrintConv => {
        'Extra Fine' => 'Сверхвысокое',
        'Fine' => 'Высокое',
        'Standard' => 'Стандартное',
      },
    },
   'JPEGRestartInterval' => 'Интервал перезапуска JPEG',
   'JPEGTables' => 'JPEG-таблицы',
   'JobID' => 'ID задания',
   'Journal' => 'Журнал',
   'JpgFromRaw' => 'JPG-файл, встроенный в RAW-файл',
   'JpgFromRawLength' => 'Высота JPG-файла, встроенного в RAW-файл',
   'JpgFromRawStart' => 'Смещение JPG-файла, встроенного в RAW-файл',
   'Key' => 'Код',
   'Keywords' => 'Ключевые слова',
   'Language' => 'Язык',
   'LanguageIdentifier' => 'Идентификатор языка',
   'Lens' => 'Объектив',
   'LensInfo' => 'Сведения об объективе',
   'LensMake' => 'Производитель объектива',
   'LensModel' => 'Модель объектива',
   'LensSerialNumber' => 'Серийный номер объектива',
   'LightSource' => {
      Description => 'Тип освещения',
      PrintConv => {
        'Cloudy' => 'Облачно (6500 К)',
        'Cool White Fluorescent' => 'Флуоресцентная лампа — Холодный свет (4150 К)',
        'Day White Fluorescent' => 'Флуоресцентная лампа — Дневной белый (5050 К)',
        'Daylight' => 'Дневной свет (5500 К)',
        'Daylight Fluorescent' => 'Флуоресцентная лампа дневного света (6400 К)',
        'Fine Weather' => 'Ясная погода (5500 К)',
        'Flash' => 'Вспышка (5500 К)',
        'Fluorescent' => 'Флуоресцентная лампа (4150 К)',
        'ISO Studio Tungsten' => 'ISO для студийных ламп накаливания',
        'Other' => 'другой источник света',
        'Shade' => 'Тень (7500 К)',
        'Standard Light A' => 'Стандартный свет A',
        'Standard Light B' => 'Стандартный свет B',
        'Standard Light C' => 'Стандартный свет C',
        'Tungsten (Incandescent)' => 'Лампа накаливания (2850 К)',
        'Unknown' => 'Неизвестно',
        'Warm White Fluorescent' => 'Флуоресцентная лампа — Тёплый свет (2925 К)',
        'White Fluorescent' => 'Флуоресцентная лампа — Белый свет (3525 К)',
      },
    },
   'Lightness' => 'Освещенность',
   'LinearResponseLimit' => 'Предел линейного отклика',
   'LinearityLimitBlue' => 'Предел линейности — Синий',
   'LinearityLimitGreen' => 'Предел линейности — Зелёный',
   'LinearityLimitRed' => 'Предел линейности — Красный',
   'LinearizationTable' => 'Таблица линеаризации',
   'Linearized' => {
      Description => 'Линеаризация',
      PrintConv => {
        'No' => 'Нет',
        'Yes' => 'Да',
      },
    },
   'LocalCaption' => 'Описание места',
   'LocalizedCameraModel' => 'Локализованное имя модели камеры',
   'Location' => 'Место съёмки',
   'LongExposureNoiseReduction' => {
      Description => 'Шумоподавление при длинной выдержке',
      PrintConv => {
        'Off' => 'Отключено',
        'On' => 'Включено',
      },
    },
   'LookupTable' => 'Таблица подстановки',
   'MDColorTable' => 'MD — Таблица цветов',
   'MDFileTag' => 'MD — Формат исходных данных',
   'MDFileUnits' => 'MD — Единицы данных файла',
   'MDLabName' => 'MD — Создатель файла',
   'MDPrepDate' => 'MD — Дата создания',
   'MDPrepTime' => 'MD — Время создания',
   'MDSampleInfo' => 'MD — Описание файла',
   'MDScalePixel' => 'MD — Коефициент масштабирования пикселя',
   'MSDocumentText' => 'MS — Текстовый документ',
   'MSDocumentTextPosition' => 'MS — Текстовый документ — Позиция',
   'MSPropertySetStorage' => 'MS — Хранилище свойств',
   'Make' => 'Производитель',
   'MakerNote' => 'Приватные данные DNG',
   'MakerNoteApple' => 'Комментарии Apple',
   'MakerNoteCanon' => 'Комментарии Canon',
   'MakerNoteCasio' => 'Комментарии Casio',
   'MakerNoteCasio2' => 'Комментарии Casio 2',
   'MakerNoteDJI' => 'Комментарии DJI',
   'MakerNoteFLIR' => 'Комментарии FLIR',
   'MakerNoteFujiFilm' => 'Комментарии Fuji Film',
   'MakerNoteGE' => 'Комментарии GE',
   'MakerNoteGE2' => 'Комментарии GE2',
   'MakerNoteHP' => 'Комментарии HP',
   'MakerNoteHP2' => 'Комментарии HP2',
   'MakerNoteHP4' => 'Комментарии HP4',
   'MakerNoteHP6' => 'Комментарии HP6',
   'MakerNoteHasselblad' => 'Комментарии Hasselblad',
   'MakerNoteISL' => 'Комментарии ISL',
   'MakerNoteJVC' => 'Комментарии JVC',
   'MakerNoteJVCText' => 'Комментарии JVC — Текст',
   'MakerNoteKodak10' => 'Комментарии Kodak 10',
   'MakerNoteKodak11' => 'Комментарии Kodak 11',
   'MakerNoteKodak12' => 'Комментарии Kodak 12',
   'MakerNoteKodak1a' => 'Комментарии Kodak 1a',
   'MakerNoteKodak1b' => 'Комментарии Kodak 1b',
   'MakerNoteKodak2' => 'Комментарии Kodak 2',
   'MakerNoteKodak3' => 'Комментарии Kodak 3',
   'MakerNoteKodak4' => 'Комментарии Kodak 4',
   'MakerNoteKodak5' => 'Комментарии Kodak 5',
   'MakerNoteKodak6a' => 'Комментарии Kodak 6a',
   'MakerNoteKodak6b' => 'Комментарии Kodak 6b',
   'MakerNoteKodak7' => 'Комментарии Kodak 7',
   'MakerNoteKodak8a' => 'Комментарии Kodak 8a',
   'MakerNoteKodak8b' => 'Комментарии Kodak 8b',
   'MakerNoteKodak8c' => 'Комментарии Kodak 8c',
   'MakerNoteKodak9' => 'Комментарии Kodak 9',
   'MakerNoteKodakUnknown' => 'Комментарии Kodak — Неизвестно',
   'MakerNoteKyocera' => 'Комментарии Kyocera',
   'MakerNoteLeica' => 'Комментарии Leica',
   'MakerNoteLeica10' => 'Комментарии Leica 10',
   'MakerNoteLeica2' => 'Комментарии Leica 2',
   'MakerNoteLeica3' => 'Комментарии Leica 3',
   'MakerNoteLeica4' => 'Комментарии Leica 4',
   'MakerNoteLeica5' => 'Комментарии Leica 5',
   'MakerNoteLeica6' => 'Комментарии Leica 6',
   'MakerNoteLeica7' => 'Комментарии Leica 7',
   'MakerNoteLeica8' => 'Комментарии Leica 8',
   'MakerNoteLeica9' => 'Комментарии Leica 9',
   'MakerNoteMinolta' => 'Комментарии Minolta',
   'MakerNoteMinolta2' => 'Комментарии Minolta 2',
   'MakerNoteMinolta3' => 'Комментарии Minolta 3',
   'MakerNoteMotorola' => 'Комментарии Motorola',
   'MakerNoteNikon' => 'Комментарии Nikon',
   'MakerNoteNikon2' => 'Комментарии Nikon 2',
   'MakerNoteNikon3' => 'Комментарии Nikon 3',
   'MakerNoteNintendo' => 'Комментарии Nintendo',
   'MakerNoteOlympus' => 'Комментарии Olympus',
   'MakerNoteOlympus2' => 'Комментарии Olympus 2',
   'MakerNotePanasonic' => 'Комментарии Panasonic',
   'MakerNotePanasonic2' => 'Комментарии Panasonic 2',
   'MakerNotePanasonic3' => 'Комментарии Panasonic 3',
   'MakerNotePentax' => 'Комментарии Pentax',
   'MakerNotePentax2' => 'Комментарии Pentax 2',
   'MakerNotePentax3' => 'Комментарии Pentax 3',
   'MakerNotePentax4' => 'Комментарии Pentax 4',
   'MakerNotePentax5' => 'Комментарии Pentax 5',
   'MakerNotePentax6' => 'Комментарии Pentax 6',
   'MakerNotePhaseOne' => 'Комментарии Phase One',
   'MakerNoteReconyx' => 'Комментарии Reconyx',
   'MakerNoteReconyx2' => 'Комментарии Reconyx 2',
   'MakerNoteReconyx3' => 'Комментарии Reconyx 3',
   'MakerNoteRicoh' => 'Комментарии Ricoh',
   'MakerNoteRicoh2' => 'Комментарии Ricoh 2',
   'MakerNoteRicohPentax' => 'Комментарии Ricoh Pentax',
   'MakerNoteRicohText' => 'Комментарии Ricoh — Текст',
   'MakerNoteSafety' => {
      Description => 'Примечания безопасности',
      PrintConv => {
        'Safe' => 'Безопасно',
        'Unsafe' => 'Небезопасно',
      },
    },
   'MakerNoteSamsung1a' => 'Комментарии Samsung 1a',
   'MakerNoteSamsung1b' => 'Комментарии Samsung 1b',
   'MakerNoteSamsung2' => 'Комментарии Samsung 2',
   'MakerNoteSanyo' => 'Комментарии Sanyo',
   'MakerNoteSanyoC4' => 'Комментарии Sanyo C4',
   'MakerNoteSanyoPatch' => 'Комментарии Sanyo Patch',
   'MakerNoteSigma' => 'Комментарии Sigma',
   'MakerNoteSigma3' => 'Комментарии Sigma 3',
   'MakerNoteSony' => 'Комментарии Sony',
   'MakerNoteSony2' => 'Комментарии Sony 2',
   'MakerNoteSony3' => 'Комментарии Sony 3',
   'MakerNoteSony4' => 'Комментарии Sony 4',
   'MakerNoteSony5' => 'Комментарии Sony 5',
   'MakerNoteSonyEricsson' => 'Комментарии Sony Ericsson',
   'MakerNoteSonySRF' => 'Комментарии Sony SRF',
   'MakerNoteUnknown' => 'Комментарии неизвестного производителя',
   'MakerNoteUnknownBinary' => 'Комментарии неизвестного производителя — Бинарный',
   'MakerNoteUnknownText' => 'Комментарии неизвестного производителя — Текстовый',
   'MakerNotes' => 'Данные производителей',
   'MaskedAreas' => 'Маскированные области',
   'MasterDocumentID' => 'Основной ID документа',
   'MatrixWorldToCamera' => 'Матрица мира на камеру',
   'MatrixWorldToScreen' => 'Матрица мира на экран',
   'Matteing' => 'Матирование',
   'MaxAperture' => 'Макс. диафрагма объектива',
   'MaxApertureValue' => 'Максимальное число диафрагмы объектива',
   'MaxSampleValue' => 'Макс. значение, используемое компонентом',
   'MaxSubfileSize' => 'Максимальный размер подфайла',
   'MaximumDensityRange' => 'Максимальный диапазон плотности',
   'MaximumObjectSize' => 'Максимальный размер объекта',
   'MeteringMode' => {
      Description => 'Экспозамер',
      PrintConv => {
        'Average' => 'Усреднённый',
        'Center-weighted average' => 'Центрально-взвешенный',
        'Multi-segment' => 'Оценочный/многозонный',
        'Multi-spot' => 'Многоточечный',
        'Other' => 'Другой',
        'Partial' => 'Частичный',
        'Spot' => 'Точечный',
        'Unknown' => 'Неизвестно',
      },
    },
   'MinSampleValue' => 'Минимальное значение образца',
   'ModeNumber' => 'Номер режима',
   'Model' => 'Модель',
   'Model2' => 'Модель 2',
   'ModelTiePoint' => 'Пространственная привязка',
   'ModelTransform' => 'Модель преобразования',
   'ModificationPermissions' => {
      Description => 'Разрешения на редактирование',
      PrintConv => {
        'Do not restrict applications to reader permissions' => 'Не ограничивать всем приложениям права на чтение',
        'Fill forms, Create page templates, Sign' => 'Заполнение форм, создание шаблонов страниц, электронная подпись',
        'Fill forms, Create page templates, Sign, Create/Delete/Edit annotations' => 'Заполнение форм, создание шаблонов страниц, электронная подпись, создание/удаление/редактирование примечаний',
        'No changes permitted' => 'Редактирование запрещено',
        'Restrict all applications to reader permissions' => 'Ограничивать всем приложениям права на чтение',
      },
    },
   'ModifyDate' => 'Дата редактирования',
   'MoireFilter' => 'Фильтр муара',
   'Month' => 'Месяц',
   'MultiFrameNoiseReduction' => {
      Description => 'Многокадровое шумоподавление',
      PrintConv => {
        'Off' => 'Отключено',
        'On' => 'Включено',
      },
    },
   'MultiProfiles' => {
      Description => 'Мультипрофили',
      PrintConv => {
        'JBIG2 Profile M' => 'JBIG2 профиль M',
        'N Layer Profile M' => 'N слой Профиль M',
        'Profile C' => 'Профиль C',
        'Profile F' => 'Профиль F',
        'Profile J' => 'Профиль J',
        'Profile L' => 'Профиль L',
        'Profile M' => 'Профиль M',
        'Profile S' => 'Профиль S',
        'Profile T' => 'Профиль T',
        'Resolution/Image Width' => 'Разрешение/ширина изображения',
        'Shared Data' => 'Общие данные',
      },
    },
   'Multishot' => {
      Description => 'Мультисъёмка',
      PrintConv => {
        'Off' => 'Отключена',
        'Pixel Shift' => 'Сдвиг пикселей',
      },
    },
   'NewRawImageDigest' => 'Новый обзор RAW-изображения',
   'NewsPhotoVersion' => 'Версия фоторепортажа',
   'Noise' => 'Шум',
   'NoiseProfile' => 'Профиль шума',
   'NoiseReduction' => 'Шумоподавление',
   'NoiseReductionApplied' => 'Прилагаемое шумоподавление',
   'NoiseReductionParams' => 'Параметры шумоподавления',
   'Note' => 'Заметка',
   'NumIndexEntries' => 'Количество индексов',
   'Number' => 'Номер',
   'NumberofInks' => 'Количество чернил',
   'OPIProxy' => {
      Description => 'Подстановка изображения',
      PrintConv => {
        'Higher resolution image does not exist' => 'Изображение большего разрешения отсутствует',
        'Higher resolution image exists' => 'Изображение большего разрешения присутствует',
      },
    },
   'ObjectAttributeReference' => 'Ссылка на атрибут объекта',
   'ObjectCycle' => {
      Description => 'Суточный цикл',
      PrintConv => {
        'Both Morning and Evening' => 'Утро и вечер',
        'Evening' => 'Вечер',
        'Morning' => 'Утро',
      },
    },
   'ObjectName' => 'Заголовок объекта',
   'ObjectPreviewData' => 'Данные предпросмотра объекта',
   'ObjectPreviewFileFormat' => 'Формат файла предпросмотра объекта',
   'ObjectPreviewFileVersion' => 'Версия файла предпросмотра объекта',
   'ObjectSizeAnnounced' => 'Заявленный размер объекта',
   'ObjectTypeReference' => 'Ссылка на тип объекта',
   'OceApplicationSelector' => 'Задатчик приложения Oce',
   'OceIDNumber' => 'ID-номер Oce',
   'OceImageLogic' => 'Логика изображения Oce',
   'OceScanjobDesc' => 'Описание задания сканирования Oce',
   'OffsetSchema' => 'Схема смещения',
   'OffsetTime' => 'Смещение времени',
   'OffsetTimeDigitized' => 'Смещения времени создания файла',
   'OffsetTimeOriginal' => 'Смещение времени съёмки',
   'OldSubfileType' => {
      Description => 'Старый подтип файла',
      PrintConv => {
        'Full-resolution image' => 'Изображение с полным разрешением',
        'Reduced-resolution image' => 'Изображение с пониженным разрешением',
        'Single page of multi-page image' => 'Одна страница многостраничного изображения',
      },
    },
   'OpcodeList1' => 'Список кодов операций обработки изображений 1',
   'OpcodeList2' => 'Список кодов операций обработки изображений 2',
   'OpcodeList3' => 'Список кодов операций обработки изображений 3',
   'Opto-ElectricConvFactor' => 'Фактор оптико-электрического преобразования',
   'Organization' => 'Организация',
   'Orientation' => {
      Description => 'Ориентация',
      PrintConv => {
        'Horizontal (normal)' => 'Горизонтальная (обычная)',
        'Mirror horizontal' => 'Отражение по горизонтали',
        'Mirror horizontal and rotate 270 CW' => 'Отражение по горизонтали и поворот на 270° по часовой стрелке',
        'Mirror horizontal and rotate 90 CW' => 'Отражение по горизонтали и поворот на 90° по часовой стрелке',
        'Mirror vertical' => 'Отражение по вертикали',
        'Rotate 180' => 'Поворот на 180°',
        'Rotate 270 CW' => 'Поворот на 270° по часовой стрелке',
        'Rotate 90 CW' => 'Поворот на 90° по часовой стрелке',
      },
    },
   'OriginalBestQualitySize' => 'Размер более качественного изображения',
   'OriginalDefaultCropSize' => 'Исходный размер кропнутого изображения',
   'OriginalDefaultFinalSize' => 'Полный размер исходного изображения',
   'OriginalFileName' => 'Исходное имя файла',
   'OriginalRawFileData' => 'Исходные данные RAW-файла',
   'OriginalRawFileDigest' => 'Исходный обзор RAW-файла',
   'OriginalRawFileName' => 'Исходное имя RAW-файла',
   'OriginalTransmissionReference' => 'Исходная ссылка на передачу',
   'OriginatingProgram' => 'Приложение',
   'OtherImage' => 'Другое изображение',
   'OtherImageLength' => 'Высота файла предпросмотра',
   'OtherImageStart' => 'Смещение другого изображения',
   'OwnerID' => 'ID владельца',
   'OwnerName' => 'Имя владельца камеры',
   'PDFVersion' => 'Версия PDF',
   'Padding' => 'Внутренние отступы',
   'PageCount' => 'Количество страниц',
   'PageLayout' => 'Макет страницы',
   'PageMode' => 'Режим страницы',
   'PageName' => 'Название страницы',
   'PageNumber' => 'Номер страницы',
   'Pages' => 'Страниц',
   'PanasonicRawVersion' => 'Panasonic — Версия RAW',
   'PanasonicTitle' => 'Panasonic — Название',
   'PanasonicTitle2' => 'Panasonic — Название 2',
   'PhotometricInterpretation' => {
      Description => 'Цветовая модель',
      PrintConv => {
        'Color Filter Array' => 'Массив цветных фильтров',
        'Linear Raw' => 'Линейный RAW',
        'RGB Palette' => 'Палитра RGB',
        'Sequential Color Filter' => 'Последовательный цветной фильтр',
        'Transparency Mask' => 'Маска прозрачности',
        'WhiteIsZero' => 'Белый — ноль',
      },
    },
   'PixelFormat' => {
      Description => 'Формат пикселя',
      PrintConv => {
        '112-bit 6 Channels Alpha' => '112-битный, 6 каналов, альфа-канал',
        '112-bit 7 Channels' => '112-битный, 7 каналов',
        '128-bit 7 Channels Alpha' => '128-битный, 7 каналов, альфа-канал',
        '128-bit 8 Channels' => '128-битный, 8 каналов',
        '128-bit PRGBA Float' => '128-битный, PRGBA с плавающей точкой',
        '128-bit RGB Float' => '128-битный, RGB с плавающей точкой',
        '128-bit RGBA Fixed Point' => '128-битный, RGBA с фиксированной точкой',
        '128-bit RGBA Float' => '128-битный, RGBA с плавающей точкой',
        '144-bit 8 Channels Alpha' => '144-битный, 8 каналов, альфа-канал',
        '16-bit BGR555' => '16-битный, BGR555',
        '16-bit BGR565' => '16-битный, BGR565',
        '16-bit Gray' => '16-битный, серый',
        '16-bit Gray Half' => '16-битный, половина серого',
        '24-bit 3 Channels' => '24-битный, 3 канала',
        '24-bit BGR' => '24-битный, BGR',
        '24-bit RGB' => '24-битный, RGB',
        '32-bit 3 Channels Alpha' => '32-битный, 3 канала, альфа-канал',
        '32-bit 4 Channels' => '32-битный, 4 канала',
        '32-bit BGR' => '32-битный, BGR',
        '32-bit BGR101010' => '32-битный, BGR101010',
        '32-bit BGRA' => '32-битный, BGRA',
        '32-bit CMYK' => '32-битный, CMYK',
        '32-bit Gray Fixed Point' => '32-битный, серый с фиксированной точкой',
        '32-bit Gray Float' => '32-битный, серый с плавающей точкой',
        '32-bit PBGRA' => '32-битный, PBGRA',
        '32-bit RGBE' => '32-битный, RGBE',
        '40-bit 4 Channels Alpha' => '40-битный, 4 канала, альфа-канал',
        '40-bit 5 Channels' => '40-битный, 5 каналов',
        '40-bit CMYK Alpha' => '40-битный, CMYK, альфа-канал',
        '48-bit 3 Channels' => '48-битный, 3 канала',
        '48-bit 5 Channels Alpha' => '48-битный, 5 каналов, альфа-канал',
        '48-bit 6 Channels' => '48-битный, 6 каналов',
        '48-bit RGB' => '48-битный, RGB',
        '48-bit RGB Fixed Point' => '48-битный, RGB с фиксированной точкой',
        '48-bit RGB Half' => '48-битный, RGB Half',
        '56-bit 6 Channels Alpha' => '56-битный, 6 каналов, альфа-канал',
        '56-bit 7 Channels' => '56-битный, 7 каналов',
        '64-bit 3 Channels Alpha' => '64-битный, 3 канала, альфа-канал',
        '64-bit 4 Channels' => '64-битный, 4 канала',
        '64-bit 7 Channels Alpha' => '64-битный, 7 каналов, альфа-канал',
        '64-bit 8 Channels' => '64-битный, 8 каналов',
        '64-bit CMYK' => '64-битный, CMYK',
        '64-bit PRGBA' => '64-битный, PRGBA',
        '64-bit RGBA' => '64-битный, RGBA',
        '64-bit RGBA Fixed Point' => '64-битный, RGBA с фиксированной точкой',
        '64-bit RGBA Half' => '64-битный, RGBA Half',
        '72-bit 8 Channels Alpha' => '72-битный, 8 каналов, альфа-канал',
        '8-bit Gray' => '8-битный, Градаций серого',
        '80-bit 4 Channels Alpha' => '80-битный, 4 канала, альфа-канал',
        '80-bit 5 Channels' => '80-битный, 5 канаов',
        '80-bit CMYK Alpha' => '80-битный, CMYK, альфа-канал',
        '96-bit 5 Channels Alpha' => '96-битный, 5 каналов, альфа-канал',
        '96-bit 6 Channels' => '96-битный, 6 канаов',
        '96-bit RGB Fixed Point' => '96-битный, RGB с фиксированной точкой',
        'Black & White' => 'Чёрно-белый',
      },
    },
   'PixelIntensityRange' => 'Диапазон интенсивности пикселей (%)',
   'PixelMagicJBIGOptions' => 'Pixel Magic — Параметры JBIG',
   'PixelScale' => 'Масштаб пикселя',
   'PlanarConfiguration' => {
      Description => 'Принцип организации данных',
      PrintConv => {
        'Chunky' => 'Непрерывный (RGBRGB)',
        'Planar' => 'По каналам (RRGGBB)',
      },
    },
   'Predictor' => {
      Description => 'Предсказатель',
      PrintConv => {
        'Horizontal differencing' => 'Горизонтальное дифференцирование',
        'None' => 'Никакой',
      },
    },
   'Prefs' => 'Настройки',
   'Pressure' => 'Давление',
   'PreviewApplicationName' => 'Название приложения предпросмотра',
   'PreviewApplicationVersion' => 'Версия приложения предпросмотра',
   'PreviewColorSpace' => {
      Description => 'Цветовое пространство предпросмотра',
      PrintConv => {
        'Unknown' => 'Неизвестно',
      },
    },
   'PreviewDateTime' => 'Дата и время файла предпросмотра',
   'PreviewImage' => 'Файл предпросмотра',
   'PreviewImageLength' => 'Высота файла предпросмотра',
   'PreviewImageStart' => 'Смещение файла предпросмотра',
   'PreviewSettingsDigest' => 'Обзор настроек файла предпросмотра',
   'PreviewSettingsName' => 'Название параметров файла предпросмотра',
   'PrimaryChromaticities' => 'Первичные цветности',
   'PrintIM' => 'Распечатать IM',
   'ProcessingSoftware' => 'Приложение редактирования',
   'Producer' => 'Продюсер',
   'ProductID' => 'ID продукта',
   'ProfileCalibrationSig' => 'Сигнатура калибровки профиля',
   'ProfileCopyright' => 'Авторское право профиля',
   'ProfileEmbedPolicy' => {
      Description => 'Политика внедрения профиля',
      PrintConv => {
        'Allow Copying' => 'Разрешено копирование',
        'Embed if Used' => 'Внедрить если используется',
        'Never Embed' => 'Никогда не внедрять',
        'No Restrictions' => 'Без ограничений',
      },
    },
   'ProfileHueSatMapData1' => 'Профиль — Карта оттенков/насыщенности — Данные 1',
   'ProfileHueSatMapData2' => 'Профиль — Карта оттенков/насыщенности — Данные 2',
   'ProfileHueSatMapDims' => 'Профиль — Карта оттенков/насыщенности — Потускнение',
   'ProfileHueSatMapEncoding' => {
      Description => 'Профиль — Карта оттенков/насыщенности — Кодирование',
      PrintConv => {
        'Linear' => 'Линейное',
      },
    },
   'ProfileLookTableData' => 'Профиль — Таблица поиска — Данные',
   'ProfileLookTableDims' => 'Профиль — Таблица поиска — Потускнение',
   'ProfileLookTableEncoding' => {
      Description => 'Профиль — Таблица поиска — Кодирование',
      PrintConv => {
        'Linear' => 'Линейное',
      },
    },
   'ProfileName' => 'Название профиля',
   'ProfileToneCurve' => 'Профиль — Тоновая кривая',
   'ProfileType' => {
      Description => 'Тип профиля',
      PrintConv => {
        'Group 3 FAX' => 'Группа 3 FAX',
        'Unspecified' => 'Не указан',
      },
    },
   'ProgramVersion' => 'Версия программы',
   'Province-State' => 'Область/район',
   'Publisher' => 'Издатель',
   'Quality' => {
      Description => 'Качество',
      PrintConv => {
        'Compressed RAW' => 'Сжатый RAW',
        'Compressed RAW + JPEG' => 'Сжатый RAW + JPEG',
        'Extra Fine' => 'Сверхвысокое',
        'Fine' => 'Высокое',
        'Low' => 'Низкое',
        'Normal' => 'Обычное',
        'Standard' => 'Стандартное',
      },
    },
   'QuantizationMethod' => {
      Description => 'Метод квантования',
      PrintConv => {
        'Color Space Specific' => 'Специфичное цветовое пространство',
        'Compression Method Specific' => 'Специфичный метод сжатия',
        'Gamma Compensated' => 'Компенсация гаммы',
        'Linear Density' => 'Линейная плотность',
        'Linear Reflectance/Transmittance' => 'Линейное отражение/пропускание',
      },
    },
   'RasterPadding' => {
      Description => 'Растровое заполнение',
      PrintConv => {
        'Byte' => 'Байт',
        'Long Sector' => 'Длинный сектор',
        'Long Word' => 'Длинное слово',
        'Sector' => 'Сектор',
        'Word' => 'Слово',
      },
    },
   'RasterizedCaption' => 'Растрированная подпись',
   'Rating' => 'Рейтинг',
   'RatingPercent' => 'Проценты рейтинга',
   'RawDataOffset' => 'Смещение RAW-данных',
   'RawDataUniqueID' => 'Уникальный ID RAW-данных',
   'RawFile' => 'RAW-файл',
   'RawFormat' => 'RAW-формат',
   'RawImageDigest' => 'Обзор RAW-изображения',
   'RawImageSegmentation' => 'Сегментация RAW-изображения',
   'RawToPreviewGain' => 'Коэффициент увеличения между RAW и файлом предпросмотра',
   'RecommendedExposureIndex' => 'Рекомендуемый индекс экспозиции',
   'RecordMode' => 'Режим записи',
   'RedBalance' => 'Баланс красного',
   'ReductionMatrix1' => 'Матрица редукции 1',
   'ReductionMatrix2' => 'Матрица редукции 2',
   'ReelName' => 'Название носителя информации',
   'ReferenceBlackWhite' => 'Исходные значения чёрного и белого',
   'ReferenceDate' => 'Дата предыдущего конверта',
   'ReferenceNumber' => 'Номер предыдущего конверта',
   'ReferenceService' => 'Ссылка на предыдущий конверт',
   'RegionXformTackPoint' => 'Точки-модификаторы области преобразования Xform',
   'RelatedImageFileFormat' => 'Формат файла связанного изображения',
   'RelatedImageHeight' => 'Высота связанного изображения',
   'RelatedImageWidth' => 'Ширина связанного изображения',
   'RelatedSoundFile' => 'Связанный аудиофайл',
   'ReleaseDate' => 'Дата публикации',
   'ReleaseTime' => 'Время публикации',
   'ResolutionUnit' => {
      Description => 'Единицы разрешения по X и Y',
      PrintConv => {
        'None' => 'Никакие',
        'cm' => 'см',
        'inches' => 'дюймы',
      },
    },
   'RoundTripVersion' => 'Версия Round Trip',
   'RowInterleaveFactor' => 'Коэффициент чередования строк',
   'RowsPerStrip' => 'Количество строк на полосу',
   'SEMInfo' => 'Информация о SEM',
   'SMaxSampleValue' => 'Максимальное значение компонента',
   'SMinSampleValue' => 'Минимальное значение компонента',
   'SRawType' => 'Тип SRaw',
   'SampleFormat' => {
      Description => 'Формат компонента',
      PrintConv => {
        'Complex float' => 'Комплексные данные с плавающей точкой IEEE',
        'Complex int' => 'Комплексные целые данные',
        'Float' => 'Данные с плавающей точкой IEEE',
        'Signed' => 'Целочисленные данные со знаком',
        'Undefined' => 'Неопределенный формат данных',
        'Unsigned' => 'Беззнаковые целочисленные данные',
      },
    },
   'SampleStructure' => {
      Description => 'Структура компонента',
      PrintConv => {
        'CompressionDependent' => 'Зависимая от сжатия',
        'Orthogonal4-2-2Sampling' => 'Ортогональная с частотами дискретизации в соотношении 4: 2: 2: (4)',
        'OrthogonalConstangSampling' => 'Ортогональная с теми же относительными частотами дискретизации в каждом компоненте',
      },
    },
   'SamplesPerPixel' => 'Количество компонентов на пиксель',
   'SamsungRawByteOrder' => 'Samsung RAW — Порядок байтов',
   'SamsungRawPointersLength' => 'Samsung RAW — Длина указателей',
   'SamsungRawPointersOffset' => 'Samsung RAW — Смещение указателей',
   'SamsungRawUnknown' => 'Samsung RAW — Неизвестно',
   'Saturation' => {
      Description => 'Насыщенность',
      PrintConv => {
        'High' => 'Высокая',
        'Low' => 'Низкая',
        'Normal' => 'Обычная',
      },
    },
   'ScanningDirection' => {
      Description => 'Направление сканирования',
      PrintConv => {
        'Bottom-Top, L-R' => 'Снизу вверх, слева направо',
        'Bottom-Top, R-L' => 'Снизу вверх, справа налево',
        'L-R, Bottom-Top' => 'Слева направо, снизу вверх',
        'L-R, Top-Bottom' => 'Слева направо, сверху вниз',
        'R-L, Bottom-Top' => 'Справа налево, снизу вверх',
        'R-L, Top-Bottom' => 'Справа налево, сверху вниз',
        'Top-Bottom, L-R' => 'Сверху вниз, слева направо',
        'Top-Bottom, R-L' => 'Сверху вниз, справа налево',
      },
    },
   'SceneCaptureType' => {
      Description => 'Тип снимаемой сцены',
      PrintConv => {
        'Landscape' => 'Пейзаж',
        'Night' => 'Ночь',
        'Other' => 'Другой',
        'Portrait' => 'Портрет',
        'Standard' => 'Стандартный',
      },
    },
   'SceneMode' => {
      Description => 'Выбор сцены',
      PrintConv => {
        '3D Sweep Panorama' => '3D',
        'Anti Motion Blur' => 'Противоразмытие движения',
        'Auto' => 'Автоматический',
        'Cont. Priority AE' => 'Непрерывный приоритет AE',
        'Handheld Night Shot' => 'Ночная съемка с рук',
        'Landscape' => 'Пейзаж',
        'Macro' => 'Макро',
        'Night Portrait' => 'Ночной портрет',
        'Night Scene' => 'Ночная сцена',
        'Night View/Portrait' => 'Ночной вид/портрет',
        'Portrait' => 'Портрет',
        'Sports' => 'Спортивная',
        'Sunset' => 'Закат',
        'Sweep Panorama' => 'Панорамный обзор',
      },
    },
   'SceneType' => {
      Description => 'Тип сцены',
      PrintConv => {
        'Directly photographed' => 'Непосредственно сфотографированная',
      },
    },
   'School' => 'Школа',
   'SecurityClassification' => {
      Description => 'Классификация безопасности',
      PrintConv => {
        'Confidential' => 'Личное',
        'Restricted' => 'Для узкого круга',
        'Secret' => 'Секретно',
        'Top Secret' => 'Совершенно секретно',
        'Unclassified' => 'Без классификации',
      },
    },
   'SelfTimerMode' => 'Режим таймера спуска затвора',
   'SensingMethod' => {
      Description => 'Тип датчика',
      PrintConv => {
        'Color sequential area' => 'Цветной последовательный сенсор',
        'Color sequential linear' => 'Цветной последовательный линейный сенсор',
        'Monochrome area' => 'Монохромный сенсор',
        'Monochrome linear' => 'Монохромный линейный сенсор',
        'Not defined' => 'Не опредеен',
        'One-chip color area' => 'Одночиповый цветной сенсор',
        'Three-chip color area' => 'Трехчиповый цветной сенсор',
        'Trilinear' => 'Трехлинейный цветной сенсор',
        'Two-chip color area' => 'Двухчиповый цветной сенсор',
      },
    },
   'SensitivityType' => {
      Description => 'Тип чувствительности',
      PrintConv => {
        'ISO Speed' => 'ISO',
        'Recommended Exposure Index' => 'Рекомендуемый индекс экспозиции',
        'Recommended Exposure Index and ISO Speed' => 'Рекомендуемый индекс экспозиции и ISO',
        'Standard Output Sensitivity' => 'Стандартная выходная чувствительность',
        'Standard Output Sensitivity and ISO Speed' => 'Стандартная выходная чувствительность и ISO',
        'Standard Output Sensitivity and Recommended Exposure Index' => 'Стандартная выходная чувствительность и рекомендуемый индекс экспозиции',
        'Standard Output Sensitivity, Recommended Exposure Index and ISO Speed' => 'Стандартная выходная чувствительность и рекомендуемый индекс экспозиции и ISO',
        'Unknown' => 'Неизвестно',
      },
    },
   'SensorBottomBorder' => 'Нижняя граница матрицы',
   'SensorHeight' => 'Высота матрицы',
   'SensorLeftBorder' => 'Левая граница матрицы',
   'SensorRightBorder' => 'Правая граница матрицы',
   'SensorTopBorder' => 'Верхняя граница матрицы',
   'SensorWidth' => 'Ширина матрицы',
   'SerialNumber' => 'Серийный номер',
   'Series' => 'Серия',
   'ServiceIdentifier' => 'Сервисный идентификатор',
   'ShadingCompensation' => 'Устранение теней',
   'ShadowScale' => 'Диапазон теней',
   'Shadows' => 'Тени',
   'SharedData' => 'Общие данные',
   'Sharpness' => {
      Description => 'Резкость',
      PrintConv => {
        'Hard' => 'Сильная',
        'Normal' => 'Обычная',
        'Soft' => 'Слабая',
      },
    },
   'ShootingMode' => 'Режим съёмки',
   'ShortDocumentID' => 'Краткий ID документа',
   'ShutterSpeed' => 'Выдержка',
   'ShutterSpeedValue' => 'Значение выдержки',
   'SignatureUsageRights' => 'Права на использование подписи',
   'SignerContactInfo' => 'Контактная информация подписавшего',
   'SigningAuthority' => 'Полномочия подписания',
   'SigningDate' => 'Дата подписания',
   'SigningLocation' => 'Место подписания',
   'SigningReason' => 'Причина подписания',
   'SimilarityIndex' => 'Индекс сходства',
   'Site' => 'Сайт',
   'SizeMode' => {
      Description => 'Режим размера',
      PrintConv => {
        'Size Known' => 'Размер известен',
        'Size Not Known' => 'Размер не известен',
      },
    },
   'Smoothness' => 'Сглаживание',
   'Software' => 'Приложение',
   'SonyCropSize' => 'Sony — Размер рамки кадрирования',
   'SonyCropTopLeft' => 'Sony — Верхний левый угол рамки кадрирования',
   'SonyRawFileType' => {
      Description => 'Sony — Тип RAW-файла',
      PrintConv => {
        'Sony Compressed RAW' => 'Sony — сжатый RAW',
        'Sony Lossless Compressed RAW' => 'Sony — сжатый без потерь RAW',
        'Sony Uncompressed 12-bit RAW' => 'Sony — 12-битный несжатый RAW',
        'Sony Uncompressed 14-bit RAW' => 'Sony — 14-битный несжатый RAW',
      },
    },
   'SonyToneCurve' => 'Sony — Тоновая кривая',
   'Source' => 'Источник',
   'SpatialFrequencyResponse' => 'Отклик пространственной частоты',
   'SpatialResolution' => 'Пространственное разрешение',
   'SpecialInstructions' => 'Специальные указания',
   'SpectralSensitivity' => 'Спектральная чувствительность',
   'StandardOutputSensitivity' => 'Стандартная выходная чувствительность',
   'State' => 'Область',
   'StoNits' => 'Освещенность (коэффициент пересчета кд/м2)',
   'StripByteCounts' => 'Количество байт на полосу после сжатия',
   'StripOffsets' => 'Смещение изображения',
   'StripRowCounts' => 'Количество полос',
   'Sub-location' => 'Местоположение в городе',
   'SubFile' => 'Подфайл',
   'SubSecTime' => 'Дата, время и субсекунды',
   'SubSecTimeDigitized' => 'Дата, время и субсекунды создания файла',
   'SubSecTimeOriginal' => 'Дата, время и субсекунды съёмки',
   'SubTileBlockSize' => 'Размер блока подзаголовка',
   'SubfileType' => {
      Description => 'Тип подфайла',
      PrintConv => {
        'Alternate reduced-resolution image' => 'Альтернативное изображение с пониженным разрешением',
        'Color IW44' => 'Цветной IW44',
        'Full-resolution Image' => 'Изображение с полным разрешением',
        'Grayscale IW44' => 'Градация серого IW44',
        'Multi-page document' => 'Многостраничный документ',
        'Reduced-resolution image' => 'Изображение с пониженным разрешением',
        'Shared component' => 'Общий компонент',
        'Single page of multi-page image' => 'Страница из многостраничного изображения',
        'Single page of multi-page reduced-resolution image' => 'Страница из многостраничного изображения с пониженным разрешением',
        'Single-page image' => 'Одностраничное изображение',
        'TIFF-FX mixed raster content' => 'Смешанное растровое содержимое TIFF-FX',
        'TIFF/IT final page' => 'Последняя страница TIFF/IT',
        'Thumbnail image' => 'Миниатюра изображения',
        'Transparency mask' => 'Маска прозрачности изображения',
        'Transparency mask of multi-page image' => 'Маска прозрачности многостраничного изображения',
        'Transparency mask of reduced-resolution image' => 'Маска прозрачности изображения с пониженным разрешением',
        'Transparency mask of reduced-resolution multi-page image' => 'Маска прозрачности многостраничного изображения с пониженным разрешением',
        'invalid' => 'Некорректный',
      },
    },
   'Subject' => 'Тематика',
   'SubjectArea' => 'Область объекта',
   'SubjectDistance' => 'Дистанция к фокусируемому объекту',
   'SubjectDistanceRange' => {
      Description => 'Расстояние до снимаемого объекта',
      PrintConv => {
        'Close' => 'Съёмка с близкого расстояния',
        'Distant' => 'Съёмка с дальнего расстояния',
        'Macro' => 'Макро съёмка',
        'Unknown' => 'Неизвестно',
      },
    },
   'SubjectLocation' => 'Расположение объекта',
   'SubjectReference' => 'Ссылка на предмет',
   'SupplementalCategories' => 'Дополнительные категории',
   'SupplementalType' => {
      Description => 'Тип дополнения',
      PrintConv => {
        'Logo' => 'Логотип',
        'Main Image' => 'Основное изображение',
        'Rasterized Caption' => 'Растрированный заголовок',
        'Reduced Resolution Image' => 'Изображение с пониженным разрешением',
      },
    },
   'T4Options' => {
      Description => 'Параметры кодирования T4',
      PrintConv => {
        '2-Dimensional encoding' => 'Двумерное кодирование',
        'Fill bits added' => 'Добавление заполняющих битов',
        'Uncompressed' => 'Без сжатия',
      },
    },
   'T6Options' => {
      Description => 'Параметры кодирования T6',
      PrintConv => {
        'Uncompressed' => 'Без сжатия',
      },
    },
   'T82Options' => 'Параметры T82',
   'T88Options' => 'Параметры T88',
   'TIFF-EPStandardID' => 'ID стандарта TIFF-EP',
   'TIFF_FXExtensions' => {
      Description => 'Разширения TIFF_FX',
      PrintConv => {
        'JBIG2 Profile M' => 'JBIG2 профиль M',
        'N Layer Profile M' => 'N слой Профиль M',
        'Resolution/Image Width' => 'Разрешение/ширина изображения',
        'Shared Data' => 'Общие данные',
      },
    },
   'TStop' => 'Индекс светопропускания объектива (T-Stop)',
   'TaggedPDF' => {
      Description => 'Тегированный PDF',
      PrintConv => {
        'No' => 'Нет',
        'Yes' => 'Да',
      },
    },
   'TargetPrinter' => 'Среда печати',
   'TextureFormat' => 'Формат текстуры',
   'Thresholding' => {
      Description => 'Пороговая обработка',
      PrintConv => {
        'No dithering or halftoning' => 'Нет дизеринга или полутонирования',
        'Ordered dither or halftone' => 'Заказной дизеринг или полутонирование',
        'Randomized dither' => 'Случайностный дизеринг',
      },
    },
   'ThumbnailImage' => 'Миниатюра изображения',
   'ThumbnailImageSize' => 'Размер пиктограмм',
   'ThumbnailLength' => 'Высота миниатюры (pix)',
   'ThumbnailOffset' => 'Смещение миниатюры',
   'TileByteCounts' => 'Количество байт в тайле',
   'TileDepth' => 'Глубина тайла',
   'TileLength' => 'Высота тайла',
   'TileOffsets' => 'Смещение тайла',
   'TileWidth' => 'Ширина тайла',
   'TimeCodes' => 'Таймкоды',
   'TimeCreated' => 'Время создания',
   'TimeSent' => 'Время отправления',
   'TimeZoneOffset' => 'Смещение часового пояса',
   'Title' => 'Название документа',
   'TransferFunction' => 'Функция переноса',
   'TransferRange' => 'Диапазон функции переноса',
   'Transformation' => {
      Description => 'Трансформация',
      PrintConv => {
        'Horizontal (normal)' => 'Горизонтально (обычно)',
        'Mirror horizontal' => 'Отразить по горизонтали',
        'Mirror horizontal and rotate 270 CW' => 'Отражение по горизонтали и поворот на 270° по часовой стрелке',
        'Mirror horizontal and rotate 90 CW' => 'Отражение по горизонтали и поворот на 90° по часовой стрелке',
        'Mirror vertical' => 'Отразить по вертикали',
        'Rotate 180' => 'Повернуть на 180°',
        'Rotate 270 CW' => 'Поворот на 270° по часовой стрелке',
        'Rotate 90 CW' => 'Поворот на 90° по часовой стрелке',
      },
    },
   'TransmissionReference' => 'Ссылка на источник',
   'TransparencyIndicator' => 'Показатель прозрачности',
   'TrapIndicator' => 'Показатель треплинга',
   'Trapped' => 'Треппинг',
   'Type' => 'Тип',
   'UIC1Tag' => 'UIC — Тег 1',
   'UIC2Tag' => 'UIC — Тег 2',
   'UIC3Tag' => 'UIC — Тег 3',
   'UIC4Tag' => 'UIC — Тег 4',
   'USPTOMiscellaneous' => 'USPTO — Разнообразный',
   'USPTOOriginalContentType' => {
      Description => 'USPTO — Исходный тип контента',
      PrintConv => {
        'Color' => 'Цвет',
        'Grayscale' => 'Оттенки серого',
        'Text or Drawing' => 'Текст или рисунок',
      },
    },
   'Uncompressed' => {
      Description => 'Не сжато',
      PrintConv => {
        'No' => 'Нет',
        'Yes' => 'Да',
      },
    },
   'UniqueCameraModel' => 'Уникальное имя модели камеры',
   'UniqueDocumentID' => 'Уникальный ID документа',
   'UniqueObjectName' => 'Уникальное имя объекта',
   'Urgency' => {
      Description => 'Срочность',
      PrintConv => {
        '0 (reserved)' => '0 (зарезервировано)',
        '1 (most urgent)' => '1 (срочно)',
        '5 (normal urgency)' => '5 (обычная)',
        '8 (least urgent)' => '8 (не срочно)',
        '9 (user-defined priority)' => '9 (пользовательский приоритет)',
      },
    },
   'UsageRightsMessage' => 'Сообщение о правах использования',
   'UserAccess' => {
      Description => 'Разрешается',
      PrintConv => {
        'Annotate' => 'Аннотирование',
        'Assemble' => 'Сборка',
        'Copy' => 'Копирование',
        'Extract' => 'Извлечение',
        'Fill forms' => 'Заполнение форм',
        'Modify' => 'Редактирование',
        'Print' => 'Печать',
        'Print high-res' => 'Печать в высоком разрешении',
      },
    },
   'UserComment' => 'Комментарии пользователя',
   'VersionYear' => 'Год стандарта факс профиля',
   'VignettingCorrParams' => 'Параметры коррекции виньетирования',
   'VignettingCorrection' => {
      Description => 'Коррекция виньетирования',
      PrintConv => {
        'Auto' => 'Автоматическая',
        'No correction params available' => 'Недоступна',
        'Off' => 'Отключена',
      },
    },
   'Volume' => 'Том',
   'WBBlueLevel' => 'Баланс Белого — Уровень синего',
   'WBGreenLevel' => 'Баланс Белого — Уровень зелёного',
   'WBRedLevel' => 'Баланс Белого — Уровень красного',
   'WB_GRGBLevels' => 'Уровни WB_GRGB',
   'WangAnnotation' => 'Wang Imaging — Аннотация',
   'WangTag1' => 'Wang Imaging — Тег 1',
   'WangTag3' => 'Wang Imaging — Тег 3',
   'WangTag4' => 'Wang Imaging — Тег 4',
   'WarpQuadrilateral' => 'Деформация четвероугольника',
   'WaterDepth' => 'Глубина воды',
   'WhiteBalance' => {
      Description => 'Баланс белого',
      PrintConv => {
        'Auto' => 'Автоматический',
        'Black & White' => 'Монохром',
        'Cloudy' => 'Облачность',
        'Color Temperature/Color Filter' => 'Цветовая температура/цветовой фильтр',
        'Cool White Fluorescent' => 'Флуоресцентный белый холодный',
        'Custom' => 'Пользовательский',
        'Custom 1' => 'Пользовательский 1',
        'Custom 2' => 'Пользовательский 2',
        'Custom 3' => 'Пользовательский 3',
        'Custom 4' => 'Пользовательский 4',
        'Day White Fluorescent' => 'Флуоресцентный белый дневной',
        'Daylight' => 'Дневной',
        'Daylight Fluorescent' => 'Флуоресцентный дневной',
        'Flash' => 'Вспышка',
        'Fluorescent' => 'Флуоресцентный',
        'Manual' => 'Ручной',
        'Shade' => 'Тень',
        'Tungsten' => 'Лампа накаливания',
        'Unknown' => 'Неизвестно',
        'Warm White Fluorescent' => 'Флуоресцентный теплый белый',
        'White Fluorescent' => 'Флуоресцентный белый',
      },
    },
   'WhiteLevel' => 'Уровень белого',
   'WhitePoint' => 'Точка белого',
   'WidthResolution' => 'Разрешение по ширине',
   'WrapModes' => 'Режим обёртывания',
   'Writer-Editor' => 'Писатель/редактор',
   'XClipPathUnits' => 'Единицы обтравочного контура (X)',
   'XPAuthor' => 'XP — Автор',
   'XPComment' => 'XP — Комментарии',
   'XPKeywords' => 'XP — Ключевые слова',
   'XPSubject' => 'XP — Тема',
   'XPTitle' => 'XP — Название',
   'XPosition' => 'Смещение изображения по X',
   'XResolution' => 'Разрешение по X',
   'YCbCrCoefficients' => 'Коэффициенты преобразования из RGB в Y Cb Cr',
   'YCbCrPositioning' => {
      Description => 'Положение точки, определяющей цвет в Y Cb Cr',
      PrintConv => {
        'Centered' => 'Центрованный',
        'Co-sited' => 'Совместимый',
      },
    },
   'YCbCrSubSampling' => 'Коэффициент субдискретизации Y Cb Cr',
   'YClipPathUnits' => 'Единицы обтравочного контура (Y)',
   'YPosition' => 'Позициия по Y',
   'YResolution' => 'Разрешение по Y',
   'Year' => 'Год',
   'ZoneMatching' => {
      Description => 'Соответствие областей',
      PrintConv => {
        'High Key' => 'Высокий ключ',
        'ISO Setting Used' => 'Используемые настройки ISO',
        'Low Key' => 'Низкий ключ',
      },
    },
);

1;  # end

__END__

=head1 NAME

Image::ExifTool::Lang::ru.pm - ExifTool Russian language translations

=head1 DESCRIPTION

This file is used by Image::ExifTool to generate localized tag descriptions
and values.

=head1 AUTHOR

Copyright 2003-2019, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 ACKNOWLEDGEMENTS

Thanks to Jens Duttke, Sergey Shemetov, Dmitry Yerokhin, Anton Sukhinov and
Alexander for providing this translation.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::TagInfoXML(3pm)|Image::ExifTool::TagInfoXML>

=cut
