/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.ToolTipManager;
import javax.swing.table.AbstractTableModel;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.FilteringToolbar;
import org.netbeans.lib.profiler.ui.swing.PopupButton;
import org.netbeans.lib.profiler.ui.swing.ProfilerPopup;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.renderer.CheckBoxRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

public abstract class ThreadsSelector
extends PopupButton {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.cpu.Bundle");
    private static final String SELECT_THREADS = messages.getString("ThreadsSelector_SelectThreads");
    private static final String SELECTED_THREADS = messages.getString("ThreadsSelector_SelectedThreads");
    private static final String SELECTED_THREADS_ALL = messages.getString("ThreadsSelector_SelectedThreadsAll");
    private static final String NO_THREADS = messages.getString("ThreadsSelector_NoThreads");
    private static final String ALL_THREADS = messages.getString("ThreadsSelector_AllThreads");
    private static final String FILTER_THREADS = messages.getString("ThreadsSelector_FilterThreads");
    private static final String MERGE_THREADS = messages.getString("ThreadsSelector_MergeThreads");
    private static final String ALL_THREADS_TOOLTIP = messages.getString("ThreadsSelector_AllThreadsToolTip");
    private static final String MERGE_THREADS_TOOLTIP = messages.getString("ThreadsSelector_MergeThreadsToolTip");
    private static final String MERGE_THREADS_TOOLTIP_DISABLED = messages.getString("ThreadsSelector_MergeThreadsToolTipDisabled");
    private static final String COLUMN_SELECTED = messages.getString("ThreadsSelector_ColumnSelected");
    private static final String COLUMN_THREAD = messages.getString("ThreadsSelector_ColumnThread");
    private static final String COLUMN_SELECTED_TOOLTIP = messages.getString("ThreadsSelector_ColumnSelectedToolTip");
    private static final String COLUMN_THREAD_TOOLTIP = messages.getString("ThreadsSelector_ColumnThreadToolTip");
    private final Set<Integer> selection = new HashSet<Integer>();
    private boolean displayAllThreads = true;
    private boolean mergeSelectedThreads = false;
    private Runnable allThreadsResetter;

    public ThreadsSelector() {
        super(Icons.getIcon((String)"ProfilerIcons.AllThreads"));
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    protected abstract CPUResultsSnapshot getSnapshot();

    protected abstract void selectionChanged(Collection<Integer> var1, boolean var2);

    void reset() {
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                ThreadsSelector.this.displayAllThreads = true;
                ThreadsSelector.this.mergeSelectedThreads = false;
                ThreadsSelector.this.selection.clear();
            }
        });
    }

    void addThread(final int n, final boolean bl) {
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    ThreadsSelector.this.selection.clear();
                }
                if (ThreadsSelector.this.selection.add(n)) {
                    ThreadsSelector.this.displayAllThreads = false;
                    ThreadsSelector.this.fireSelectionChanged();
                }
            }
        });
    }

    void removeThread(final int n) {
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (ThreadsSelector.this.displayAllThreads) {
                    HashSet<Integer> hashSet = new HashSet<Integer>();
                    CPUResultsSnapshot cPUResultsSnapshot = ThreadsSelector.this.getSnapshot();
                    if (cPUResultsSnapshot != null) {
                        for (int i = 0; i < cPUResultsSnapshot.getNThreads(); ++i) {
                            hashSet.add(cPUResultsSnapshot.getThreadIds()[i]);
                        }
                    }
                    if (!hashSet.remove(n)) {
                        return;
                    }
                    ThreadsSelector.this.selection.clear();
                    ThreadsSelector.this.selection.addAll(hashSet);
                } else if (!ThreadsSelector.this.selection.remove(n)) {
                    return;
                }
                ThreadsSelector.this.displayAllThreads = false;
                ThreadsSelector.this.fireSelectionChanged();
            }
        });
    }

    @Override
    public String getToolTipText() {
        return this.displayAllThreads ? SELECTED_THREADS_ALL : MessageFormat.format(SELECTED_THREADS, this.selection.size());
    }

    @Override
    protected void displayPopup() {
        Object object;
        int n;
        JComponent jComponent;
        int[] nArray;
        CPUResultsSnapshot cPUResultsSnapshot = this.getSnapshot();
        int[] nArray2 = nArray = cPUResultsSnapshot == null ? null : cPUResultsSnapshot.getThreadIds();
        if (nArray == null || nArray.length == 0) {
            jComponent = new JLabel(NO_THREADS);
            jComponent.setBorder(BorderFactory.createEmptyBorder(9, 6, 9, 6));
            n = 0;
        } else {
            jComponent = new JPanel(new BorderLayout());
            object = new JLabel(SELECT_THREADS, 10);
            ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
            jComponent.add((Component)object, "North");
            final SelectedThreadsModel selectedThreadsModel = new SelectedThreadsModel();
            final ProfilerTable profilerTable = new ProfilerTable(selectedThreadsModel, true, false, null);
            profilerTable.setColumnToolTips(new String[]{COLUMN_SELECTED_TOOLTIP, COLUMN_THREAD_TOOLTIP});
            profilerTable.setMainColumn(1);
            profilerTable.setFitWidthColumn(1);
            profilerTable.setDefaultSortOrder(1, SortOrder.ASCENDING);
            profilerTable.setSortColumn(1);
            profilerTable.setFixedColumnSelection(0);
            profilerTable.setColumnRenderer(0, new CheckBoxRenderer());
            LabelRenderer labelRenderer = new LabelRenderer();
            labelRenderer.setIcon(Icons.getIcon((String)"ProfilerIcons.Thread"));
            labelRenderer.setFont(labelRenderer.getFont().deriveFont(1));
            profilerTable.setColumnRenderer(1, labelRenderer);
            int n2 = new JLabel((String)profilerTable.getColumnName((int)0)).getPreferredSize().width;
            profilerTable.setDefaultColumnWidth(0, n2 + 15);
            int n3 = profilerTable.getRowHeight() * 8;
            labelRenderer.setValue("Inactive RequestProcessor thread [Was:Just template/AWT-EventQueue-0]", -1);
            Dimension dimension = new Dimension(labelRenderer.getPreferredSize().width, n3 += profilerTable.getTableHeader().getPreferredSize().height);
            profilerTable.setPreferredScrollableViewportSize(dimension);
            ProfilerTableContainer profilerTableContainer = new ProfilerTableContainer(profilerTable, true, null);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
            jPanel.add((Component)profilerTableContainer, "Center");
            jComponent.add((Component)jPanel, "Center");
            FilteringToolbar filteringToolbar = new FilteringToolbar(FILTER_THREADS){

                @Override
                protected void filterChanged() {
                    if (this.isAll()) {
                        profilerTable.setRowFilter(null);
                    } else {
                        profilerTable.setRowFilter(new RowFilter(){

                            public boolean include(RowFilter.Entry entry) {
                                return this.passes(entry.getStringValue(1));
                            }
                        });
                    }
                }
            };
            filteringToolbar.add(Box.createHorizontalStrut(2));
            ((JToolBar)filteringToolbar).addSeparator();
            filteringToolbar.add(Box.createHorizontalStrut(3));
            final JCheckBox jCheckBox = new JCheckBox(MERGE_THREADS, this.mergeSelectedThreads){

                @Override
                protected void fireItemStateChanged(ItemEvent itemEvent) {
                    ThreadsSelector.this.mergeSelectedThreads = this.isSelected() && !ThreadsSelector.this.displayAllThreads;
                    ThreadsSelector.this.fireSelectionChanged();
                }

                @Override
                public String getToolTipText() {
                    return this.isEnabled() ? super.getToolTipText() : MERGE_THREADS_TOOLTIP_DISABLED;
                }
            };
            jCheckBox.setToolTipText(MERGE_THREADS_TOOLTIP);
            final boolean[] blArray = new boolean[1];
            final JCheckBox jCheckBox2 = new JCheckBox(ALL_THREADS, this.displayAllThreads){

                @Override
                protected void fireItemStateChanged(ItemEvent itemEvent) {
                    if (blArray[0]) {
                        return;
                    }
                    ThreadsSelector.this.displayAllThreads = this.isSelected();
                    CPUResultsSnapshot cPUResultsSnapshot = ThreadsSelector.this.getSnapshot();
                    if (cPUResultsSnapshot != null && ThreadsSelector.this.displayAllThreads) {
                        for (int i = 0; i < cPUResultsSnapshot.getNThreads(); ++i) {
                            ThreadsSelector.this.selection.add(cPUResultsSnapshot.getThreadIds()[i]);
                        }
                    } else {
                        ThreadsSelector.this.selection.clear();
                    }
                    jCheckBox.setEnabled(!ThreadsSelector.this.displayAllThreads);
                    if (ThreadsSelector.this.displayAllThreads) {
                        jCheckBox.setSelected(false);
                        ThreadsSelector.this.mergeSelectedThreads = false;
                    }
                    selectedThreadsModel.fireTableDataChanged();
                    ThreadsSelector.this.fireSelectionChanged();
                }
            };
            jCheckBox2.setToolTipText(ALL_THREADS_TOOLTIP);
            this.allThreadsResetter = new Runnable(){

                @Override
                public void run() {
                    blArray[0] = true;
                    jCheckBox2.setSelected(false);
                    jCheckBox.setEnabled(true);
                    blArray[0] = false;
                }
            };
            filteringToolbar.add(jCheckBox2);
            filteringToolbar.add(Box.createHorizontalStrut(7));
            filteringToolbar.add(jCheckBox);
            filteringToolbar.add(Box.createHorizontalStrut(20));
            jComponent.add((Component)filteringToolbar, "South");
            n = 12;
        }
        object = new ProfilerPopup.Listener(){

            @Override
            protected void popupHidden() {
                if (!ThreadsSelector.this.displayAllThreads && ThreadsSelector.this.selection.isEmpty()) {
                    ThreadsSelector.this.displayAllThreads = true;
                    ThreadsSelector.this.mergeSelectedThreads = false;
                    ThreadsSelector.this.fireSelectionChanged();
                }
                ThreadsSelector.this.allThreadsResetter = null;
            }
        };
        ProfilerPopup.createRelative(this, jComponent, 6, n, (ProfilerPopup.Listener)object).show();
    }

    private void fireSelectionChanged() {
        HashSet<Integer> hashSet = this.displayAllThreads ? null : new HashSet<Integer>(this.selection);
        this.selectionChanged(hashSet, this.mergeSelectedThreads);
    }

    private class SelectedThreadsModel
    extends AbstractTableModel {
        private SelectedThreadsModel() {
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return COLUMN_SELECTED;
            }
            if (n == 1) {
                return COLUMN_THREAD;
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            if (n == 1) {
                return String.class;
            }
            return null;
        }

        @Override
        public int getRowCount() {
            CPUResultsSnapshot cPUResultsSnapshot = ThreadsSelector.this.getSnapshot();
            return cPUResultsSnapshot == null ? 0 : cPUResultsSnapshot.getNThreads();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return ThreadsSelector.this.selection.contains(ThreadsSelector.this.getSnapshot().getThreadIds()[n]);
            }
            if (n2 == 1) {
                return ThreadsSelector.this.getSnapshot().getThreadNames()[n];
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                int n3 = ThreadsSelector.this.getSnapshot().getThreadIds()[n];
                if (Boolean.TRUE.equals(object)) {
                    ThreadsSelector.this.selection.add(n3);
                } else {
                    ThreadsSelector.this.selection.remove(n3);
                }
                if (ThreadsSelector.this.allThreadsResetter != null) {
                    ThreadsSelector.this.allThreadsResetter.run();
                }
                ThreadsSelector.this.displayAllThreads = false;
                ThreadsSelector.this.fireSelectionChanged();
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }
    }
}

