"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Fs = require("fs");
const Os = require("os");
function getStats(path) {
    return new Promise((resolve, reject) => {
        Fs.lstat(path, (err, stat) => {
            if (err) {
                reject(err);
            }
            else {
                resolve(stat);
            }
        });
    });
}
exports.getStats = getStats;
// from https://github.com/sindresorhus/untildify/blob/f85a087418aeaa2beb56fe2684fe3b64fc8c588d/index.js#L11
function untildify(pathWithTilde) {
    const homeDirectory = Os.homedir();
    return homeDirectory
        ? pathWithTilde.replace(/^~(?=$|\/|\\)/, homeDirectory)
        : pathWithTilde;
}
exports.untildify = untildify;
//# sourceMappingURL=fs.js.map