/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.AnyGetterWriter;
import com.fasterxml.jackson.databind.ser.BasicSerializerFactory;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.PropertyBuilder;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.impl.FilteredBeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.impl.PropertyBasedObjectIdGenerator;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class BeanSerializerFactory
extends BasicSerializerFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final BeanSerializerFactory instance = new BeanSerializerFactory(null);

    protected BeanSerializerFactory(SerializerFactoryConfig config) {
        super(config);
    }

    @Override
    public SerializerFactory withConfig(SerializerFactoryConfig config) {
        if (this._factoryConfig == config) {
            return this;
        }
        if (this.getClass() != BeanSerializerFactory.class) {
            throw new IllegalStateException("Subtype of BeanSerializerFactory (" + this.getClass().getName() + ") has not properly overridden method 'withAdditionalSerializers': can not instantiate subtype with " + "additional serializer definitions");
        }
        return new BeanSerializerFactory(config);
    }

    @Override
    protected Iterable<Serializers> customSerializers() {
        return this._factoryConfig.serializers();
    }

    @Override
    public JsonSerializer<Object> createSerializer(SerializerProvider prov, JavaType origType) throws JsonMappingException {
        boolean staticTyping;
        SerializationConfig config = prov.getConfig();
        Object beanDesc = config.introspect(origType);
        JsonSerializer<Object> ser = this.findSerializerFromAnnotation(prov, ((BeanDescription)beanDesc).getClassInfo());
        if (ser != null) {
            return ser;
        }
        JavaType type2 = this.modifyTypeByAnnotation(config, ((BeanDescription)beanDesc).getClassInfo(), origType);
        if (type2 == origType) {
            staticTyping = false;
        } else {
            staticTyping = true;
            if (!type2.hasRawClass(origType.getRawClass())) {
                beanDesc = config.introspect(type2);
            }
        }
        Converter<Object, Object> conv = ((BeanDescription)beanDesc).findSerializationConverter();
        if (conv == null) {
            return this._createSerializer2(prov, type2, (BeanDescription)beanDesc, staticTyping);
        }
        JavaType delegateType = conv.getOutputType(prov.getTypeFactory());
        if (!delegateType.hasRawClass(type2.getRawClass())) {
            beanDesc = config.introspect(delegateType);
            ser = this.findSerializerFromAnnotation(prov, ((BeanDescription)beanDesc).getClassInfo());
        }
        if (ser == null && !delegateType.isJavaLangObject()) {
            ser = this._createSerializer2(prov, delegateType, (BeanDescription)beanDesc, true);
        }
        return new StdDelegatingSerializer(conv, delegateType, ser);
    }

    protected JsonSerializer<?> _createSerializer2(SerializerProvider prov, JavaType type2, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
        JsonSerializer<Object> ser = this.findSerializerByAnnotations(prov, type2, beanDesc);
        if (ser != null) {
            return ser;
        }
        SerializationConfig config = prov.getConfig();
        if (type2.isContainerType()) {
            if (!staticTyping) {
                staticTyping = this.usesStaticTyping(config, beanDesc, null);
            }
            if ((ser = this.buildContainerSerializer(prov, type2, beanDesc, staticTyping)) != null) {
                return ser;
            }
        } else {
            Serializers serializers;
            Iterator<Object> i$ = this.customSerializers().iterator();
            while (i$.hasNext() && (ser = (serializers = i$.next()).findSerializer(config, type2, beanDesc)) == null) {
            }
        }
        if (ser == null && (ser = this.findSerializerByLookup(type2, config, beanDesc, staticTyping)) == null && (ser = this.findSerializerByPrimaryType(prov, type2, beanDesc, staticTyping)) == null && (ser = this.findBeanSerializer(prov, type2, beanDesc)) == null && (ser = this.findSerializerByAddonType(config, type2, beanDesc, staticTyping)) == null) {
            ser = prov.getUnknownTypeSerializer(beanDesc.getBeanClass());
        }
        if (ser != null && this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod2 : this._factoryConfig.serializerModifiers()) {
                ser = mod2.modifySerializer(config, beanDesc, ser);
            }
        }
        return ser;
    }

    public JsonSerializer<Object> findBeanSerializer(SerializerProvider prov, JavaType type2, BeanDescription beanDesc) throws JsonMappingException {
        if (!this.isPotentialBeanType(type2.getRawClass()) && !type2.isEnumType()) {
            return null;
        }
        return this.constructBeanSerializer(prov, beanDesc);
    }

    public TypeSerializer findPropertyTypeSerializer(JavaType baseType, SerializationConfig config, AnnotatedMember accessor2) throws JsonMappingException {
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findPropertyTypeResolver(config, accessor2, baseType);
        if (b == null) {
            return this.createTypeSerializer(config, baseType);
        }
        Collection<NamedType> subtypes = config.getSubtypeResolver().collectAndResolveSubtypes(accessor2, config, ai, baseType);
        return b.buildTypeSerializer(config, baseType, subtypes);
    }

    public TypeSerializer findPropertyContentTypeSerializer(JavaType containerType, SerializationConfig config, AnnotatedMember accessor2) throws JsonMappingException {
        JavaType contentType = containerType.getContentType();
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findPropertyContentTypeResolver(config, accessor2, containerType);
        if (b == null) {
            return this.createTypeSerializer(config, contentType);
        }
        Collection<NamedType> subtypes = config.getSubtypeResolver().collectAndResolveSubtypes(accessor2, config, ai, contentType);
        return b.buildTypeSerializer(config, contentType, subtypes);
    }

    protected JsonSerializer<Object> constructBeanSerializer(SerializerProvider prov, BeanDescription beanDesc) throws JsonMappingException {
        JsonSerializer<Object> ser;
        if (beanDesc.getBeanClass() == Object.class) {
            return prov.getUnknownTypeSerializer(Object.class);
        }
        SerializationConfig config = prov.getConfig();
        BeanSerializerBuilder builder = this.constructBeanSerializerBuilder(beanDesc);
        builder.setConfig(config);
        List<BeanPropertyWriter> props = this.findBeanProperties(prov, beanDesc, builder);
        if (props == null) {
            props = new ArrayList<BeanPropertyWriter>();
        }
        prov.getAnnotationIntrospector().findAndAddVirtualProperties(config, beanDesc.getClassInfo(), props);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod2 : this._factoryConfig.serializerModifiers()) {
                props = mod2.changeProperties(config, beanDesc, props);
            }
        }
        props = this.filterBeanProperties(config, beanDesc, props);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod2 : this._factoryConfig.serializerModifiers()) {
                props = mod2.orderProperties(config, beanDesc, props);
            }
        }
        builder.setObjectIdWriter(this.constructObjectIdHandler(prov, beanDesc, props));
        builder.setProperties(props);
        builder.setFilterId(this.findFilterId(config, beanDesc));
        AnnotatedMember anyGetter = beanDesc.findAnyGetter();
        if (anyGetter != null) {
            if (config.canOverrideAccessModifiers()) {
                anyGetter.fixAccess();
            }
            JavaType type2 = anyGetter.getType(beanDesc.bindingsForBeanType());
            boolean staticTyping = config.isEnabled(MapperFeature.USE_STATIC_TYPING);
            JavaType valueType = type2.getContentType();
            TypeSerializer typeSer = this.createTypeSerializer(config, valueType);
            MapSerializer anySer = this.findSerializerFromAnnotation(prov, anyGetter);
            if (anySer == null) {
                anySer = MapSerializer.construct(null, type2, staticTyping, typeSer, null, null, null);
            }
            PropertyName name2 = new PropertyName(anyGetter.getName());
            BeanProperty.Std anyProp = new BeanProperty.Std(name2, valueType, null, beanDesc.getClassAnnotations(), anyGetter, PropertyMetadata.STD_OPTIONAL);
            builder.setAnyGetter(new AnyGetterWriter(anyProp, anyGetter, anySer));
        }
        this.processViews(config, builder);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod3 : this._factoryConfig.serializerModifiers()) {
                builder = mod3.updateBuilder(config, beanDesc, builder);
            }
        }
        if ((ser = builder.build()) == null && beanDesc.hasKnownClassAnnotations()) {
            return builder.createDummy();
        }
        return ser;
    }

    protected ObjectIdWriter constructObjectIdHandler(SerializerProvider prov, BeanDescription beanDesc, List<BeanPropertyWriter> props) throws JsonMappingException {
        ObjectIdInfo objectIdInfo = beanDesc.getObjectIdInfo();
        if (objectIdInfo == null) {
            return null;
        }
        Class<? extends ObjectIdGenerator<?>> implClass = objectIdInfo.getGeneratorType();
        if (implClass == ObjectIdGenerators.PropertyGenerator.class) {
            String propName = objectIdInfo.getPropertyName().getSimpleName();
            BeanPropertyWriter idProp = null;
            int i = 0;
            int len = props.size();
            while (true) {
                if (i == len) {
                    throw new IllegalArgumentException("Invalid Object Id definition for " + beanDesc.getBeanClass().getName() + ": can not find property with name '" + propName + "'");
                }
                BeanPropertyWriter prop = props.get(i);
                if (propName.equals(prop.getName())) {
                    idProp = prop;
                    if (i <= 0) break;
                    props.remove(i);
                    props.add(0, idProp);
                    break;
                }
                ++i;
            }
            JavaType idType = idProp.getType();
            PropertyBasedObjectIdGenerator gen2 = new PropertyBasedObjectIdGenerator(objectIdInfo, idProp);
            return ObjectIdWriter.construct(idType, (PropertyName)null, gen2, objectIdInfo.getAlwaysAsId());
        }
        JavaType type2 = prov.constructType(implClass);
        JavaType idType = prov.getTypeFactory().findTypeParameters(type2, ObjectIdGenerator.class)[0];
        ObjectIdGenerator<?> gen3 = prov.objectIdGeneratorInstance(beanDesc.getClassInfo(), objectIdInfo);
        return ObjectIdWriter.construct(idType, objectIdInfo.getPropertyName(), gen3, objectIdInfo.getAlwaysAsId());
    }

    protected BeanPropertyWriter constructFilteredBeanWriter(BeanPropertyWriter writer2, Class<?>[] inViews) {
        return FilteredBeanPropertyWriter.constructViewBased(writer2, inViews);
    }

    protected PropertyBuilder constructPropertyBuilder(SerializationConfig config, BeanDescription beanDesc) {
        return new PropertyBuilder(config, beanDesc);
    }

    protected BeanSerializerBuilder constructBeanSerializerBuilder(BeanDescription beanDesc) {
        return new BeanSerializerBuilder(beanDesc);
    }

    protected boolean isPotentialBeanType(Class<?> type2) {
        return ClassUtil.canBeABeanType(type2) == null && !ClassUtil.isProxyType(type2);
    }

    protected List<BeanPropertyWriter> findBeanProperties(SerializerProvider prov, BeanDescription beanDesc, BeanSerializerBuilder builder) throws JsonMappingException {
        List<BeanPropertyDefinition> properties = beanDesc.findProperties();
        SerializationConfig config = prov.getConfig();
        this.removeIgnorableTypes(config, beanDesc, properties);
        if (config.isEnabled(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS)) {
            this.removeSetterlessGetters(config, beanDesc, properties);
        }
        if (properties.isEmpty()) {
            return null;
        }
        boolean staticTyping = this.usesStaticTyping(config, beanDesc, null);
        PropertyBuilder pb = this.constructPropertyBuilder(config, beanDesc);
        ArrayList<BeanPropertyWriter> result = new ArrayList<BeanPropertyWriter>(properties.size());
        TypeBindings typeBind = beanDesc.bindingsForBeanType();
        for (BeanPropertyDefinition property : properties) {
            AnnotatedMember accessor2 = property.getAccessor();
            if (property.isTypeId()) {
                if (accessor2 == null) continue;
                if (config.canOverrideAccessModifiers()) {
                    accessor2.fixAccess();
                }
                builder.setTypeId(accessor2);
                continue;
            }
            AnnotationIntrospector.ReferenceProperty refType = property.findReferenceType();
            if (refType != null && refType.isBackReference()) continue;
            if (accessor2 instanceof AnnotatedMethod) {
                result.add(this._constructWriter(prov, property, typeBind, pb, staticTyping, (AnnotatedMethod)accessor2));
                continue;
            }
            result.add(this._constructWriter(prov, property, typeBind, pb, staticTyping, (AnnotatedField)accessor2));
        }
        return result;
    }

    protected List<BeanPropertyWriter> filterBeanProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> props) {
        AnnotatedClass ac;
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        String[] ignored = intr.findPropertiesToIgnore(ac = beanDesc.getClassInfo());
        if (ignored != null && ignored.length > 0) {
            HashSet<String> ignoredSet = ArrayBuilders.arrayToSet(ignored);
            Iterator<BeanPropertyWriter> it = props.iterator();
            while (it.hasNext()) {
                if (!ignoredSet.contains(it.next().getName())) continue;
                it.remove();
            }
        }
        return props;
    }

    protected void processViews(SerializationConfig config, BeanSerializerBuilder builder) {
        List<BeanPropertyWriter> props = builder.getProperties();
        boolean includeByDefault = config.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
        int propCount = props.size();
        int viewsFound = 0;
        BeanPropertyWriter[] filtered = new BeanPropertyWriter[propCount];
        for (int i = 0; i < propCount; ++i) {
            BeanPropertyWriter bpw = props.get(i);
            Class<?>[] views = bpw.getViews();
            if (views == null) {
                if (!includeByDefault) continue;
                filtered[i] = bpw;
                continue;
            }
            ++viewsFound;
            filtered[i] = this.constructFilteredBeanWriter(bpw, views);
        }
        if (includeByDefault && viewsFound == 0) {
            return;
        }
        builder.setFilteredProperties(filtered);
    }

    protected void removeIgnorableTypes(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyDefinition> properties) {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        HashMap ignores = new HashMap();
        Iterator<BeanPropertyDefinition> it = properties.iterator();
        while (it.hasNext()) {
            BeanPropertyDefinition property = it.next();
            AnnotatedMember accessor2 = property.getAccessor();
            if (accessor2 == null) {
                it.remove();
                continue;
            }
            Class<?> type2 = accessor2.getRawType();
            Boolean result = (Boolean)ignores.get(type2);
            if (result == null) {
                BeanDescription desc = config.introspectClassAnnotations(type2);
                AnnotatedClass ac = desc.getClassInfo();
                result = intr.isIgnorableType(ac);
                if (result == null) {
                    result = Boolean.FALSE;
                }
                ignores.put(type2, result);
            }
            if (!result.booleanValue()) continue;
            it.remove();
        }
    }

    protected void removeSetterlessGetters(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyDefinition> properties) {
        Iterator<BeanPropertyDefinition> it = properties.iterator();
        while (it.hasNext()) {
            BeanPropertyDefinition property = it.next();
            if (property.couldDeserialize() || property.isExplicitlyIncluded()) continue;
            it.remove();
        }
    }

    protected BeanPropertyWriter _constructWriter(SerializerProvider prov, BeanPropertyDefinition propDef, TypeBindings typeContext, PropertyBuilder pb, boolean staticTyping, AnnotatedMember accessor2) throws JsonMappingException {
        PropertyName name2 = propDef.getFullName();
        if (prov.canOverrideAccessModifiers()) {
            accessor2.fixAccess();
        }
        JavaType type2 = accessor2.getType(typeContext);
        BeanProperty.Std property = new BeanProperty.Std(name2, type2, propDef.getWrapperName(), pb.getClassAnnotations(), accessor2, propDef.getMetadata());
        JsonSerializer<Object> annotatedSerializer = this.findSerializerFromAnnotation(prov, accessor2);
        if (annotatedSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)annotatedSerializer)).resolve(prov);
        }
        annotatedSerializer = prov.handlePrimaryContextualization(annotatedSerializer, property);
        TypeSerializer contentTypeSer = null;
        if (ClassUtil.isCollectionMapOrArray(type2.getRawClass()) || type2.isCollectionLikeType() || type2.isMapLikeType()) {
            contentTypeSer = this.findPropertyContentTypeSerializer(type2, prov.getConfig(), accessor2);
        }
        TypeSerializer typeSer = this.findPropertyTypeSerializer(type2, prov.getConfig(), accessor2);
        BeanPropertyWriter pbw = pb.buildWriter(prov, propDef, type2, annotatedSerializer, typeSer, contentTypeSer, accessor2, staticTyping);
        return pbw;
    }
}

