/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.Operation;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.node.AExpression;
import org.objectweb.asm.Label;

public final class EBool
extends AExpression {
    private final Operation operation;
    private AExpression left;
    private AExpression right;

    public EBool(Location location, Operation operation, AExpression left, AExpression right) {
        super(location);
        this.operation = Objects.requireNonNull(operation);
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        this.left.storeSettings(settings);
        this.right.storeSettings(settings);
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.left.extractVariables(variables);
        this.right.extractVariables(variables);
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        this.left.expected = Boolean.TYPE;
        this.left.analyze(scriptRoot, locals);
        this.left = this.left.cast(scriptRoot, locals);
        this.right.expected = Boolean.TYPE;
        this.right.analyze(scriptRoot, locals);
        this.right = this.right.cast(scriptRoot, locals);
        if (this.left.constant != null && this.right.constant != null) {
            if (this.operation == Operation.AND) {
                this.constant = (Boolean)this.left.constant != false && (Boolean)this.right.constant != false;
            } else if (this.operation == Operation.OR) {
                this.constant = (Boolean)this.left.constant != false || (Boolean)this.right.constant != false;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = Boolean.TYPE;
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        if (this.operation == Operation.AND) {
            Label fals = new Label();
            Label end = new Label();
            this.left.write(classWriter, methodWriter, globals);
            methodWriter.ifZCmp(153, fals);
            this.right.write(classWriter, methodWriter, globals);
            methodWriter.ifZCmp(153, fals);
            methodWriter.push(true);
            methodWriter.goTo(end);
            methodWriter.mark(fals);
            methodWriter.push(false);
            methodWriter.mark(end);
        } else if (this.operation == Operation.OR) {
            Label tru = new Label();
            Label fals = new Label();
            Label end = new Label();
            this.left.write(classWriter, methodWriter, globals);
            methodWriter.ifZCmp(154, tru);
            this.right.write(classWriter, methodWriter, globals);
            methodWriter.ifZCmp(153, fals);
            methodWriter.mark(tru);
            methodWriter.push(true);
            methodWriter.goTo(end);
            methodWriter.mark(fals);
            methodWriter.push(false);
            methodWriter.mark(end);
        } else {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.left, this.operation.symbol, this.right);
    }
}

