/*
 * Decompiled with CFR 0.152.
 */
package esmska.data;

import esmska.data.event.ActionEventSupport;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.apache.commons.lang.ObjectUtils;

public class Log {
    public static final int ACTION_ADD_RECORD = 0;
    public static final int ACTION_REMOVE_RECORD = 1;
    public static final int ACTION_CLEAR_RECORDS = 2;
    private static final Log instance = new Log();
    private static final Logger logger = Logger.getLogger(Log.class.getName());
    private final List<Record> records = Collections.synchronizedList(new ArrayList());
    private ActionEventSupport actionSupport = new ActionEventSupport(this);

    public void addActionListener(ActionListener actionListener) {
        this.actionSupport.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionSupport.removeActionListener(actionListener);
    }

    private Log() {
    }

    public static Log getInstance() {
        return instance;
    }

    public List<Record> getRecords() {
        return Collections.unmodifiableList(this.records);
    }

    public void addRecord(Record record) {
        this.records.add(record);
        this.actionSupport.fireActionPerformed(0, null);
        logger.finer("A new log record added: " + record);
    }

    public void removeRecord(Record record) {
        this.records.remove(record);
        this.actionSupport.fireActionPerformed(1, null);
        logger.finer("A log record removed: " + record);
    }

    public void clearRecords() {
        this.records.clear();
        this.actionSupport.fireActionPerformed(2, null);
        logger.finer("All log records removed");
    }

    public int size() {
        return this.records.size();
    }

    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    public synchronized Record getLastRecord() {
        if (this.records.size() > 0) {
            return this.records.get(this.records.size() - 1);
        }
        return null;
    }

    public static class Record {
        private String message;
        private ImageIcon icon;
        private Date time;

        public Record(String message) {
            this(message, null, null);
        }

        public Record(String message, Date time, ImageIcon icon) {
            if (message == null) {
                throw new IllegalArgumentException("message");
            }
            this.message = message;
            this.time = (Date)ObjectUtils.defaultIfNull(time, new Date());
            this.icon = icon;
        }

        public ImageIcon getIcon() {
            return this.icon;
        }

        public String getMessage() {
            return this.message;
        }

        public Date getTime() {
            return this.time;
        }

        public String toString() {
            return "[time=" + this.time + "]";
        }
    }
}

