/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.block;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.AbstractDiskCache;
import org.apache.commons.jcs.auxiliary.disk.block.BlockDisk;
import org.apache.commons.jcs.auxiliary.disk.block.BlockDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.block.BlockDiskKeyStore;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.behavior.IRequireScheduler;
import org.apache.commons.jcs.engine.control.group.GroupAttrName;
import org.apache.commons.jcs.engine.control.group.GroupId;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlockDiskCache<K, V>
extends AbstractDiskCache<K, V>
implements IRequireScheduler {
    private static final Log log = LogFactory.getLog(BlockDiskCache.class);
    private final String logCacheName;
    private final String fileName;
    private BlockDisk dataFile;
    private final BlockDiskCacheAttributes blockDiskCacheAttributes;
    private final File rootDirectory;
    private BlockDiskKeyStore<K> keyStore;
    private final ReentrantReadWriteLock storageLock = new ReentrantReadWriteLock();
    private ScheduledFuture<?> future;

    public BlockDiskCache(BlockDiskCacheAttributes cacheAttributes) {
        this(cacheAttributes, null);
    }

    public BlockDiskCache(BlockDiskCacheAttributes cacheAttributes, IElementSerializer elementSerializer) {
        super(cacheAttributes);
        this.setElementSerializer(elementSerializer);
        this.blockDiskCacheAttributes = cacheAttributes;
        this.logCacheName = "Region [" + this.getCacheName() + "] ";
        if (log.isInfoEnabled()) {
            log.info(this.logCacheName + "Constructing BlockDiskCache with attributes " + cacheAttributes);
        }
        this.fileName = this.getCacheName().replaceAll("[^a-zA-Z0-9-_\\.]", "_");
        this.rootDirectory = cacheAttributes.getDiskPath();
        if (log.isInfoEnabled()) {
            log.info(this.logCacheName + "Cache file root directory: [" + this.rootDirectory + "]");
        }
        try {
            this.dataFile = this.blockDiskCacheAttributes.getBlockSizeBytes() > 0 ? new BlockDisk(new File(this.rootDirectory, this.fileName + ".data"), this.blockDiskCacheAttributes.getBlockSizeBytes(), this.getElementSerializer()) : new BlockDisk(new File(this.rootDirectory, this.fileName + ".data"), this.getElementSerializer());
            this.keyStore = new BlockDiskKeyStore(this.blockDiskCacheAttributes, this);
            boolean alright = this.verifyDisk();
            if (this.keyStore.size() == 0 || !alright) {
                this.reset();
            }
            this.setAlive(true);
            if (log.isInfoEnabled()) {
                log.info(this.logCacheName + "Block Disk Cache is alive.");
            }
        }
        catch (IOException e) {
            log.error(this.logCacheName + "Failure initializing for fileName: " + this.fileName + " and root directory: " + this.rootDirectory, e);
        }
    }

    @Override
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutor) {
        if (this.blockDiskCacheAttributes.getKeyPersistenceIntervalSeconds() > 0L) {
            this.future = scheduledExecutor.scheduleAtFixedRate(this.keyStore::saveKeys, this.blockDiskCacheAttributes.getKeyPersistenceIntervalSeconds(), this.blockDiskCacheAttributes.getKeyPersistenceIntervalSeconds(), TimeUnit.SECONDS);
        }
    }

    protected boolean verifyDisk() {
        boolean alright = false;
        this.storageLock.readLock().lock();
        try {
            this.keyStore.entrySet().stream().limit(100L).forEach(entry -> {
                try {
                    Object data = this.dataFile.read((int[])entry.getValue());
                    if (data == null) {
                        throw new IOException("Data is null");
                    }
                }
                catch (IOException | ClassNotFoundException e) {
                    throw new RuntimeException(this.logCacheName + " Couldn't find data for key [" + entry.getKey() + "]", e);
                }
            });
            alright = true;
        }
        catch (Exception e) {
            log.warn(this.logCacheName + " Problem verifying disk.", e);
            alright = false;
        }
        finally {
            this.storageLock.readLock().unlock();
        }
        return alright;
    }

    @Override
    public Set<K> getKeySet() throws IOException {
        HashSet<K> keys = new HashSet<K>();
        this.storageLock.readLock().lock();
        try {
            keys.addAll(this.keyStore.keySet());
        }
        finally {
            this.storageLock.readLock().unlock();
        }
        return keys;
    }

    @Override
    public Map<K, ICacheElement<K, V>> processGetMatching(String pattern) {
        HashSet<K> keyArray = null;
        this.storageLock.readLock().lock();
        try {
            keyArray = new HashSet<K>(this.keyStore.keySet());
        }
        finally {
            this.storageLock.readLock().unlock();
        }
        Set matchingKeys = this.getKeyMatcher().getMatchingKeysFromArray(pattern, keyArray);
        Map<Object, ICacheElement> elements = matchingKeys.stream().collect(Collectors.toMap(key -> key, key -> this.processGet(key))).entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(entry -> entry.getKey(), entry -> (ICacheElement)entry.getValue()));
        return elements;
    }

    @Override
    public int getSize() {
        return this.keyStore.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ICacheElement<K, V> processGet(K key) {
        if (!this.isAlive()) {
            if (log.isDebugEnabled()) {
                log.debug(this.logCacheName + "No longer alive so returning null for key = " + key);
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug(this.logCacheName + "Trying to get from disk: " + key);
        }
        ICacheElement object = null;
        try {
            this.storageLock.readLock().lock();
            try {
                int[] ded = this.keyStore.get(key);
                if (ded != null) {
                    object = (ICacheElement)this.dataFile.read(ded);
                }
            }
            finally {
                this.storageLock.readLock().unlock();
            }
        }
        catch (IOException ioe) {
            log.error(this.logCacheName + "Failure getting from disk--IOException, key = " + key, ioe);
            this.reset();
        }
        catch (Exception e) {
            log.error(this.logCacheName + "Failure getting from disk, key = " + key, e);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processUpdate(ICacheElement<K, V> element) {
        if (!this.isAlive()) {
            if (log.isDebugEnabled()) {
                log.debug(this.logCacheName + "No longer alive; aborting put of key = " + element.getKey());
            }
            return;
        }
        int[] old = null;
        this.storageLock.writeLock().lock();
        try {
            old = this.keyStore.get(element.getKey());
            if (old != null) {
                this.dataFile.freeBlocks(old);
            }
            int[] blocks = this.dataFile.write(element);
            this.keyStore.put(element.getKey(), blocks);
            if (log.isDebugEnabled()) {
                log.debug(this.logCacheName + "Put to file [" + this.fileName + "] key [" + element.getKey() + "]");
            }
        }
        catch (IOException e) {
            log.error(this.logCacheName + "Failure updating element, key: " + element.getKey() + " old: " + Arrays.toString(old), e);
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug(this.logCacheName + "Storing element on disk, key: " + element.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean processRemove(K key) {
        if (!this.isAlive()) {
            if (log.isDebugEnabled()) {
                log.debug(this.logCacheName + "No longer alive so returning false for key = " + key);
            }
            return false;
        }
        boolean reset = false;
        boolean removed = false;
        this.storageLock.writeLock().lock();
        try {
            removed = key instanceof String && key.toString().endsWith(":") ? this.performPartialKeyRemoval((String)key) : (key instanceof GroupAttrName && ((GroupAttrName)key).attrName == null ? this.performGroupRemoval(((GroupAttrName)key).groupId) : this.performSingleKeyRemoval(key));
        }
        catch (Exception e) {
            log.error(this.logCacheName + "Problem removing element.", e);
            reset = true;
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
        if (reset) {
            this.reset();
        }
        return removed;
    }

    private boolean performGroupRemoval(GroupId key) {
        List<Object> itemsToRemove = this.keyStore.keySet().stream().filter(k -> k instanceof GroupAttrName && ((GroupAttrName)k).groupId.equals(key)).collect(Collectors.toList());
        itemsToRemove.forEach(fullKey -> this.performSingleKeyRemoval(fullKey));
        return !itemsToRemove.isEmpty();
    }

    private boolean performPartialKeyRemoval(String key) {
        List<Object> itemsToRemove = this.keyStore.keySet().stream().filter(k -> k instanceof String && k.toString().startsWith(key)).collect(Collectors.toList());
        itemsToRemove.forEach(fullKey -> this.performSingleKeyRemoval(fullKey));
        return !itemsToRemove.isEmpty();
    }

    private boolean performSingleKeyRemoval(K key) {
        boolean removed;
        int[] ded = this.keyStore.remove(key);
        boolean bl = removed = ded != null;
        if (removed) {
            this.dataFile.freeBlocks(ded);
        }
        if (log.isDebugEnabled()) {
            log.debug(this.logCacheName + "Disk removal: Removed from key hash, key [" + key + "] removed = " + removed);
        }
        return removed;
    }

    @Override
    protected void processRemoveAll() {
        this.reset();
    }

    @Override
    public void processDispose() {
        Thread t = new Thread(this::disposeInternal, "BlockDiskCache-DisposalThread");
        t.start();
        try {
            t.join(60000L);
        }
        catch (InterruptedException ex) {
            log.error(this.logCacheName + "Interrupted while waiting for disposal thread to finish.", ex);
        }
    }

    protected void disposeInternal() {
        if (!this.isAlive()) {
            log.error(this.logCacheName + "Not alive and dispose was called, filename: " + this.fileName);
            return;
        }
        this.storageLock.writeLock().lock();
        try {
            this.setAlive(false);
            this.keyStore.saveKeys();
            if (this.future != null) {
                this.future.cancel(true);
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug(this.logCacheName + "Closing files, base filename: " + this.fileName);
                }
                this.dataFile.close();
            }
            catch (IOException e) {
                log.error(this.logCacheName + "Failure closing files in dispose, filename: " + this.fileName, e);
            }
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
        if (log.isInfoEnabled()) {
            log.info(this.logCacheName + "Shutdown complete.");
        }
    }

    @Override
    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.blockDiskCacheAttributes;
    }

    private void reset() {
        if (log.isWarnEnabled()) {
            log.warn(this.logCacheName + "Resetting cache");
        }
        try {
            this.storageLock.writeLock().lock();
            this.keyStore.reset();
            if (this.dataFile != null) {
                this.dataFile.reset();
            }
        }
        catch (IOException e) {
            log.error(this.logCacheName + "Failure resetting state", e);
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
    }

    protected void freeBlocks(int[] blocksToFree) {
        this.dataFile.freeBlocks(blocksToFree);
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Block Disk Cache");
        ArrayList elems = new ArrayList();
        elems.add(new StatElement<Boolean>("Is Alive", this.isAlive()));
        elems.add(new StatElement<Integer>("Key Map Size", this.keyStore.size()));
        if (this.dataFile != null) {
            try {
                elems.add(new StatElement<Long>("Data File Length", this.dataFile.length()));
            }
            catch (IOException e) {
                log.error(e);
            }
            elems.add(new StatElement<Integer>("Block Size Bytes", this.dataFile.getBlockSizeBytes()));
            elems.add(new StatElement<Integer>("Number Of Blocks", this.dataFile.getNumberOfBlocks()));
            elems.add(new StatElement<Long>("Average Put Size Bytes", this.dataFile.getAveragePutSizeBytes()));
            elems.add(new StatElement<Integer>("Empty Blocks", this.dataFile.getEmptyBlocks()));
        }
        IStats sStats = super.getStatistics();
        elems.addAll(sStats.getStatElements());
        stats.setStatElements(elems);
        return stats;
    }

    @Override
    protected String getDiskLocation() {
        return this.dataFile.getFilePath();
    }
}

