/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.corrector.ReverseWayTagCorrector;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeGraph;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.tests.OverlappingWays;
import org.openstreetmap.josm.data.validation.tests.SelfIntersectingWay;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UserCancelException;

public class CombineWayAction
extends JosmAction {
    private static final BooleanProperty PROP_REVERSE_WAY = new BooleanProperty("tag-correction.reverse-way", true);

    public CombineWayAction() {
        super(I18n.tr("Combine Way", new Object[0]), "combineway", I18n.tr("Combine several ways into one.", new Object[0]), Shortcut.registerShortcut("tools:combineway", I18n.tr("Tool: {0}", I18n.tr("Combine Way", new Object[0])), 67, 5003), true);
        this.setHelpId(HelpUtil.ht("/Action/CombineWay"));
    }

    protected static boolean confirmChangeDirectionOfWays() {
        return new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Change directions?", new Object[0]), I18n.tr("Reverse and Combine", new Object[0]), I18n.tr("Cancel", new Object[0])).setButtonIcons("wayflip", "cancel").setContent(I18n.tr("The ways can not be combined in their current directions.  Do you want to reverse some of them?", new Object[0])).toggleEnable("combineway-reverse").showDialog().getValue() == 1;
    }

    protected static void warnCombiningImpossible() {
        String msg = I18n.tr("Could not combine ways<br>(They could not be merged into a single string of nodes)", new Object[0]);
        new Notification(msg).setIcon(1).show();
    }

    protected static Way getTargetWay(Collection<Way> combinedWays) {
        Way targetWay = combinedWays.iterator().next();
        Iterator<Way> iterator = combinedWays.iterator();
        while (iterator.hasNext()) {
            Way w;
            targetWay = w = iterator.next();
            if (w.isNew()) continue;
            break;
        }
        return targetWay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<Way, Command> combineWaysWorker(Collection<Way> ways) throws UserCancelException {
        List<Command> resolution;
        if (ways == null || ways.isEmpty()) {
            return null;
        }
        ways.remove(null);
        ways = new LinkedHashSet<Way>(ways);
        ways.removeIf(AbstractPrimitive::isIncomplete);
        if (ways.size() < 2) {
            return null;
        }
        List dataSets = ways.stream().map(OsmPrimitive::getDataSet).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (dataSets.size() != 1) {
            throw new IllegalArgumentException("Cannot combine ways of multiple data sets.");
        }
        List<Node> path = CombineWayAction.tryJoin(ways);
        if (path.isEmpty()) {
            CombineWayAction.warnCombiningImpossible();
            return null;
        }
        TagCollection wayTags = TagCollection.unionOfAllPrimitives(ways);
        LinkedList<Command> reverseWayTagCommands = new LinkedList<Command>();
        List<Way> reversedWays = new LinkedList<Way>();
        List<Way> unreversedWays = new LinkedList<Way>();
        CombineWayAction.detectReversedWays(ways, path, reversedWays, unreversedWays);
        if (unreversedWays.isEmpty()) {
            Collections.reverse(path);
            unreversedWays = reversedWays;
            reversedWays = null;
        }
        if (reversedWays != null && !reversedWays.isEmpty()) {
            if (!CombineWayAction.confirmChangeDirectionOfWays()) {
                return null;
            }
            unreversedWays = ReverseWayTagCorrector.irreversibleWays(unreversedWays);
            if ((reversedWays = ReverseWayTagCorrector.irreversibleWays(reversedWays)).size() > unreversedWays.size()) {
                Collections.reverse(path);
                List<Way> tempWays = unreversedWays;
                unreversedWays = null;
                reversedWays = tempWays;
            }
            if (!reversedWays.isEmpty() && Boolean.TRUE.equals(PROP_REVERSE_WAY.get())) {
                ArrayList<Way> unreversedTagWays = new ArrayList<Way>(ways);
                unreversedTagWays.removeAll(reversedWays);
                ReverseWayTagCorrector reverseWayTagCorrector = new ReverseWayTagCorrector();
                ArrayList<Way> reversedTagWays = new ArrayList<Way>(reversedWays.size());
                for (Way w : reversedWays) {
                    Way wnew = new Way(w);
                    reversedTagWays.add(wnew);
                    reverseWayTagCommands.addAll(reverseWayTagCorrector.execute(w, wnew));
                }
                if (!reverseWayTagCommands.isEmpty()) {
                    UndoRedoHandler.getInstance().add(new SequenceCommand(I18n.tr("Reverse Ways", new Object[0]), reverseWayTagCommands));
                }
                wayTags = TagCollection.unionOfAllPrimitives(reversedTagWays);
                wayTags.add(TagCollection.unionOfAllPrimitives(unreversedTagWays));
            }
        }
        Way targetWay = CombineWayAction.getTargetWay(ways);
        Way modifiedTargetWay = new Way(targetWay);
        modifiedTargetWay.setNodes(path);
        try {
            resolution = CombinePrimitiveResolverDialog.launchIfNecessary(wayTags, ways, Collections.singleton(targetWay));
        }
        finally {
            if (!reverseWayTagCommands.isEmpty()) {
                UndoRedoHandler.getInstance().undo();
            }
        }
        LinkedList<Command> cmds = new LinkedList<Command>();
        LinkedList<Way> deletedWays = new LinkedList<Way>(ways);
        deletedWays.remove(targetWay);
        cmds.add(new ChangeCommand((DataSet)dataSets.get(0), targetWay, modifiedTargetWay));
        cmds.addAll(reverseWayTagCommands);
        cmds.addAll(resolution);
        cmds.add(new DeleteCommand((DataSet)dataSets.get(0), deletedWays));
        SequenceCommand sequenceCommand = new SequenceCommand(I18n.trn("Combine {0} way", "Combine {0} ways", ways.size(), ways.size()), cmds);
        return new Pair<Way, Command>(targetWay, sequenceCommand);
    }

    protected static void detectReversedWays(Collection<Way> ways, List<Node> path, List<Way> reversedWays, List<Way> unreversedWays) {
        for (Way w : ways) {
            if (w.getNodesCount() < 2) {
                unreversedWays.add(w);
                continue;
            }
            boolean foundStartSegment = false;
            int last = path.lastIndexOf(w.getNode(0));
            for (int i = path.indexOf(w.getNode(0)); i <= last; ++i) {
                if (path.get(i) != w.getNode(0) || i + 1 >= path.size() || w.getNode(1) != path.get(i + 1)) continue;
                foundStartSegment = true;
                break;
            }
            if (foundStartSegment) {
                unreversedWays.add(w);
                continue;
            }
            reversedWays.add(w);
        }
    }

    protected static List<Node> tryJoin(Collection<Way> ways) {
        List<Node> path = CombineWayAction.joinWithMultipolygonCode(ways);
        if (path.isEmpty()) {
            NodeGraph graph = NodeGraph.createNearlyUndirectedGraphFromNodeWays(ways);
            path = graph.buildSpanningPathNoRemove();
        }
        return path;
    }

    private static List<Node> joinWithMultipolygonCode(Collection<Way> ways) {
        LinkedList<Way> toJoin = new LinkedList<Way>(ways);
        toJoin.sort((o1, o2) -> {
            int d = Boolean.compare(o1.isNew(), o2.isNew());
            if (d == 0) {
                d = Boolean.compare(o1.isClosed(), o2.isClosed());
            }
            return d;
        });
        Collection<Multipolygon.JoinedWay> list = Multipolygon.joinWays(toJoin);
        if (list.size() == 1) {
            return new ArrayList<Node>(list.iterator().next().getNodes());
        }
        return Collections.emptyList();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Pair<Way, Command> combineResult;
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (ds == null) {
            return;
        }
        Collection<Way> selectedWays = ds.getSelectedWays();
        if (selectedWays.size() < 2) {
            new Notification(I18n.tr("Please select at least two ways to combine.", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        try {
            combineResult = CombineWayAction.combineWaysWorker(selectedWays);
        }
        catch (UserCancelException ex) {
            Logging.trace(ex);
            return;
        }
        if (combineResult == null) {
            return;
        }
        Way selectedWay = (Way)combineResult.a;
        UndoRedoHandler.getInstance().add((Command)combineResult.b);
        Test test = new OverlappingWays();
        test.startTest(null);
        test.visit((Way)combineResult.a);
        test.endTest();
        if (test.getErrors().isEmpty()) {
            test = new SelfIntersectingWay();
            test.startTest(null);
            test.visit((Way)combineResult.a);
            test.endTest();
        }
        if (!test.getErrors().isEmpty()) {
            new Notification(test.getErrors().get(0).getMessage()).setIcon(2).setDuration(Notification.TIME_SHORT).show();
        }
        if (selectedWay != null) {
            GuiHelper.runInEDT(() -> ds.setSelected(selectedWay));
        }
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        int numWays = 0;
        if (OsmUtils.isOsmCollectionEditable(selection)) {
            for (OsmPrimitive osmPrimitive : selection) {
                if (osmPrimitive instanceof Way && !osmPrimitive.isIncomplete() && ++numWays >= 2) break;
            }
        }
        this.setEnabled(numWays >= 2);
    }
}

