/*
 *  libMirage: version
 *  Copyright (C) 2008-2014 Rok Mandeljc
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __MIRAGE_VERSION_H__
#define __MIRAGE_VERSION_H__


G_BEGIN_DECLS

extern const guint mirage_version_major;
extern const guint mirage_version_minor;
extern const guint mirage_version_micro;

extern const guint mirage_soversion_major;
extern const guint mirage_soversion_minor;
extern const guint mirage_soversion_patch;

extern const gchar *mirage_version_long;
extern const gchar *mirage_version_short;

/**
 * MIRAGE_VERSION_MAJOR:
 *
 * <para>
 * The major version number of the libMirage library. Like #mirage_version_major,
 * but from the headers used at application compile time, rather than from the
 * library linked against at application run time.
 * </para>
 **/
#define MIRAGE_VERSION_MAJOR 3

/**
 * MIRAGE_VERSION_MINOR:
 *
 * <para>
 * The minor version number of the libMirage library. Like #mirage_version_minor,
 * but from the headers used at application compile time, rather than from the
 * library linked against at application run time.
 * </para>
 **/
#define MIRAGE_VERSION_MINOR 2

/**
 * MIRAGE_VERSION_MICRO:
 *
 * <para>
 * The micro version number of the libMirage library. Like #mirage_version_micro,
 * but from the headers used at application compile time, rather than from the
 * library linked against at application run time.
 * </para>
 **/
#define MIRAGE_VERSION_MICRO 4


/**
 * MIRAGE_VERSION_LONG:
 *
 * <para>
 * The long version string of the libMirage library. Like #mirage_version_long,
 * but from the headers used at application compile time, rather than from the
 * library linked against at application run time.
 * </para>
 **/
#define MIRAGE_VERSION_LONG "3.2.4"

/**
 * MIRAGE_VERSION_SHORT:
 *
 * <para>
 * The short version string of the libMirage library. Like #mirage_version_long,
 * but from the headers used at application compile time, rather than from the
 * library linked against at application run time.
 * </para>
 **/
#define MIRAGE_VERSION_SHORT "3.2"


/**
 * MIRAGE_SOVERSION_MAJOR:
 *
 * <para>
 * The major component of semantic version of the libMirage library. Like
 * #mirage_soversion_major, but from the headers used at application compile time,
 * rather than from the library linked against at application run time.
 * </para>
 **/
#define MIRAGE_SOVERSION_MAJOR 11

/**
 * MIRAGE_SOVERSION_MINOR:
 *
 * <para>
 * The minor component of semantic version of the libMirage library. Like
 * #mirage_soversion_minor, but from the headers used at application compile time,
 * rather than from the library linked against at application run time.
 * </para>
 **/
#define MIRAGE_SOVERSION_MINOR 0

/**
 * MIRAGE_SOVERSION_PATCH:
 *
 * <para>
 * The patch component of semantic version of the libMirage library. Like
 * #mirage_soversion_patch, but from the headers used at application compile time,
 * rather than from the library linked against at application run time.
 * </para>
 **/
#define MIRAGE_SOVERSION_PATCH 0

G_END_DECLS

#endif /* __MIRAGE_VERSION_H__ */
