/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileImageData;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.NamedOutputStream;
import net.sourceforge.plantuml.NewpagedDiagram;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.SplitParam;
import net.sourceforge.plantuml.SuggestedFile;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.html.CucaDiagramHtmlMaker;
import net.sourceforge.plantuml.png.PngSplitter;
import net.sourceforge.plantuml.project3.GanttDiagram;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

public class PSystemUtils {
    public static List<FileImageData> exportDiagrams(Diagram system, SuggestedFile suggested, FileFormatOption fileFormatOption) throws IOException {
        return PSystemUtils.exportDiagrams(system, suggested, fileFormatOption, false);
    }

    public static List<FileImageData> exportDiagrams(Diagram system, SuggestedFile suggestedFile, FileFormatOption fileFormatOption, boolean checkMetadata) throws IOException {
        boolean sameMetadata;
        File existingFile = suggestedFile.getFile(0);
        if (checkMetadata && fileFormatOption.getFileFormat().doesSupportMetadata() && existingFile.exists() && system.getNbImages() == 1 && (sameMetadata = fileFormatOption.getFileFormat().equalsMetadata(system.getMetadata(), existingFile))) {
            Log.info("Skipping " + existingFile.getAbsolutePath() + " because metadata has not changed.");
            return Arrays.asList(new FileImageData(existingFile, null));
        }
        if (system instanceof NewpagedDiagram) {
            return PSystemUtils.exportDiagramsNewpaged((NewpagedDiagram)system, suggestedFile, fileFormatOption);
        }
        if (system instanceof SequenceDiagram) {
            return PSystemUtils.exportDiagramsSequence((SequenceDiagram)system, suggestedFile, fileFormatOption);
        }
        if (system instanceof CucaDiagram) {
            return PSystemUtils.exportDiagramsCuca((CucaDiagram)system, suggestedFile, fileFormatOption);
        }
        if (system instanceof GanttDiagram) {
            return PSystemUtils.exportDiagramsGantt2((GanttDiagram)system, suggestedFile, fileFormatOption);
        }
        if (system instanceof ActivityDiagram3) {
            return PSystemUtils.exportDiagramsActivityDiagram3((ActivityDiagram3)system, suggestedFile, fileFormatOption);
        }
        return PSystemUtils.exportDiagramsDefault(system, suggestedFile, fileFormatOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FileImageData> exportDiagramsNewpaged(NewpagedDiagram system, SuggestedFile suggestedFile, FileFormatOption fileFormat) throws IOException {
        ArrayList<FileImageData> result = new ArrayList<FileImageData>();
        int nbImages = system.getNbImages();
        for (int i = 0; i < nbImages; ++i) {
            File f = suggestedFile.getFile(i);
            if (!PSystemUtils.canFileBeWritten(f)) {
                return result;
            }
            ImageData cmap = null;
            try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(f));){
                system.exportDiagram(fos, i, fileFormat);
            }
            Log.info("File size : " + f.length());
            result.add(new FileImageData(f, cmap));
        }
        return result;
    }

    public static boolean canFileBeWritten(File f) {
        Log.info("Creating file: " + f);
        if (f.exists() && !f.canWrite()) {
            if (OptionFlags.getInstance().isOverwrite()) {
                Log.info("Overwrite " + f);
                f.setWritable(true);
                f.delete();
                return true;
            }
            Log.error("Cannot write to file " + f);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FileImageData> exportDiagramsDefault(Diagram system, SuggestedFile suggestedFile, FileFormatOption fileFormat) throws IOException {
        if (suggestedFile.getFile(0).exists() && suggestedFile.getFile(0).isDirectory()) {
            throw new IllegalArgumentException("File is a directory " + suggestedFile);
        }
        ImageData imageData = null;
        try (OutputStream os = null;){
            if (!PSystemUtils.canFileBeWritten(suggestedFile.getFile(0))) {
                List<FileImageData> list = Collections.emptyList();
                return list;
            }
            os = new BufferedOutputStream(new FileOutputStream(suggestedFile.getFile(0)));
            imageData = system.exportDiagram(os, 0, fileFormat);
        }
        return Arrays.asList(new FileImageData(suggestedFile.getFile(0), imageData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FileImageData> exportDiagramsActivityDiagram3(ActivityDiagram3 system, SuggestedFile suggestedFile, FileFormatOption fileFormat) throws IOException {
        if (suggestedFile.getFile(0).exists() && suggestedFile.getFile(0).isDirectory()) {
            throw new IllegalArgumentException("File is a directory " + suggestedFile);
        }
        OutputStream os = null;
        ImageData cmap = null;
        ImageData imageData = null;
        try {
            if (!PSystemUtils.canFileBeWritten(suggestedFile.getFile(0))) {
                List<FileImageData> list = Collections.emptyList();
                return list;
            }
            os = new BufferedOutputStream(new FileOutputStream(suggestedFile.getFile(0)));
            imageData = cmap = system.exportDiagram(os, 0, fileFormat);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
        if (cmap != null && cmap.containsCMapData()) {
            system.exportCmap(suggestedFile, 0, cmap);
        }
        return Arrays.asList(new FileImageData(suggestedFile.getFile(0), imageData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FileImageData> exportDiagramsSequence(SequenceDiagram system, SuggestedFile suggestedFile, FileFormatOption fileFormat) throws IOException {
        ArrayList<FileImageData> result = new ArrayList<FileImageData>();
        int nbImages = system.getNbImages();
        for (int i = 0; i < nbImages; ++i) {
            File f = suggestedFile.getFile(i);
            if (!PSystemUtils.canFileBeWritten(suggestedFile.getFile(i))) {
                return result;
            }
            ImageData cmap = null;
            try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(f));){
                cmap = system.exportDiagram(fos, i, fileFormat);
            }
            if (cmap != null && cmap.containsCMapData()) {
                system.exportCmap(suggestedFile, i, cmap);
            }
            Log.info("File size : " + f.length());
            result.add(new FileImageData(f, cmap));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FileImageData> exportDiagramsCuca(CucaDiagram system, SuggestedFile suggestedFile, FileFormatOption fileFormat) throws IOException {
        if (suggestedFile.getFile(0).exists() && suggestedFile.getFile(0).isDirectory()) {
            throw new IllegalArgumentException("File is a directory " + suggestedFile);
        }
        if (fileFormat.getFileFormat() == FileFormat.HTML) {
            return PSystemUtils.createFilesHtml(system, suggestedFile);
        }
        ImageData cmap = null;
        try (OutputStream os = null;){
            if (!PSystemUtils.canFileBeWritten(suggestedFile.getFile(0))) {
                List<FileImageData> list = Collections.emptyList();
                return list;
            }
            os = new NamedOutputStream(suggestedFile.getFile(0));
            cmap = system.exportDiagram(os, 0, fileFormat);
        }
        List<File> result = Arrays.asList(suggestedFile.getFile(0));
        if (cmap != null && cmap.containsCMapData()) {
            system.exportCmap(suggestedFile, 0, cmap);
        }
        if (fileFormat.getFileFormat() == FileFormat.PNG) {
            result = new PngSplitter(suggestedFile, system.getHorizontalPages(), system.getVerticalPages(), system.getMetadata(), (int)(system.getScaleCoef(fileFormat) * 96.0), fileFormat.isWithMetadata(), system.getSkinParam().getSplitParam()).getFiles();
        }
        ArrayList<FileImageData> result2 = new ArrayList<FileImageData>();
        for (File f : result) {
            result2.add(new FileImageData(f, cmap));
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FileImageData> exportDiagramsGantt2(GanttDiagram system, SuggestedFile suggestedFile, FileFormatOption fileFormat) throws IOException {
        if (suggestedFile.getFile(0).exists() && suggestedFile.getFile(0).isDirectory()) {
            throw new IllegalArgumentException("File is a directory " + suggestedFile);
        }
        ImageData cmap = null;
        try (OutputStream os = null;){
            if (!PSystemUtils.canFileBeWritten(suggestedFile.getFile(0))) {
                List<FileImageData> list = Collections.emptyList();
                return list;
            }
            os = new NamedOutputStream(suggestedFile.getFile(0));
            cmap = system.exportDiagram(os, 0, fileFormat);
        }
        List<File> result = Arrays.asList(suggestedFile.getFile(0));
        if (fileFormat.getFileFormat() == FileFormat.PNG) {
            SplitParam splitParam = new SplitParam(HtmlColorUtils.BLACK, null, 5);
            result = new PngSplitter(suggestedFile, system.getHorizontalPages(), system.getVerticalPages(), system.getMetadata(), system.getDpi(fileFormat), fileFormat.isWithMetadata(), splitParam).getFiles();
        }
        ArrayList<FileImageData> result2 = new ArrayList<FileImageData>();
        for (File f : result) {
            result2.add(new FileImageData(f, cmap));
        }
        return result2;
    }

    private static List<FileImageData> createFilesHtml(CucaDiagram system, SuggestedFile suggestedFile) throws IOException {
        String name = suggestedFile.getName();
        int idx = name.lastIndexOf(46);
        File dir = new File(suggestedFile.getParentFile(), name.substring(0, idx));
        CucaDiagramHtmlMaker maker = new CucaDiagramHtmlMaker(system, dir);
        return maker.create();
    }
}

