/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sudoku;

import java.util.Random;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.sudoku.DLXEngine;
import net.sourceforge.plantuml.sudoku.ISudoku;

public class SudokuDLX
implements ISudoku {
    private final String[] tab;
    private final long seed;
    private final long rate;

    public SudokuDLX(Long seed) {
        this.seed = seed == null ? Math.abs(new Random().nextLong()) : Math.abs(seed);
        DLXEngine engine = new DLXEngine(new Random(this.seed));
        String s = engine.generate(10000, 100000);
        this.rate = engine.rate(s.replace("\n", "").trim());
        this.tab = s.split("\\s");
    }

    @Override
    public long getRatting() {
        return this.rate;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public int getGiven(int x, int y) {
        char c = this.tab[x].charAt(y);
        if (c == '.') {
            return 0;
        }
        return c - 48;
    }

    public void print() {
        for (String s : this.tab) {
            Log.println(s);
        }
        Log.println("Rate=" + this.rate);
        Log.println("Seed=" + StringUtils.goUpperCase(Long.toString(this.seed, 36)));
    }

    public static void main(String[] args) {
        for (int i = 0; i < 1; ++i) {
            SudokuDLX sudoku = new SudokuDLX(null);
            sudoku.print();
        }
    }
}

