# zone

#### Table of Contents

1. [Description](#description)
2. [Setup - The basics of getting started with zone](#setup)
    * [Setup requirements](#setup-requirements)
3. [Usage - Configuration options and additional functionality](#usage)
4. [Reference - An under-the-hood peek at what the module is doing and how](#reference)
5. [Limitations - OS compatibility, etc.](#limitations)
6. [Development - Guide for contributing to the module](#development)

<a id="description"></a>
## Description

The zone_core module is used to manage Solaris zone resources.

<a id="setup"></a>
## Setup

<a id="setup-requirements"></a>
### Setup Requirements

The zone_core module depends on the zfs_core module, as a zone may be associated in a zfs resource pool.

<a id="usage"></a>
## Usage

To create a zone resource with the name `tstzone` in the `running` state and the root of the zone filesystem in `/tstzones/mnt`, use the following code:

```
zone { 'tstzone' :
  ensure => running,
  path   => '/tstzones/mnt'
}
```

<a id="reference"></a>
## Reference

Please see REFERENCE.md for the reference documentation.

This module is documented using Puppet Strings.

For a quick primer on how Strings works, please see [this blog post](https://puppet.com/blog/using-puppet-strings-generate-great-documentation-puppet-modules) or the [README.md](https://github.com/puppetlabs/puppet-strings/blob/master/README.md) for Puppet Strings.

To generate documentation locally, run the following command:

```
bundle install
bundle exec puppet strings generate ./lib/**/*.rb
```

This command will create a browsable `\_index.html` file in the `doc` directory. The references available here are all generated from YARD-style comments embedded in the code base. When any development happens on this module, the impacted documentation should also be updated.

<a id="limitations"></a>
## Limitations

This module is only available on Solaris platforms.

<a id="development"></a>
## Development

Puppet Labs modules on the Puppet Forge are open projects, and community contributions are essential for keeping them great. We can't access the huge number of platforms and myriad of hardware, software, and deployment configurations that Puppet is intended to serve.

We want to keep it as easy as possible to contribute changes so that our modules work in your environment. There are a few guidelines that we need contributors to follow so that we can have a chance of keeping on top of things.

For more information, see our [module contribution guide.](https://docs.puppetlabs.com/forge/contributing.html)
