/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiBreakStatementImpl
extends CompositePsiElement
implements PsiBreakStatement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiBreakStatementImpl");

    public PsiBreakStatementImpl() {
        super(JavaElementType.BREAK_STATEMENT);
    }

    @Override
    public PsiReferenceExpression getLabelExpression() {
        PsiExpression expression2 = this.getExpression();
        boolean isLabel = PsiImplUtil.isUnqualifiedReference(expression2) && !(PsiImplUtil.findEnclosingSwitchOrLoop(this) instanceof PsiSwitchExpression);
        return isLabel ? (PsiReferenceExpression)expression2 : null;
    }

    @Override
    public PsiExpression getValueExpression() {
        PsiExpression expression2 = this.getExpression();
        boolean isValue = expression2 != null && PsiImplUtil.findEnclosingSwitchOrLoop(this) instanceof PsiSwitchExpression;
        return isValue ? expression2 : null;
    }

    @Override
    public PsiExpression getExpression() {
        return (PsiExpression)this.findPsiChildByType(ElementType.EXPRESSION_BIT_SET);
    }

    @Override
    public PsiElement findExitedElement() {
        PsiElement enclosing = PsiImplUtil.findEnclosingSwitchOrLoop(this);
        PsiExpression expression2 = this.getExpression();
        if (enclosing instanceof PsiSwitchExpression || !PsiImplUtil.isUnqualifiedReference(expression2)) {
            return enclosing;
        }
        PsiLabeledStatement labeled = PsiImplUtil.findEnclosingLabeledStatement(this, expression2.getText());
        if (labeled != null) {
            return labeled.getStatement();
        }
        return null;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 81: {
                return this.findChildByType(JavaTokenType.BREAK_KEYWORD);
            }
            case 83: {
                return this.findChildByType(ElementType.EXPRESSION_BIT_SET);
            }
            case 22: {
                return TreeUtil.findChildBackward(this, JavaTokenType.SEMICOLON);
            }
        }
        return null;
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiBreakStatementImpl.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.BREAK_KEYWORD) {
            return 81;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(i)) {
            return 83;
        }
        if (i == JavaTokenType.SEMICOLON) {
            return 22;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiBreakStatementImpl.$$$reportNull$$$0(1);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitBreakStatement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiBreakStatement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiBreakStatementImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildRole";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

