/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.metadata;

import com.intellij.openapi.Disposable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.K2MetadataCompilerArguments;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.plugins.PluginCliParser;
import org.jetbrains.kotlin.cli.metadata.MetadataSerializer;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/K2MetadataCompiler;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2MetadataCompilerArguments;", "()V", "performanceManager", "Lorg/jetbrains/kotlin/cli/metadata/K2MetadataCompiler$K2MetadataCompilerPerformanceManager;", "getPerformanceManager", "()Lorg/jetbrains/kotlin/cli/metadata/K2MetadataCompiler$K2MetadataCompilerPerformanceManager;", "createArguments", "createMetadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "versionArray", "", "doExecute", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "arguments", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "rootDisposable", "Lcom/intellij/openapi/Disposable;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "executableScriptFileName", "", "setupPlatformSpecificArgumentsAndServices", "", "services", "Lorg/jetbrains/kotlin/config/Services;", "Companion", "K2MetadataCompilerPerformanceManager", "cli"})
public final class K2MetadataCompiler
extends CLICompiler<K2MetadataCompilerArguments> {
    @NotNull
    private final K2MetadataCompilerPerformanceManager performanceManager = new K2MetadataCompilerPerformanceManager();
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected K2MetadataCompilerPerformanceManager getPerformanceManager() {
        return this.performanceManager;
    }

    @Override
    @NotNull
    public K2MetadataCompilerArguments createArguments() {
        return new K2MetadataCompilerArguments();
    }

    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull K2MetadataCompilerArguments arguments2, @NotNull Services services) {
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        Intrinsics.checkParameterIsNotNull(services, "services");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2MetadataCompilerArguments arguments2, @NotNull CompilerConfiguration configuration, @NotNull Disposable rootDisposable, @Nullable KotlinPaths paths) {
        KotlinCoreEnvironment environment;
        String string2;
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(rootDisposable, "rootDisposable");
        MessageCollector collector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        ExitCode pluginLoadResult = PluginCliParser.loadPluginsSafe(arguments2.getPluginClasspaths(), arguments2.getPluginOptions(), configuration);
        if (pluginLoadResult != ExitCode.OK) {
            return pluginLoadResult;
        }
        for (String string3 : arguments2.getFreeArgs()) {
            ContentRootsKt.addKotlinSourceRoot(configuration, string3, true);
        }
        if (arguments2.getClasspath() != null) {
            Collection<File> collection;
            void $this$mapTo$iv$iv;
            String string4 = arguments2.getClasspath();
            if (string4 == null) {
                Intrinsics.throwNpe();
            }
            Iterable iterable = StringsKt.split$default((CharSequence)string4, new char[]{File.pathSeparatorChar}, false, 0, 6, null);
            CompilerConfiguration compilerConfiguration = configuration;
            boolean $i$f$map = false;
            Iterable iterable2 = iterable;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                String string5 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                File file2 = new File((String)p1);
                collection.add(file2);
            }
            collection = (List)destination$iv$iv;
            JvmContentRootsKt.addJvmClasspathRoots(compilerConfiguration, (List<? extends File>)collection);
        }
        if ((string2 = arguments2.getModuleName()) == null) {
            string2 = "main";
        }
        configuration.put(CommonConfigurationKeys.MODULE_NAME, string2);
        configuration.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.getAllowKotlinPackage());
        String string6 = arguments2.getDestination();
        if (string6 != null) {
            if (StringsKt.endsWith$default(string6, ".jar", false, 2, null)) {
                MessageCollector.DefaultImpls.report$default(collector2, CompilerMessageSeverity.STRONG_WARNING, ".jar destination is not yet supported, results will be written to the directory with the given name", null, 4, null);
            }
            configuration.put(CLIConfigurationKeys.METADATA_DESTINATION_DIRECTORY, new File(string6));
        }
        if ((environment = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration, EnvironmentConfigFiles.METADATA_CONFIG_FILES)).getSourceFiles().isEmpty()) {
            if (arguments2.getVersion()) {
                return ExitCode.OK;
            }
            MessageCollector.DefaultImpls.report$default(collector2, CompilerMessageSeverity.ERROR, "No source files", null, 4, null);
            return ExitCode.COMPILATION_ERROR;
        }
        UtilsKt.checkKotlinPackageUsage(environment, (Collection<? extends KtFile>)environment.getSourceFiles());
        try {
            BuiltInsBinaryVersion builtInsBinaryVersion;
            BinaryVersion binaryVersion = configuration.get(CommonConfigurationKeys.METADATA_VERSION);
            if (!(binaryVersion instanceof BuiltInsBinaryVersion)) {
                binaryVersion = null;
            }
            if ((builtInsBinaryVersion = (BuiltInsBinaryVersion)binaryVersion) == null) {
                builtInsBinaryVersion = BuiltInsBinaryVersion.INSTANCE;
            }
            BuiltInsBinaryVersion metadataVersion = builtInsBinaryVersion;
            new MetadataSerializer(metadataVersion, true).serialize(environment);
        }
        catch (CompilationException e) {
            String string7 = OutputMessageUtil.renderException(e);
            Intrinsics.checkExpressionValueIsNotNull(string7, "OutputMessageUtil.renderException(e)");
            collector2.report(CompilerMessageSeverity.EXCEPTION, string7, MessageUtil.psiElementToMessageLocation(e.getElement()));
            return ExitCode.INTERNAL_ERROR;
        }
        return ExitCode.OK;
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        return "kotlinc";
    }

    @Override
    @NotNull
    protected BinaryVersion createMetadataVersion(@NotNull int[] versionArray) {
        Intrinsics.checkParameterIsNotNull(versionArray, "versionArray");
        return new BuiltInsBinaryVersion(Arrays.copyOf(versionArray, versionArray.length));
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/K2MetadataCompiler$K2MetadataCompilerPerformanceManager;", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "()V", "cli"})
    protected static final class K2MetadataCompilerPerformanceManager
    extends CommonCompilerPerformanceManager {
        public K2MetadataCompilerPerformanceManager() {
            super("Kotlin to Metadata compiler");
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/K2MetadataCompiler$Companion;", "", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "cli"})
    public static final class Companion {
        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkParameterIsNotNull(args, "args");
            CLITool.Companion.doMain(new K2MetadataCompiler(), args);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

