/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg.keybox;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.gpg.keybox.Blob;
import org.bouncycastle.gpg.keybox.BlobType;
import org.bouncycastle.gpg.keybox.BlobVerifier;
import org.bouncycastle.gpg.keybox.KeyBlob;
import org.bouncycastle.gpg.keybox.KeyBoxByteBuffer;
import org.bouncycastle.gpg.keybox.KeyInformation;
import org.bouncycastle.gpg.keybox.UserID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateBlob
extends KeyBlob {
    private CertificateBlob(int base, long length, BlobType type, int version, int blobFlags, int keyNumber, List<KeyInformation> keyInformation, byte[] serialNumber, int numberOfUserIDs, List<UserID> userIds, int numberOfSignatures, List<Long> expirationTime, int assignedOwnerTrust, int allValidity, long recheckAfter, long newestTimestamp, long blobCreatedAt, byte[] keyBytes, byte[] reserveBytes, byte[] sha1Checksum) {
        super(base, length, type, version, blobFlags, keyNumber, keyInformation, serialNumber, numberOfUserIDs, userIds, numberOfSignatures, expirationTime, assignedOwnerTrust, allValidity, recheckAfter, newestTimestamp, blobCreatedAt, keyBytes, reserveBytes, sha1Checksum);
    }

    static Blob parseContent(int base, long length, BlobType type, int version, KeyBoxByteBuffer buffer, BlobVerifier blobVerifier) throws IOException {
        CertificateBlob.verifyDigest(base, length, buffer, blobVerifier);
        int blobFlags = buffer.u16();
        long keyBlockOffset = buffer.u32();
        long keyBlockLength = buffer.u32();
        int keyNumber = buffer.u16();
        int keyInformationStructureSize = buffer.u16();
        ArrayList<KeyInformation> keyInformation = new ArrayList<KeyInformation>();
        for (int t = keyNumber - 1; t >= 0; --t) {
            keyInformation.add(KeyInformation.getInstance(buffer, keyInformationStructureSize, base));
        }
        int sizeOfSerialNumber = buffer.u16();
        byte[] serialNumber = new byte[sizeOfSerialNumber];
        buffer.bN(serialNumber);
        int numberOfUserIDs = buffer.u16();
        buffer.u16();
        ArrayList<UserID> userIds = new ArrayList<UserID>();
        for (int t = numberOfUserIDs - 1; t >= 0; --t) {
            userIds.add(UserID.getInstance(buffer, base));
        }
        int numberOfSignatures = buffer.u16();
        buffer.u16();
        ArrayList<Long> signatureExpirationTime = new ArrayList<Long>();
        for (int t = numberOfSignatures - 1; t >= 0; --t) {
            signatureExpirationTime.add(buffer.u32());
        }
        int assignedOwnerTrust = buffer.u8();
        int allValidity = buffer.u8();
        buffer.u16();
        long recheckAfter = buffer.u32();
        long newestTimestamp = buffer.u32();
        long blobCreatedAt = buffer.u32();
        long sizeOfReservedSpace = buffer.u32();
        byte[] reserveData = new byte[(int)sizeOfReservedSpace];
        buffer.bN(reserveData);
        byte[] keyData = buffer.rangeOf((int)((long)base + keyBlockOffset), (int)((long)base + keyBlockOffset + keyBlockLength));
        int dataSize = (int)(length - (long)(buffer.position() - base) - 20L);
        byte[] data = new byte[dataSize];
        buffer.bN(data);
        byte[] sha1Checksum = buffer.rangeOf((int)((long)base + length - 20L), (int)((long)base + length));
        buffer.bN(sha1Checksum);
        return new CertificateBlob(base, length, type, version, blobFlags, keyNumber, keyInformation, serialNumber, numberOfUserIDs, userIds, numberOfSignatures, signatureExpirationTime, assignedOwnerTrust, allValidity, recheckAfter, newestTimestamp, blobCreatedAt, keyData, reserveData, sha1Checksum);
    }

    public byte[] getEncodedCertificate() {
        return this.getKeyBytes();
    }
}

