/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SetTradeRoutesMessage
extends DOMMessage {
    private static final String idPrefix = "shadow-";
    private final List<TradeRoute> tradeRoutes;

    public SetTradeRoutesMessage(List<TradeRoute> tradeRoutes) {
        super(SetTradeRoutesMessage.getXMLElementTagName());
        this.tradeRoutes = tradeRoutes;
    }

    public SetTradeRoutesMessage(Game game, Element element) {
        super(SetTradeRoutesMessage.getXMLElementTagName());
        ArrayList<TradeRoute> newRoutes = new ArrayList<TradeRoute>();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            TradeRoute route = SetTradeRoutesMessage.tradeRouteFromElement(game, (Element)nodes.item(i));
            if (route == null) continue;
            newRoutes.add(route);
        }
        this.tradeRoutes = newRoutes;
    }

    public static TradeRoute tradeRouteFromElement(Game game, Element element) {
        String id = FreeColObject.readId(element);
        element.setAttribute("id", idPrefix + id);
        try {
            return new TradeRoute(game, element);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not build trade route " + id, e);
            return null;
        }
    }

    public static String getPrefix(TradeRoute route) {
        return route.getId().substring(0, idPrefix.length());
    }

    public static String removePrefix(TradeRoute route) {
        return route.getId().substring(idPrefix.length());
    }

    public static boolean hasPrefix(TradeRoute route) {
        return idPrefix.equals(SetTradeRoutesMessage.getPrefix(route));
    }

    public Element handle(FreeColServer server, Connection connection) {
        TradeRoute realRoute;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        ServerGame game = server.getGame();
        String errors = "";
        for (TradeRoute tradeRoute : this.tradeRoutes) {
            if (tradeRoute.getId() == null || !SetTradeRoutesMessage.hasPrefix(tradeRoute)) {
                errors = errors + "Bogus route: " + tradeRoute.getId() + ". ";
                continue;
            }
            String id = SetTradeRoutesMessage.removePrefix(tradeRoute);
            try {
                realRoute = serverPlayer.getOurFreeColGameObject(id, TradeRoute.class);
            }
            catch (Exception e) {
                errors = errors + e.getMessage() + ". ";
            }
        }
        if (errors != null && !errors.isEmpty()) {
            return DOMMessage.clientError(errors);
        }
        ArrayList<TradeRoute> newRoutes = new ArrayList<TradeRoute>();
        for (TradeRoute tradeRoute : this.tradeRoutes) {
            realRoute = game.getFreeColGameObject(SetTradeRoutesMessage.removePrefix(tradeRoute), TradeRoute.class);
            realRoute.updateFrom(tradeRoute);
            newRoutes.add(realRoute);
            tradeRoute.dispose();
        }
        return server.getInGameController().setTradeRoutes(serverPlayer, newRoutes);
    }

    @Override
    public Element toXMLElement() {
        Element result = SetTradeRoutesMessage.createMessage(SetTradeRoutesMessage.getXMLElementTagName(), new String[0]);
        for (TradeRoute tradeRoute : this.tradeRoutes) {
            result.appendChild(tradeRoute.toXMLElement(result.getOwnerDocument()));
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "setTradeRoutes";
    }
}

