/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.io.sza.SimpleZippedAnimation;
import net.sf.freecol.common.resources.Resource;

public class SZAResource
extends Resource
implements Resource.Preloadable {
    private static final Logger logger = Logger.getLogger(SZAResource.class.getName());
    private final HashMap<Float, SimpleZippedAnimation> scaledSzAnimations = new HashMap();
    private volatile SimpleZippedAnimation szAnimation = null;
    private final Object loadingLock = new Object();

    public SZAResource(URI resourceLocator) {
        super(resourceLocator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preload() {
        Object object = this.loadingLock;
        synchronized (object) {
            if (this.szAnimation == null) {
                try {
                    this.szAnimation = new SimpleZippedAnimation(this.getResourceLocator().toURL());
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Could not load SimpleZippedAnimation: " + this.getResourceLocator(), e);
                }
            }
        }
    }

    public SimpleZippedAnimation getSimpleZippedAnimation() {
        if (this.szAnimation == null) {
            logger.finest("Preload not ready for " + this.getResourceLocator());
            this.preload();
        }
        return this.szAnimation;
    }

    public SimpleZippedAnimation getSimpleZippedAnimation(float scale) {
        SimpleZippedAnimation sza = this.getSimpleZippedAnimation();
        if (scale == 1.0f) {
            return sza;
        }
        SimpleZippedAnimation cachedScaledVersion = this.scaledSzAnimations.get(Float.valueOf(scale));
        if (cachedScaledVersion != null) {
            return cachedScaledVersion;
        }
        SimpleZippedAnimation scaledVersion = sza.createScaledVersion(scale);
        this.scaledSzAnimations.put(Float.valueOf(scale), scaledVersion);
        return scaledVersion;
    }
}

