/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.DataPoint;
import tim.prune.data.Track;

public class MidpointData {
    private Track _track = null;
    private double[] _xValues = null;
    private double[] _yValues = null;
    private boolean[] _valids = null;
    private boolean _needRefresh = true;

    public void updateData(Track track) {
        this._track = track;
        this._needRefresh = true;
    }

    private synchronized void updateData() {
        this._needRefresh = false;
        if (this._track == null) {
            return;
        }
        int n = this._track.getNumPoints();
        if (this._xValues == null || this._xValues.length != n) {
            this._xValues = new double[n];
            this._yValues = new double[n];
            this._valids = new boolean[n];
        }
        if (n <= 0) {
            return;
        }
        this._valids[0] = false;
        int n2 = 1;
        while (n2 < n) {
            boolean bl = false;
            DataPoint dataPoint = this._track.getPoint(n2);
            if (dataPoint != null && !dataPoint.getSegmentStart() && !dataPoint.isWaypoint()) {
                this._xValues[n2] = (this._track.getX(n2) + this._track.getX(n2 - 1)) / 2.0;
                this._yValues[n2] = (this._track.getY(n2) + this._track.getY(n2 - 1)) / 2.0;
                bl = true;
            }
            this._valids[n2] = bl;
            ++n2;
        }
    }

    public int getNearestPointIndex(double d, double d2, double d3) {
        if (this._track == null) {
            return -1;
        }
        if (this._needRefresh) {
            this.updateData();
        }
        int n = this._track.getNumPoints();
        int n2 = 0;
        double d4 = -1.0;
        int n3 = 1;
        while (n3 < n) {
            double d5;
            if (this._valids[n3] && ((d5 = Math.abs(this._xValues[n3] - d) + Math.abs(this._yValues[n3] - d2)) < d4 || d4 < 0.0)) {
                n2 = n3;
                d4 = d5;
            }
            ++n3;
        }
        if (d4 > d3 && d3 > 0.0) {
            return -1;
        }
        return n2;
    }
}

