/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.sew;

import java.util.TreeSet;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.function.Cancellable;
import tim.prune.function.sew.SegmentEnd;
import tim.prune.gui.GenericProgressDialog;
import tim.prune.undo.UndoException;
import tim.prune.undo.UndoSewSegments;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SewTrackSegmentsFunction
extends GenericFunction
implements Runnable,
Cancellable {
    private TreeSet<SegmentEnd> _nodes = null;
    private boolean _cancelled = false;

    public SewTrackSegmentsFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.sewsegments";
    }

    @Override
    public void begin() {
        new Thread(this).start();
    }

    @Override
    public void run() {
        int n;
        GenericProgressDialog genericProgressDialog = new GenericProgressDialog(this.getNameKey(), null, this._parentFrame, this);
        genericProgressDialog.show();
        UndoSewSegments undoSewSegments = new UndoSewSegments(this._app.getTrackInfo().getTrack());
        this._nodes = SewTrackSegmentsFunction.buildNodeList(this._app.getTrackInfo().getTrack());
        int n2 = n = this._nodes == null ? 0 : this._nodes.size();
        if (n < 4) {
            System.out.println("Can't do anything with this, not enough segments");
            genericProgressDialog.close();
        } else {
            genericProgressDialog.showProgress(10, 100);
            UpdateMessageBroker.enableMessaging(false);
            SegmentEnd segmentEnd = null;
            SegmentEnd segmentEnd2 = null;
            int n3 = 0;
            int n4 = 0;
            for (SegmentEnd segmentEnd3 : this._nodes) {
                if (!segmentEnd3.isActive()) continue;
                if (segmentEnd == null) {
                    segmentEnd = segmentEnd3;
                } else if (segmentEnd2 == null) {
                    if (segmentEnd3.atSamePointAs(segmentEnd)) {
                        segmentEnd2 = segmentEnd3;
                    } else {
                        segmentEnd = segmentEnd3;
                    }
                } else if (segmentEnd3.atSamePointAs(segmentEnd2)) {
                    segmentEnd2 = null;
                    segmentEnd = null;
                } else {
                    this.joinSegments(segmentEnd, segmentEnd2);
                    ++n3;
                    segmentEnd = segmentEnd3;
                    segmentEnd2 = null;
                }
                if (this._cancelled) break;
                double d = 1.0 * (double)n4 / (double)n;
                genericProgressDialog.showProgress(10 + (int)(d * 80.0), 100);
                ++n4;
            }
            if (segmentEnd != null && segmentEnd2 != null) {
                this.joinSegments(segmentEnd, segmentEnd2);
                ++n3;
            }
            genericProgressDialog.showProgress(90, 100);
            int n5 = this._cancelled ? 0 : SewTrackSegmentsFunction.deleteSegmentStartPoints(this._app.getTrackInfo().getTrack());
            genericProgressDialog.close();
            UpdateMessageBroker.enableMessaging(true);
            if (this._cancelled) {
                try {
                    undoSewSegments.performUndo(this._app.getTrackInfo());
                }
                catch (UndoException undoException) {
                    this._app.showErrorMessage("oops", "CANNOT UNDO");
                }
            } else if (n3 > 0 || n5 > 0) {
                String string = n3 > 0 ? I18nManager.getTextWithNumber("confirm.sewsegments", n3) : n5 + " " + I18nManager.getText("confirm.deletepoint.multi");
                this._app.completeFunction(undoSewSegments, string);
                UpdateMessageBroker.informSubscribers();
            } else {
                this._app.showErrorMessageNoLookup(this.getNameKey(), I18nManager.getTextWithNumber("error.sewsegments.nothingdone", n / 2));
            }
        }
    }

    private static TreeSet<SegmentEnd> buildNodeList(Track track) {
        TreeSet<SegmentEnd> treeSet = new TreeSet<SegmentEnd>();
        int n = track.getNumPoints();
        DataPoint dataPoint = null;
        int n2 = -1;
        SegmentEnd segmentEnd = null;
        int n3 = 0;
        while (n3 < n) {
            DataPoint dataPoint2 = track.getPoint(n3);
            if (!dataPoint2.isWaypoint() && !dataPoint2.hasMedia()) {
                if (dataPoint2.getSegmentStart()) {
                    if (segmentEnd != null && n2 > 0 && n2 != segmentEnd.getPointIndex()) {
                        SegmentEnd segmentEnd2 = new SegmentEnd(dataPoint, n2);
                        segmentEnd.setOtherEnd(segmentEnd2);
                        segmentEnd2.setOtherEnd(segmentEnd);
                        if (!segmentEnd.atSamePointAs(segmentEnd2)) {
                            treeSet.add(segmentEnd);
                            treeSet.add(segmentEnd2);
                        }
                    }
                    segmentEnd = new SegmentEnd(dataPoint2, n3);
                }
                dataPoint = dataPoint2;
                n2 = n3;
            }
            ++n3;
        }
        if (segmentEnd != null && n2 > 0 && n2 != segmentEnd.getPointIndex()) {
            SegmentEnd segmentEnd3 = new SegmentEnd(dataPoint, n2);
            segmentEnd.setOtherEnd(segmentEnd3);
            segmentEnd3.setOtherEnd(segmentEnd);
            if (!segmentEnd.atSamePointAs(segmentEnd3)) {
                treeSet.add(segmentEnd);
                treeSet.add(segmentEnd3);
            }
        }
        return treeSet;
    }

    private void joinSegments(SegmentEnd segmentEnd, SegmentEnd segmentEnd2) {
        Track track = this._app.getTrackInfo().getTrack();
        boolean bl = segmentEnd.isStart();
        if (segmentEnd.isStart() == segmentEnd2.isStart()) {
            if (track.reverseRange(segmentEnd2.getEarlierIndex(), segmentEnd2.getLaterIndex())) {
                segmentEnd2.reverseSegment();
            } else {
                System.err.println("Oops, reverse range didn't work");
            }
        }
        if (bl) {
            if (segmentEnd2.getLaterIndex() + 1 != segmentEnd.getPointIndex()) {
                this.cutAndMoveSegment(segmentEnd2.getEarlierIndex(), segmentEnd2.getLaterIndex(), segmentEnd.getPointIndex());
            }
        } else if (segmentEnd.getLaterIndex() + 1 != segmentEnd2.getPointIndex()) {
            this.cutAndMoveSegment(segmentEnd.getEarlierIndex(), segmentEnd.getLaterIndex(), segmentEnd2.getPointIndex());
        }
        if (segmentEnd2.getEarlierIndex() != segmentEnd.getLaterIndex() + 1 && segmentEnd.getEarlierIndex() != segmentEnd2.getLaterIndex() + 1) {
            System.err.println("Why aren't the segments directly consecutive after the join?");
        }
        SegmentEnd segmentEnd3 = (segmentEnd.getEarlierIndex() < segmentEnd2.getEarlierIndex() ? segmentEnd : segmentEnd2).getEarlierEnd();
        SegmentEnd segmentEnd4 = (segmentEnd.getLaterIndex() > segmentEnd2.getLaterIndex() ? segmentEnd : segmentEnd2).getLaterEnd();
        segmentEnd3.getOtherEnd().deactivate();
        segmentEnd4.getOtherEnd().deactivate();
        segmentEnd3.setOtherEnd(segmentEnd4);
        segmentEnd4.setOtherEnd(segmentEnd3);
    }

    private void cutAndMoveSegment(int n, int n2, int n3) {
        if (!this._app.getTrackInfo().getTrack().cutAndMoveSection(n, n2, n3)) {
            System.err.println("   Oops, cut and move didn't work");
        } else {
            for (SegmentEnd segmentEnd : this._nodes) {
                segmentEnd.adjustPointIndex(n, n2, n3);
            }
        }
    }

    private static int deleteSegmentStartPoints(Track track) {
        int n = track.getNumPoints();
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        DataPoint dataPoint = null;
        int n3 = 0;
        while (n3 < n) {
            DataPoint dataPoint2 = track.getPoint(n3);
            if (!dataPoint2.isWaypoint()) {
                if (dataPoint != null && dataPoint2.getSegmentStart() && dataPoint2.isDuplicate(dataPoint)) {
                    blArray[n3] = true;
                    ++n2;
                }
                dataPoint = dataPoint2;
            }
            ++n3;
        }
        DataPoint[] dataPointArray = new DataPoint[n - n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            if (!blArray[n5]) {
                dataPointArray[n4] = track.getPoint(n5);
                ++n4;
            }
            ++n5;
        }
        track.replaceContents(dataPointArray);
        return n2;
    }

    @Override
    public void cancel() {
        this._cancelled = true;
    }
}

