/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.StringTokenizer;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.DF;
import javajs.util.Lst;
import javajs.util.PT;
import jspecview.common.Annotation;
import jspecview.common.Coordinate;
import jspecview.common.Integral;
import jspecview.common.IntegralComparator;
import jspecview.common.Measurement;
import jspecview.common.MeasurementData;
import jspecview.common.Parameters;
import jspecview.common.ScriptToken;
import jspecview.common.Spectrum;

public class IntegralData
extends MeasurementData {
    private static final long serialVersionUID = 1L;
    public static final double DEFAULT_OFFSET = 30.0;
    public static final double DEFAULT_RANGE = 50.0;
    public static final double DEFAULT_MINY = 0.1;
    private double percentMinY;
    private double percentOffset;
    private double intRange;
    private double normalizationFactor = 1.0;
    private double percentRange;
    private double offset;
    private double integralTotal;
    boolean haveRegions;
    private Coordinate[] xyCoords;
    private static Comparator<Measurement> c = new IntegralComparator();
    private static final String[] HEADER = new String[]{"peak", "start/ppm", "end/ppm", "value"};

    public double getPercentMinimumY() {
        return this.percentMinY;
    }

    public double getPercentOffset() {
        return this.percentOffset;
    }

    public double getIntegralFactor() {
        return this.intRange;
    }

    public IntegralData(double integralMinY, double integralOffset, double integralRange, Spectrum spec) {
        super(Annotation.AType.Integration, spec);
        this.percentMinY = integralMinY;
        this.percentOffset = integralOffset;
        this.percentRange = integralRange;
        this.calculateIntegral();
    }

    public IntegralData(Spectrum spec, Parameters p) {
        super(Annotation.AType.Integration, spec);
        if (p == null) {
            this.autoIntegrate();
            return;
        }
        this.percentOffset = p.integralOffset;
        this.percentRange = p.integralRange;
        this.calculateIntegral();
    }

    public void update(Parameters parameters) {
        this.update(parameters.integralMinY, parameters.integralOffset, parameters.integralRange);
    }

    public void update(double integralMinY, double integralOffset, double integralRange) {
        int i;
        double percentRange0 = this.percentRange;
        if (integralRange <= 0.0 || integralRange == this.percentRange && integralOffset == this.percentOffset) {
            return;
        }
        this.percentOffset = integralOffset;
        this.percentRange = integralRange;
        this.checkRange();
        double intRangeNew = integralRange / 100.0 / this.integralTotal;
        double offsetNew = integralOffset / 100.0;
        for (i = 0; i < this.xyCoords.length; ++i) {
            double y = this.xyCoords[i].getYVal();
            y = (y - this.offset) / this.intRange;
            this.xyCoords[i].setYVal(y * intRangeNew + offsetNew);
        }
        if (this.normalizationFactor != 1.0) {
            this.normalizationFactor *= percentRange0 / integralRange;
        }
        if (this.haveRegions) {
            i = this.size();
            while (--i >= 0) {
                Measurement ir = (Measurement)this.get(i);
                double y1 = this.getYValueAt(ir.getXVal());
                double y2 = this.getYValueAt(ir.getXVal2());
                ir.setYVal(y1);
                ir.setYVal2(y2);
                ir.setValue(Math.abs(y2 - y1) * 100.0 * this.normalizationFactor);
            }
        }
        this.intRange = intRangeNew;
        this.offset = offsetNew;
    }

    double getYValueAt(double x) {
        return Coordinate.getYValueAt(this.xyCoords, x);
    }

    public Integral addIntegralRegion(double x1, double x2) {
        if (Double.isNaN(x1)) {
            this.haveRegions = false;
            this.clear();
            return null;
        }
        if (Double.isNaN(x2)) {
            return this.splitIntegral(x1);
        }
        if (x1 == x2) {
            return null;
        }
        if (x1 < x2) {
            this.clear(x1, x2);
            return null;
        }
        double y1 = this.getYValueAt(x1);
        double y2 = this.getYValueAt(x2);
        this.haveRegions = true;
        Integral in = new Integral().setInt(x1, y1, this.spec, Math.abs(y2 - y1) * 100.0 * this.normalizationFactor, x2, y2);
        this.clear(x1, x2);
        this.addLast(in);
        Collections.sort(this, c);
        return in;
    }

    private Integral splitIntegral(double x) {
        int i = this.find(x);
        if (i < 0) {
            return null;
        }
        Integral integral = (Integral)this.removeItemAt(i);
        double x0 = integral.getXVal();
        double x2 = integral.getXVal2();
        this.addIntegralRegion(x0, x);
        return this.addIntegralRegion(x, x2);
    }

    @Override
    public void setSpecShift(double dx) {
        Coordinate.shiftX(this.xyCoords, dx);
        int i = this.size();
        while (--i >= 1) {
            ((Measurement)this.get(i)).addSpecShift(dx);
        }
    }

    public void addMarks(String ppms) {
        ppms = PT.rep(" " + ppms, ",", " ");
        ppms = PT.rep(ppms, " -", " #");
        ppms = PT.rep(ppms, "--", "-#");
        ppms = ppms.replace('-', '^');
        ppms = ppms.replace('#', '-');
        Lst<String> tokens = ScriptToken.getTokens(ppms);
        for (int i = 0; i < tokens.size(); ++i) {
            try {
                Integral m;
                String s = (String)tokens.get(i);
                double norm = 0.0;
                int pt = s.indexOf(94);
                if (pt < 0) continue;
                int pt2 = s.indexOf(58);
                if (pt2 > pt) {
                    norm = Double.valueOf(s.substring(pt2 + 1).trim());
                    s = s.substring(0, pt2).trim();
                }
                double x2 = Double.valueOf(s.substring(0, pt).trim());
                double x1 = Double.valueOf(s.substring(pt + 1).trim());
                if (x1 == 0.0 && x2 == 0.0) {
                    this.clear();
                }
                if (x1 == x2 || (m = this.addIntegralRegion(Math.max(x1, x2), Math.min(x1, x2))) == null || !(norm > 0.0)) continue;
                this.setSelectedIntegral(m, norm);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public Coordinate[] calculateIntegral() {
        Coordinate[] specXyCoords = this.spec.getXYCoords();
        this.xyCoords = new Coordinate[specXyCoords.length];
        this.integralTotal = 0.0;
        this.checkRange();
        double minY = 1.0E100;
        for (int i = 0; i < specXyCoords.length; ++i) {
            double y = specXyCoords[i].getYVal();
            if (!(y < minY) || !(y >= 0.0)) continue;
            minY = y;
        }
        double minI = 1.0E100;
        double maxI = -1.0E100;
        for (int i = 0; i < specXyCoords.length; ++i) {
            double y = specXyCoords[i].getYVal();
            this.integralTotal += y - minY;
            if (this.integralTotal < minI) {
                minI = this.integralTotal;
            }
            if (!(this.integralTotal > maxI)) continue;
            maxI = this.integralTotal;
        }
        this.integralTotal = maxI - minI;
        this.intRange = this.percentRange / 100.0 / this.integralTotal;
        this.offset = this.percentOffset / 100.0;
        double integral = 0.0;
        int i = specXyCoords.length;
        while (--i >= 0) {
            double y = specXyCoords[i].getYVal();
            this.xyCoords[i] = new Coordinate().set(specXyCoords[i].getXVal(), (integral += y - minY) * this.intRange + this.offset);
        }
        return this.xyCoords;
    }

    private void checkRange() {
        this.percentOffset = Math.max(5.0, this.percentOffset);
        this.percentRange = Math.max(10.0, this.percentRange);
    }

    public static Lst<Annotation> getIntegrationRatiosFromString(Spectrum spec, String key_values) {
        Lst<Annotation> ratios = new Lst<Annotation>();
        StringTokenizer allParamTokens = new StringTokenizer(key_values, ",");
        while (allParamTokens.hasMoreTokens()) {
            String token = allParamTokens.nextToken();
            StringTokenizer eachParam = new StringTokenizer(token, ":");
            Annotation ratio = new Annotation().setA(Double.parseDouble(eachParam.nextToken()), 0.0, spec, eachParam.nextToken(), true, false, 0, 0);
            ratios.addLast(ratio);
        }
        return ratios;
    }

    public Coordinate[] getXYCoords() {
        return this.xyCoords;
    }

    public double getPercentYValueAt(double x) {
        return this.getYValueAt(x) * 100.0;
    }

    public void dispose() {
        this.spec = null;
        this.xyCoords = null;
    }

    public void setSelectedIntegral(Measurement integral, double val) {
        double val0 = integral.getValue();
        double factor = val <= 0.0 ? 1.0 / this.normalizationFactor : val / val0;
        this.factorAllIntegrals(factor, val <= 0.0);
    }

    private void factorAllIntegrals(double factor, boolean isReset) {
        for (int i = 0; i < this.size(); ++i) {
            Measurement m = (Measurement)this.get(i);
            m.setValue(factor * m.getValue());
        }
        this.normalizationFactor = isReset ? 1.0 : this.normalizationFactor * factor;
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public Measurement remove(int i) {
        return (Measurement)this.removeItemAt(i);
    }

    public BS getBitSet() {
        BS bs = BS.newN(this.xyCoords.length);
        if (this.size() == 0) {
            bs.setBits(0, this.xyCoords.length);
            return bs;
        }
        int i = this.size();
        while (--i >= 0) {
            Measurement m = (Measurement)this.get(i);
            int x1 = Coordinate.getNearestIndexForX(this.xyCoords, m.getXVal());
            int x2 = Coordinate.getNearestIndexForX(this.xyCoords, m.getXVal2());
            bs.setBits(Math.min(x1, x2), Math.max(x1, x2));
        }
        return bs;
    }

    @Override
    public String[][] getMeasurementListArray(String units) {
        String[][] data = new String[this.size()][];
        int pt = 0;
        int i = this.size();
        while (--i >= 0) {
            data[pt++] = new String[]{"" + pt, DF.formatDecimalDbl(((Measurement)this.get(i)).getXVal(), 2), DF.formatDecimalDbl(((Measurement)this.get(i)).getXVal2(), 2), ((Measurement)this.get((int)i)).text};
        }
        return data;
    }

    @Override
    public double[][] getMeasurementListArrayReal(String units) {
        double[][] data = AU.newDouble2(this.size());
        int pt = 0;
        int i = this.size();
        while (--i >= 0) {
            data[pt] = new double[]{((Measurement)this.get(i)).getXVal(), ((Measurement)this.get(i)).getXVal2(), ((Measurement)this.get(i)).getValue()};
            ++pt;
        }
        return data;
    }

    @Override
    public String[] getDataHeader() {
        return HEADER;
    }

    public void shiftY(int yOld, int yNew, int yPixel0, int yPixels) {
        double pt = (int)(100.0 * (double)(yPixel0 + yPixels - yNew) / (double)yPixels);
        if (yOld < 0) {
            pt -= this.percentOffset;
        }
        if (yOld < 0) {
            this.update(0.0, this.percentOffset, pt);
        } else {
            this.update(0.0, pt, this.percentRange);
        }
    }

    public void autoIntegrate() {
        if (this.xyCoords == null) {
            this.calculateIntegral();
        }
        if (this.xyCoords.length == 0) {
            return;
        }
        this.clear();
        int iStart = -1;
        double cutoff = 1.0E-4;
        int nCount = 0;
        int nMin = 20;
        double y0 = this.xyCoords[this.xyCoords.length - 1].getYVal();
        int i = this.xyCoords.length - 1;
        while (--i >= 0) {
            double y = this.xyCoords[i].getYVal();
            ++nCount;
            if (y - y0 < cutoff && iStart < 0) {
                if (!(y < y0)) continue;
                y0 = y;
                nCount = 0;
                continue;
            }
            if (iStart < 0) {
                iStart = i + Math.min(nCount, nMin);
                y0 = y;
                nCount = 0;
                continue;
            }
            if (y - y0 < cutoff) {
                if (nCount == 1) {
                    y0 = y;
                }
                if (nCount < nMin) continue;
                this.addIntegralRegion(this.xyCoords[iStart].getXVal(), this.xyCoords[i].getXVal());
                iStart = -1;
                y0 = y;
                nCount = 0;
                continue;
            }
            nCount = 0;
            y0 = y;
        }
        if (this.spec.nH > 0) {
            this.factorAllIntegrals((double)this.spec.nH / this.percentRange, false);
        }
    }

    @Override
    public void getInfo(Map<String, Object> info) {
        info.put("offset", this.myParams.integralOffset);
        info.put("range", this.myParams.integralRange);
        info.put("normalizationFactor", this.normalizationFactor);
        info.put("integralTotal", this.integralTotal);
        super.getInfo(info);
    }

    public void setMinimumIntegral(double val) {
        int i = this.size();
        while (--i >= 0) {
            if (!(((Measurement)this.get(i)).getValue() < val)) continue;
            this.removeItemAt(i);
        }
    }

    public static enum IntMode {
        OFF,
        ON,
        TOGGLE,
        AUTO,
        LIST,
        MARK,
        MIN,
        UPDATE,
        CLEAR,
        NA;


        static IntMode getMode(String value) {
            for (IntMode mode : IntMode.values()) {
                if (!value.startsWith(mode.name())) continue;
                return mode;
            }
            return NA;
        }
    }
}

