/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.A4;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.V3;
import org.jmol.atomdata.RadiusData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.util.ColorEncoder;
import org.jmol.util.ContactPair;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class Parameters {
    public static final int STATE_UNINITIALIZED = 0;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_DATA_READ = 2;
    public static final int STATE_DATA_COLORED = 3;
    public int state = 0;
    public int testFlags = 0;
    boolean logMessages = false;
    boolean logCompression = false;
    boolean logCube = false;
    public boolean isSilent = false;
    float assocCutoff = 0.3f;
    static final int NO_ANISOTROPY = 32;
    static final int IS_SILENT = 64;
    public static final int IS_SOLVENTTYPE = 128;
    static final int HAS_MAXGRID = 256;
    static final int IS_POINTMAPPABLE = 512;
    static final int IS_SLABBABLE = 1024;
    public int dataType;
    int surfaceType;
    static final int SURFACE_NONE = 0;
    static final int SURFACE_SPHERE = 65;
    static final int SURFACE_ELLIPSOID2 = 66;
    static final int SURFACE_ELLIPSOID3 = 67;
    static final int SURFACE_LOBE = 68;
    static final int SURFACE_LCAOCARTOON = 69;
    public static final int SURFACE_LONEPAIR = 70;
    public static final int SURFACE_RADICAL = 71;
    static final int SURFACE_FUNCTIONXY = 8;
    static final int SURFACE_FUNCTIONXYZ = 9;
    static final int SURFACE_GEODESIC = 74;
    static final int SURFACE_SOLVENT = 1195;
    static final int SURFACE_SASURFACE = 1196;
    static final int SURFACE_MOLECULARORBITAL = 1837;
    static final int SURFACE_ATOMICORBITAL = 1294;
    static final int SURFACE_MEP = 1328;
    static final int SURFACE_MLP = 1329;
    static final int SURFACE_MOLECULAR = 1203;
    static final int SURFACE_NCI = 1844;
    static final int SURFACE_INTERSECT_ATOM = 1333;
    static final int SURFACE_INTERSECT_FILE = 1334;
    static final int SURFACE_NOMAP = 1207;
    static final int SURFACE_PROPERTY = 1208;
    String calculationType = "";
    public RadiusData atomRadiusData;
    boolean addHydrogens;
    float solventRadius;
    float solventExtendedAtomRadius;
    boolean propertySmoothing;
    int propertySmoothingPower = 4;
    float envelopeRadius;
    float cavityRadius;
    boolean isCavity;
    Boolean pocket;
    int minSet;
    public Lst<Object[]> slabInfo;
    float slabPlaneOffset = Float.NaN;
    float[] theProperty;
    float solvent_ptsPerAngstrom = 4.0f;
    int solvent_gridMax = 60;
    float plane_ptsPerAngstrom = 4.0f;
    int plane_gridMax = 81;
    static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    static final int defaultEdgeFractionBase = 35;
    static final int defaultEdgeFractionRange = 90;
    static final int defaultColorFractionBase = 35;
    static final int defaultColorFractionRange = 90;
    static final float defaultMappedDataMin = 0.0f;
    static final float defaultMappedDataMax = 1.0f;
    static final float defaultCutoff = 0.02f;
    static final float defaultOrbitalCutoff = 0.04f;
    static final float defaultLobeCutoff = 0.14f;
    static final float defaultOrbitalCutoffOld = 0.14f;
    public static final float defaultQMOrbitalCutoff = 0.05f;
    static final float defaultQMElectronDensityCutoff = 0.01f;
    static final int defaultContourCount = 11;
    static final int nContourMax = 100;
    static final int defaultColorNegative = -65536;
    static final int defaultColorPositive = -16776961;
    static final int defaultColorNegativeLCAO = -8388480;
    static final int defaultColorPositiveLCAO = -23296;
    static final float defaultSolventRadius = 1.2f;
    static final float defaultMepCutoff = 0.1f;
    static final float defaultMepMin = -0.1f;
    static final float defaultMepMax = 0.1f;
    boolean colorBySign;
    boolean colorByPhase;
    boolean colorBySets;
    public int colorRgb;
    public int colorNeg;
    public int colorPos;
    int colorPosLCAO;
    int colorNegLCAO;
    int colorPhase;
    public boolean colorDensity;
    public boolean iAddGridPoints;
    int atomIndex;
    boolean isAngstroms;
    float scale;
    public float scale3d;
    float[] anisotropy = new float[3];
    boolean isAnisotropic;
    M3 eccentricityMatrix;
    M3 eccentricityMatrixInverse;
    boolean isEccentric;
    float eccentricityScale;
    float eccentricityRatio;
    float[] aniosU;
    float[] anisoB;
    String lcaoType;
    public Lst<Object> functionInfo;
    int psi_n = 2;
    int psi_l = 1;
    int psi_m = 1;
    float psi_Znuc = 1.0f;
    float psi_ptsPerAngstrom = 5.0f;
    public int psi_monteCarloCount = 0;
    public static final int MEP_MAX_GRID = 40;
    int mep_gridMax = 40;
    float mep_ptsPerAngstrom = 3.0f;
    float mep_marginAngstroms = 1.0f;
    public int mep_calcType = -1;
    int qmOrbitalType;
    int qmOrbitalCount;
    static final int QM_TYPE_UNKNOWN = 0;
    static final int QM_TYPE_GAUSSIAN = 1;
    static final int QM_TYPE_SLATER = 2;
    static final int QM_TYPE_NCI_PRO = 3;
    static final int QM_TYPE_NCI_SCF = 4;
    static final int QM_TYPE_VOLUME_DATA = 5;
    public Map<String, Object> moData;
    public static final int MO_MAX_GRID = 80;
    int qm_gridMax = 80;
    float qm_ptsPerAngstrom = 10.0f;
    float qm_marginAngstroms = 1.0f;
    int qm_nAtoms;
    int qm_moNumber = Integer.MAX_VALUE;
    float[] qm_moLinearCombination = null;
    P3 center;
    P3 point;
    float distance;
    public boolean allowVolumeRender;
    public String script;
    public BS bsSelected;
    public BS bsIgnore;
    public BS bsSolvent;
    public Object func;
    public String[] title;
    boolean blockCubeData;
    boolean readAllData;
    int fileIndex = -1;
    public String fileName;
    public int modelIndex = -1;
    public M4 modelInvRotation = null;
    public boolean isXLowToHigh;
    boolean insideOut;
    boolean dataXYReversed;
    public float cutoff = Float.MAX_VALUE;
    public float sigma = Float.MAX_VALUE;
    boolean cutoffAutomatic = true;
    public boolean isCutoffAbsolute;
    public boolean isPositiveOnly;
    boolean rangeAll;
    boolean rangeSelected;
    public boolean rangeDefined;
    float valueMappedToRed;
    float valueMappedToBlue;
    float mappedDataMin;
    float mappedDataMax;
    boolean isColorReversed;
    public boolean isBicolorMap;
    public boolean isSquared;
    public boolean isSquaredLinear;
    public P4 thePlane;
    public boolean isContoured;
    int nContours;
    int thisContour;
    boolean contourFromZero;
    float[] parameters;
    public float resolution;
    int downsampleFactor;
    int maxSet;
    public float[] contoursDiscrete;
    public short[] contourColixes;
    P3 contourIncrements;
    public P3[] boundingBox;
    public BS[] bsExcluded;
    public int contourType;
    public boolean colorSchemeTranslucent;
    public ColorEncoder colorEncoder;
    public boolean usePropertyForColorRange = true;
    public boolean isPeriodic;
    public boolean doFullMolecular;
    public float propertyDistanceMax = 2.1474836E9f;
    public int randomSeed;
    public boolean fullyLit;
    public int[] vertexSource;
    public BS[] intersection;
    public P3 origin;
    public P3 steps;
    public P3 points;
    public VolumeData volumeData;
    public ContactPair contactPair;
    public P3 mapLattice;
    public float extendGrid;
    public boolean isMapped;
    public boolean showTiming;
    public float pointSize;
    public boolean isModelConnected;
    public BS surfaceAtoms;
    public Object[] filesData;

    void initialize() {
        this.addHydrogens = false;
        this.allowVolumeRender = true;
        this.atomRadiusData = null;
        this.atomIndex = -1;
        this.blockCubeData = false;
        this.boundingBox = null;
        this.bsExcluded = new BS[4];
        this.bsIgnore = null;
        this.bsSelected = null;
        this.bsSolvent = null;
        this.calculationType = "";
        this.center = new P3();
        this.resetForMapping(true);
        this.colorBySets = false;
        this.colorByPhase = false;
        this.colorBySign = false;
        this.colorEncoder = null;
        this.colorNeg = -65536;
        this.colorNegLCAO = -8388480;
        this.colorPos = -16776961;
        this.colorPosLCAO = -23296;
        this.colorRgb = Integer.MIN_VALUE;
        this.colorSchemeTranslucent = false;
        this.contactPair = null;
        this.contourIncrements = null;
        this.contoursDiscrete = null;
        this.contourColixes = null;
        this.contourFromZero = true;
        this.cutoff = Float.MAX_VALUE;
        this.cutoffAutomatic = true;
        this.dataXYReversed = false;
        this.distance = Float.MAX_VALUE;
        this.doFullMolecular = false;
        this.envelopeRadius = 10.0f;
        this.extendGrid = 0.0f;
        this.fileIndex = 1;
        this.readAllData = true;
        this.fileName = "";
        this.filesData = null;
        this.fullyLit = false;
        this.functionInfo = null;
        this.iAddGridPoints = false;
        this.insideOut = false;
        this.isAngstroms = false;
        this.isPositiveOnly = false;
        this.isCutoffAbsolute = false;
        this.isBicolorMap = false;
        this.isCavity = false;
        this.isColorReversed = false;
        this.isModelConnected = false;
        this.isSquared = false;
        this.isSquaredLinear = false;
        this.isContoured = false;
        this.isEccentric = false;
        this.isMapped = false;
        this.isPeriodic = false;
        this.isSilent = false;
        this.logCompression = false;
        this.logCube = false;
        this.logMessages = Logger.debugging;
        this.mapLattice = null;
        this.mep_calcType = -1;
        this.minSet = 0;
        this.modelIndex = -1;
        this.modelInvRotation = null;
        this.nContours = 0;
        this.pocket = null;
        this.pointSize = Float.NaN;
        this.propertyDistanceMax = 2.1474836E9f;
        this.propertySmoothing = false;
        this.propertySmoothingPower = 4;
        this.rangeDefined = false;
        this.rangeAll = false;
        this.rangeSelected = false;
        this.resolution = Float.MAX_VALUE;
        this.scale = Float.NaN;
        this.scale3d = 0.0f;
        this.sigma = Float.NaN;
        this.slabInfo = null;
        this.solventExtendedAtomRadius = 0.0f;
        this.state = 1;
        this.testFlags = 0;
        this.thePlane = null;
        this.theProperty = null;
        this.thisContour = -1;
        this.title = null;
        this.usePropertyForColorRange = true;
        this.vertexSource = null;
    }

    public void resetForMapping(boolean haveSurface) {
        if (!haveSurface) {
            this.state = 2;
        }
        this.center.x = Float.NaN;
        this.colorDensity = false;
        this.func = null;
        this.intersection = null;
        this.isAnisotropic = false;
        this.isMapped = true;
        this.mappedDataMin = Float.MAX_VALUE;
        this.origin = null;
        this.parameters = null;
        this.points = null;
        this.qmOrbitalType = 0;
        this.steps = null;
        this.volumeData = null;
    }

    void setAnisotropy(P3 pt) {
        this.anisotropy[0] = pt.x;
        this.anisotropy[1] = pt.y;
        this.anisotropy[2] = pt.z;
        this.isAnisotropic = true;
        if (Float.isNaN(this.center.x)) {
            this.center.set(0.0f, 0.0f, 0.0f);
        }
    }

    void setEccentricity(P4 info) {
        V3 ecc = V3.new3(info.x, info.y, info.z);
        float c = this.scale > 0.0f ? this.scale : (info.w < 0.0f ? 1.0f : ecc.length());
        float fab_c = Math.abs(info.w);
        ecc.normalize();
        V3 z = V3.new3(0.0f, 0.0f, 1.0f);
        ecc.add(z);
        ecc.normalize();
        if (Float.isNaN(ecc.x)) {
            ecc.set(1.0f, 0.0f, 0.0f);
        }
        this.eccentricityMatrixInverse = new M3();
        this.eccentricityMatrix = new M3().setAA(A4.newVA(ecc, (float)Math.PI));
        this.eccentricityMatrixInverse.invertM(this.eccentricityMatrix);
        this.isAnisotropic = true;
        this.isEccentric = true;
        this.eccentricityScale = c;
        this.eccentricityRatio = fab_c;
        if (fab_c > 1.0f) {
            this.eccentricityScale *= fab_c;
        }
        this.anisotropy[0] = fab_c * c;
        this.anisotropy[1] = fab_c * c;
        this.anisotropy[2] = c;
        if (Float.isNaN(this.center.x)) {
            this.center.set(0.0f, 0.0f, 0.0f);
        }
    }

    void setPlane(P4 plane) {
        this.thePlane = plane;
        if (this.thePlane.x == 0.0f && this.thePlane.y == 0.0f && this.thePlane.z == 0.0f) {
            this.thePlane.z = 1.0f;
        }
        this.isContoured = true;
    }

    void setSphere(float radius, boolean isGeodesic) {
        this.dataType = isGeodesic ? 74 : 65;
        this.distance = radius;
        this.setEccentricity(P4.new4(0.0f, 0.0f, 1.0f, 1.0f));
        this.cutoff = Float.MIN_VALUE;
        this.isCutoffAbsolute = false;
        this.isSilent = !this.logMessages;
        this.script = this.getScriptParams() + " SPHERE " + radius + ";";
    }

    void setEllipsoidP4(P4 v) {
        this.dataType = 66;
        this.distance = 1.0f;
        this.setEccentricity(v);
        this.cutoff = Float.MIN_VALUE;
        this.isCutoffAbsolute = false;
        this.isSilent = !this.logMessages;
    }

    public void setEllipsoidAF(float[] bList) {
        this.anisoB = bList;
        this.dataType = 67;
        this.distance = 0.3f * (Float.isNaN(this.scale) ? 1.0f : this.scale);
        this.cutoff = Float.MIN_VALUE;
        this.isCutoffAbsolute = false;
        boolean bl = this.isSilent = !this.logMessages;
        if (Float.isNaN(this.center.x)) {
            this.center.set(0.0f, 0.0f, 0.0f);
        }
        if (this.resolution == Float.MAX_VALUE) {
            this.resolution = 6.0f;
        }
    }

    void setLobe(P4 v) {
        this.dataType = 68;
        this.setEccentricity(v);
        if (this.cutoff == Float.MAX_VALUE) {
            this.cutoff = 0.14f;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isSilent = !this.logMessages;
        this.script = this.getScriptParams() + " LOBE {" + v.x + " " + v.y + " " + v.z + " " + v.w + "};";
    }

    private String getScriptParams() {
        return " center " + Escape.eP(this.center) + (Float.isNaN(this.scale) ? "" : " scale " + this.scale);
    }

    void setLp(P4 v) {
        this.dataType = 70;
        this.setEccentricity(v);
        if (this.cutoff == Float.MAX_VALUE) {
            this.cutoff = 0.14f;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isSilent = !this.logMessages;
        this.script = " center " + Escape.eP(this.center) + (Float.isNaN(this.scale) ? "" : " scale " + this.scale) + " LP {" + v.x + " " + v.y + " " + v.z + " " + v.w + "};";
    }

    void setRadical(P4 v) {
        this.dataType = 71;
        this.setEccentricity(v);
        if (this.cutoff == Float.MAX_VALUE) {
            this.cutoff = 0.14f;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isSilent = !this.logMessages;
        this.script = " center " + Escape.eP(this.center) + (Float.isNaN(this.scale) ? "" : " scale " + this.scale) + " RAD {" + v.x + " " + v.y + " " + v.z + " " + v.w + "};";
    }

    void setLcao(String type, int colorPtr) {
        this.lcaoType = type;
        if (colorPtr == 1) {
            this.colorPosLCAO = this.colorNegLCAO;
        }
        this.isSilent = !this.logMessages;
    }

    void setSolvent(String propertyName, float radius) {
        this.isAnisotropic = false;
        this.isEccentric = false;
        this.solventRadius = Math.abs(radius);
        int n = this.intersection != null ? 1333 : ("nomap" == propertyName ? 1207 : ("molecular" == propertyName ? 1203 : (this.dataType = "sasurface" == propertyName || this.solventRadius == 0.0f ? 1196 : 1195)));
        if (!(this.state >= 2 || !this.cutoffAutomatic && this.colorDensity || this.intersection != null && this.cutoff != Float.MAX_VALUE)) {
            this.cutoff = 0.0f;
        }
        switch (this.dataType) {
            case 1333: {
                this.calculationType = "VDW intersection";
                break;
            }
            case 1207: {
                this.calculationType = "unmapped plane";
                break;
            }
            case 1203: {
                this.calculationType = "molecular surface with radius " + this.solventRadius;
                break;
            }
            case 1195: {
                this.calculationType = "solvent-excluded surface with radius " + this.solventRadius;
                break;
            }
            case 1196: {
                this.calculationType = "solvent-accessible surface with radius " + this.solventRadius;
            }
        }
        switch (this.dataType) {
            case 1207: {
                this.solventExtendedAtomRadius = this.solventRadius;
                this.solventRadius = 0.0f;
                this.isContoured = false;
                break;
            }
            case 1203: {
                this.solventExtendedAtomRadius = 0.0f;
                break;
            }
            case 1195: {
                this.solventExtendedAtomRadius = 0.0f;
                if (this.bsIgnore == null) {
                    this.bsIgnore = this.bsSolvent;
                    break;
                }
                if (this.bsSolvent == null) break;
                this.bsIgnore.or(this.bsSolvent);
                break;
            }
            case 1196: {
                this.solventExtendedAtomRadius = this.solventRadius;
                this.solventRadius = 0.0f;
                if (this.bsIgnore == null) {
                    this.bsIgnore = this.bsSolvent;
                    break;
                }
                if (this.bsSolvent == null) break;
                this.bsIgnore.or(this.bsSolvent);
            }
        }
    }

    void setFunctionXY(Lst<Object> value) {
        this.dataType = 8;
        this.functionInfo = value;
        this.cutoff = Float.MIN_VALUE;
        this.isAnisotropic = false;
        this.isEccentric = false;
    }

    void setFunctionXYZ(Lst<Object> value) {
        this.dataType = 9;
        this.functionInfo = value;
        if (this.cutoff == Float.MAX_VALUE) {
            this.cutoff = Float.MIN_VALUE;
        }
        this.isAnisotropic = false;
        this.isEccentric = false;
    }

    boolean setAtomicOrbital(float[] nlmZprs) {
        this.dataType = 1294;
        this.setEccentricity(P4.new4(0.0f, 0.0f, 1.0f, 1.0f));
        this.psi_n = (int)nlmZprs[0];
        this.psi_l = (int)nlmZprs[1];
        this.psi_m = (int)nlmZprs[2];
        this.psi_Znuc = nlmZprs[3];
        this.psi_monteCarloCount = (int)nlmZprs[4];
        this.distance = nlmZprs[5];
        if (this.distance != 0.0f || this.thePlane != null) {
            this.allowVolumeRender = false;
        }
        this.randomSeed = (int)nlmZprs[6];
        this.psi_ptsPerAngstrom = 10.0f;
        if (this.cutoff == Float.MAX_VALUE || this.cutoff == 0.14f) {
            float f = this.cutoff = this.psi_monteCarloCount > 0 ? 0.0f : 0.04f;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isCutoffAbsolute = true;
        if (this.state < 2 && this.thePlane == null && this.colorBySign) {
            this.isBicolorMap = true;
        }
        return this.psi_Znuc > 0.0f && Math.abs(this.psi_m) <= this.psi_l && this.psi_l < this.psi_n;
    }

    void setMep(float[] charges, boolean isMLP) {
        this.dataType = isMLP ? 1329 : 1328;
        this.theProperty = charges;
        this.usePropertyForColorRange = false;
        this.isAnisotropic = false;
        this.isEccentric = false;
        if (this.cutoff == Float.MAX_VALUE) {
            this.cutoff = 0.1f;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isCutoffAbsolute = this.cutoff > 0.0f && !this.isPositiveOnly;
        this.contourFromZero = false;
        if (this.state >= 2 || this.thePlane != null) {
            if (!this.rangeDefined && !this.rangeAll) {
                this.valueMappedToRed = -0.1f;
                this.valueMappedToBlue = 0.1f;
                this.rangeDefined = true;
            }
        } else {
            this.colorBySign = true;
            this.isBicolorMap = true;
        }
    }

    void setNci(boolean isPromolecular) {
        this.fullyLit = true;
        this.qm_gridMax = 200;
        if (isPromolecular) {
            this.dataType = 1844;
        }
        this.qm_marginAngstroms = 2.0f;
        int n = this.qmOrbitalType = isPromolecular ? 3 : 4;
        if (isPromolecular && (this.parameters == null || this.parameters.length < 2)) {
            this.parameters = new float[]{this.cutoff, 2.0f};
        }
        if (this.cutoff == Float.MAX_VALUE || this.cutoff == 0.0f) {
            this.cutoff = 0.3f;
        }
        if (this.isSquared) {
            this.cutoff *= this.cutoff;
        }
        if (this.title == null) {
            this.title = new String[0];
        }
        this.moData = new Hashtable<String, Object>();
    }

    void setMO(int iMo, float[] linearCombination) {
        boolean isElectronDensity;
        this.isModelConnected = true;
        this.qm_moLinearCombination = linearCombination;
        int n = this.qm_moNumber = linearCombination == null ? Math.abs(iMo) : (int)linearCombination[1];
        this.qmOrbitalType = this.moData.containsKey("haveVolumeData") ? 5 : (this.moData.containsKey("gaussians") ? 1 : (this.moData.containsKey("slaters") ? 2 : 0));
        boolean bl = isElectronDensity = iMo <= 0 && linearCombination == null;
        if (this.qmOrbitalType == 0) {
            Logger.error("MO ERROR: No basis functions found in file for MO calculation. (GAUSSIAN 'gfprint' keyword may be missing?)");
            this.title = new String[]{"no basis functions found in file"};
        } else {
            Lst mos = (Lst)this.moData.get("mos");
            this.qmOrbitalCount = mos.size();
            this.calculationType = (String)this.moData.get("calculationType");
            this.calculationType = "Molecular orbital #" + this.qm_moNumber + "/" + this.qmOrbitalCount + " " + (this.calculationType == null ? "" : this.calculationType);
            if (!isElectronDensity && this.title == null) {
                this.title = new String[5];
                this.title[0] = "%F";
                this.title[1] = "Model %M  MO %I/%N %T";
                this.title[2] = "?Energy = %E %U";
                this.title[3] = "?Symmetry = %S";
                this.title[4] = "?Occupancy = %O";
            }
        }
        this.dataType = 1837;
        if (this.cutoff == Float.MAX_VALUE) {
            float f = this.cutoff = isElectronDensity ? 0.01f : 0.05f;
        }
        if (this.isSquared || this.isSquaredLinear) {
            this.cutoff *= this.cutoff;
        }
        this.isAnisotropic = false;
        this.isEccentric = false;
        boolean bl2 = this.isCutoffAbsolute = this.cutoff > 0.0f && !this.isPositiveOnly;
        if (this.state >= 2 || this.thePlane != null) {
            return;
        }
        this.colorBySign = true;
        if (this.colorByPhase && this.colorPhase == 0) {
            this.colorByPhase = false;
        }
        this.isBicolorMap = true;
    }

    void setMapRanges(SurfaceReader surfaceReader, boolean haveData) {
        if (!this.colorDensity && (this.colorByPhase || this.colorBySign || (this.thePlane != null || this.isBicolorMap) && !this.isContoured)) {
            this.mappedDataMin = -1.0f;
            this.mappedDataMax = 1.0f;
        }
        if (this.mappedDataMin == Float.MAX_VALUE || this.mappedDataMin == this.mappedDataMax) {
            float[] minMax = surfaceReader.getMinMaxMappedValues(haveData);
            System.out.println("parameters - setmapranges " + minMax[0] + " " + minMax[1]);
            this.mappedDataMin = minMax[0];
            this.mappedDataMax = minMax[1];
        }
        if (this.mappedDataMin == 0.0f && this.mappedDataMax == 0.0f) {
            this.mappedDataMin = -1.0f;
            this.mappedDataMax = 1.0f;
        }
        if (!this.rangeDefined) {
            this.valueMappedToRed = this.mappedDataMin;
            this.valueMappedToBlue = this.mappedDataMax;
        }
    }

    public void addSlabInfo(Object[] slabObject) {
        if (this.slabInfo == null) {
            this.slabInfo = new Lst();
        }
        this.slabInfo.addLast(slabObject);
    }

    public boolean isInsideOut() {
        return this.insideOut != this.dataXYReversed;
    }

    public boolean isFullyLit() {
        return this.thePlane != null || this.fullyLit;
    }
}

