/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.diagnostic.ParallelActivity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.pico.DefaultPicoContainer;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public final class ServiceManager {
    private static final Logger LOG = Logger.getInstance(ServiceManager.class);
    private static final ConcurrentMap<Class<?>, Object> ourAppServices = ContainerUtil.newConcurrentMap();

    private ServiceManager() {
    }

    public static <T> T getService(@NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            ServiceManager.$$$reportNull$$$0(0);
        }
        if (ServiceManager.isLightService(serviceClass)) {
            return ServiceManager.getOrCreateLightService(serviceClass);
        }
        return ServiceManager.doGetService(ApplicationManager.getApplication(), serviceClass, true);
    }

    public static <T> T getService(@NotNull Project project, @NotNull Class<T> serviceClass) {
        if (project == null) {
            ServiceManager.$$$reportNull$$$0(1);
        }
        if (serviceClass == null) {
            ServiceManager.$$$reportNull$$$0(2);
        }
        return ServiceManager.doGetService(project, serviceClass, true);
    }

    @Nullable
    private static <T> T doGetService(@NotNull ComponentManager componentManager, @NotNull Class<T> serviceClass, boolean isCreate) {
        if (componentManager == null) {
            ServiceManager.$$$reportNull$$$0(6);
        }
        if (serviceClass == null) {
            ServiceManager.$$$reportNull$$$0(7);
        }
        String componentKey = serviceClass.getName();
        PicoContainer picoContainer = componentManager.getPicoContainer();
        if (!isCreate && picoContainer instanceof DefaultPicoContainer) {
            return ((DefaultPicoContainer)picoContainer).getComponentInstanceIfInstantiated(componentKey);
        }
        Object instance = picoContainer.getComponentInstance(componentKey);
        if (instance == null) {
            ProgressManager.checkCanceled();
            instance = ServiceManager.assertServiceNotRegisteredAsComponent(componentManager, serviceClass, componentKey);
        }
        return (T)instance;
    }

    private static <T> T assertServiceNotRegisteredAsComponent(@NotNull ComponentManager componentManager, @NotNull Class<T> serviceClass, @NotNull String componentKey) {
        T instance;
        if (componentManager == null) {
            ServiceManager.$$$reportNull$$$0(8);
        }
        if (serviceClass == null) {
            ServiceManager.$$$reportNull$$$0(9);
        }
        if (componentKey == null) {
            ServiceManager.$$$reportNull$$$0(10);
        }
        if ((instance = componentManager.getComponent(serviceClass)) != null) {
            Application app = ApplicationManager.getApplication();
            String message2 = componentKey + " requested as a service, but it is a component - convert it to a service or change call to " + (componentManager == app ? "ApplicationManager.getApplication().getComponent()" : "project.getComponent()");
            if (app.isUnitTestMode()) {
                LOG.error(message2);
            } else {
                LOG.warn(message2);
            }
        }
        return instance;
    }

    @NotNull
    public static <T> NotNullLazyKey<T, Project> createLazyKey(@NotNull Class<? extends T> serviceClass) {
        if (serviceClass == null) {
            ServiceManager.$$$reportNull$$$0(11);
        }
        NotNullLazyKey<Object, Project> notNullLazyKey = NotNullLazyKey.create("Service: " + serviceClass.getName(), project -> ServiceManager.getService(project, serviceClass));
        if (notNullLazyKey == null) {
            ServiceManager.$$$reportNull$$$0(12);
        }
        return notNullLazyKey;
    }

    private static <T> boolean isLightService(@NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            ServiceManager.$$$reportNull$$$0(13);
        }
        return Modifier.isFinal(serviceClass.getModifiers()) && serviceClass.isAnnotationPresent(Service.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static <T> T getOrCreateLightService(@NotNull Class<T> serviceClass) {
        void var1_5;
        Object v;
        if (serviceClass == null) {
            ServiceManager.$$$reportNull$$$0(14);
        }
        if ((v = ourAppServices.get(serviceClass)) != null) {
            Object v2 = v;
            if (v2 != null) return (T)v2;
            ServiceManager.$$$reportNull$$$0(15);
            return (T)v2;
        }
        Class clazz = serviceClass;
        // MONITORENTER : clazz
        Object v3 = ourAppServices.get(serviceClass);
        if (v3 != null) {
            Object v4 = v3;
            // MONITOREXIT : clazz
            if (v4 != null) return (T)v4;
            ServiceManager.$$$reportNull$$$0(16);
            return (T)v4;
        }
        Application componentManager = ApplicationManager.getApplication();
        try (AccessToken ignore = HeavyProcessLatch.INSTANCE.processStarted("Creating service '" + serviceClass.getName() + "'");){
            if (ProgressIndicatorProvider.getGlobalProgressIndicator() == null) {
                T t = ServiceManager.createLightService(serviceClass, componentManager);
            } else {
                Ref ref = new Ref();
                ProgressManager.getInstance().executeNonCancelableSection(() -> ref.set(ServiceManager.createLightService(serviceClass, componentManager)));
                Object t = ref.get();
            }
        }
        Object prevValue = ourAppServices.put(serviceClass, var1_5);
        LOG.assertTrue(prevValue == null);
        void v2 = var1_5;
        // MONITOREXIT : clazz
        if (v2 != null) return v2;
        ServiceManager.$$$reportNull$$$0(17);
        return v2;
    }

    @NotNull
    private static <T> T createLightService(@NotNull Class<T> serviceClass, ComponentManager componentManager) {
        if (serviceClass == null) {
            ServiceManager.$$$reportNull$$$0(18);
        }
        long startTime = StartUpMeasurer.getCurrentTime();
        T instance = ReflectionUtil.newInstance(serviceClass, false);
        if (instance instanceof Disposable) {
            Disposer.register(componentManager, (Disposable)instance);
        }
        componentManager.initializeComponent(instance, null);
        ParallelActivity.SERVICE.record(startTime, instance.getClass(), StartUpMeasurer.Level.APPLICATION);
        T t = instance;
        if (t == null) {
            ServiceManager.$$$reportNull$$$0(19);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentKey";
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/ServiceManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/ServiceManager";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createLazyKey";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateLightService";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createLightService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getServiceIfCreated";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doGetService";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "assertServiceNotRegisteredAsComponent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createLazyKey";
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isLightService";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateLightService";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createLightService";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

