/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import org.jdom.Content;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.Parent;
import org.jdom.Verifier;
import org.jdom.output.Format;

public class Text
extends Content {
    private static final long serialVersionUID = 200L;
    protected String value;

    protected Text(Content.CType ctype) {
        super(ctype);
    }

    protected Text() {
        this(Content.CType.Text);
    }

    public Text(String str) {
        this(Content.CType.Text);
        this.setText(str);
    }

    public String getText() {
        return this.value;
    }

    public String getTextNormalize() {
        return Text.normalizeString(this.getText());
    }

    public static String normalizeString(String str) {
        if (str == null) {
            return "";
        }
        return Format.compact(str);
    }

    public Text setText(String str) {
        if (str == null) {
            this.value = "";
            return this;
        }
        String reason = Verifier.checkCharacterData(str);
        if (reason != null) {
            throw new IllegalDataException(str, "character content", reason);
        }
        this.value = str;
        return this;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return new StringBuilder(64).append("[Text: ").append(this.getText()).append("]").toString();
    }

    @Override
    public Text clone() {
        Text text2 = (Text)super.clone();
        text2.value = this.value;
        return text2;
    }

    @Override
    public Text detach() {
        return (Text)super.detach();
    }

    @Override
    protected Text setParent(Parent parent2) {
        return (Text)super.setParent(parent2);
    }

    @Override
    public Element getParent() {
        return (Element)super.getParent();
    }
}

