/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.resolver.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.resolver.util.URLLister;

public class FileURLLister
implements URLLister {
    private File basedir;

    public FileURLLister() {
        this(null);
    }

    public FileURLLister(File baseDir) {
        this.basedir = baseDir;
    }

    @Override
    public boolean accept(String pattern) {
        return pattern.startsWith("file");
    }

    @Override
    public List listAll(URL url) throws IOException {
        File file;
        String path;
        try {
            path = new File(new URI(url.toExternalForm())).getPath();
        }
        catch (URISyntaxException e) {
            path = url.getPath();
        }
        File file2 = file = this.basedir == null ? new File(path) : new File(this.basedir, path);
        if (file.exists() && file.isDirectory()) {
            String[] files = file.list();
            ArrayList<URL> ret = new ArrayList<URL>(files.length);
            URL context = url.getPath().endsWith("/") ? url : new URL(url.toExternalForm() + "/");
            for (int i = 0; i < files.length; ++i) {
                ret.add(new URL(context, files[i]));
            }
            return ret;
        }
        return Collections.EMPTY_LIST;
    }

    public String toString() {
        return "file lister";
    }
}

