/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.nio;

import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.core.AbstractOutput;
import kotlinx.io.core.IoBuffer;
import kotlinx.io.internal.jvm.ErrorsKt;
import kotlinx.io.pool.ObjectPool;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0015\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b\u000fJ\b\u0010\u0010\u001a\u00020\u000bH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lkotlinx/io/nio/ChannelAsOutput;", "Lkotlinx/io/core/AbstractOutput;", "pool", "Lkotlinx/io/pool/ObjectPool;", "Lkotlinx/io/core/IoBuffer;", "channel", "Ljava/nio/channels/WritableByteChannel;", "(Lkotlinx/io/pool/ObjectPool;Ljava/nio/channels/WritableByteChannel;)V", "getChannel", "()Ljava/nio/channels/WritableByteChannel;", "close", "", "flush", "last", "buffer", "last$kotlinx_io_jvm", "release", "kotlinx-io-jvm"})
final class ChannelAsOutput
extends AbstractOutput {
    @NotNull
    private final WritableByteChannel channel;

    @Override
    public void release() {
        this.flush();
        this.channel.close();
    }

    @Override
    public void last$kotlinx_io_jvm(@NotNull IoBuffer buffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        IoBuffer current = this.getCurrentTail();
        this.setCurrentTail(buffer);
        if (current == IoBuffer.Companion.getEmpty()) {
            return;
        }
        IoBuffer this_$iv = current;
        ByteBuffer bb$iv = this_$iv.readBuffer;
        int positionBefore$iv = bb$iv.position();
        int limit$iv = bb$iv.limit();
        ByteBuffer bb = bb$iv;
        while (bb.hasRemaining()) {
            this.channel.write(bb);
        }
        int delta$iv = bb$iv.position() - positionBefore$iv;
        if (delta$iv < 0) {
            Void void_ = ErrorsKt.negativeShiftError(delta$iv);
            throw null;
        }
        if (bb$iv.limit() != limit$iv) {
            Void void_ = ErrorsKt.limitChangeError();
            throw null;
        }
    }

    @Override
    public void flush() {
        this.last$kotlinx_io_jvm(IoBuffer.Companion.getEmpty());
    }

    @Override
    public void close() {
        this.flush();
        this.channel.close();
    }

    @NotNull
    public final WritableByteChannel getChannel() {
        return this.channel;
    }

    public ChannelAsOutput(@NotNull ObjectPool<IoBuffer> pool, @NotNull WritableByteChannel channel) {
        Intrinsics.checkParameterIsNotNull(pool, (String)"pool");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        super(pool);
        this.channel = channel;
    }
}

