/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.donors;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.CompressionBrotli;
import net.sourceforge.plantuml.code.StringCompressorNone;
import net.sourceforge.plantuml.code.TranscoderImpl;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemDonors
extends AbstractPSystem {
    private static final int COLS = 6;
    private static final int FREE_LINES = 6;
    public static final String DONORS = "6ym902mFR3fSuLzO9ciEU-UTVLaMenKnfVRDznXLdPaQKLLXAao0mEOTctOFBc-_C0Zx6pfwpEqxFUutqbz4LxhtJJEYBLjJd6SKnOAWnzlacc6RUtjIPKW9Ogde_il4xUdMSI4sJgWGoY75FJja_dVfXBnNLM6MxbPr_dI5saaRsR46R3M7opy5BaNbN0u56eGQqwaxr-5GHQEyUk1h2qqoA5pv2dnBAcR5n0wHugiRH-2JpWnghTCwnoVIQlzI5z1Hvt9DYPI4yZnA95gtbVQE0tHVm6GIYKSTiC4ve9B3VeAftPw88N6hGOFAd8p6fcgsFB70H02Qs8u_bA9cyvJCd8PE91vBe8JFht42i5UggOZPaSs0afxHegT9GfVNA-7cUB4qHUgWuJOmuE6aJT1AGVu7Ek7NxgikcInZLzHCUGhprMmUYeSKNQnFPlJjh8M9yd-p8JFLyuhQvYcTnxhQ-9_DeTWqPTNmcz76FEVWFhqjfD1neG3RIw3dUaV5_9cdZOLq2CzZwOLic8jNbb44pXgdYiLVnPRMoBzrXHfR5ylDZGLzpD-GMyb09rOX5aCVqqfcPUSJ9KrJu_EGHqF7Pn9hacRr3kbRYdCj__UsiAAPPXZeUXTpcgwDA1L6GTMTR9e8J0kz6WeBo1selKnkrPVLG_phV43chOaa8hSvWNwcUaAzoyKgp1rhkjJ4363nb6Wd4gyRYI2hBkXrG9b5fYFqsqrwfYsEXQTERtZSj1c3-g9ELqx2Lmk1TpTCohoP76pVuPo2n_7bUVLz7-5Z5S1Qt7lRHMe-Wu5sImj6H5gEACTHTaburq0PMOmbBnhYpnxMk7ZePl0-aqNxc7ctEGvP0YhFceTMkiMuTKs6lYCccx1NiMXh8FYIc0Mg8-DzmEM2v84gBY5ncy4AE7W1mgyFNh4H5kxMGTKj8oT7rodCrdrr6cW9VjpMWQMo3pnLk7Nth3Y3D4gTLynxOSsRnZwa-5X0kHmKpAI9ie-Kefgsbf5HOmnwzhg3vtQgsmAxZMyrZ1KARrDqqs83jYbgkehjHXFpH5HHgH6NFXP6mCyy_2OyDDOXnj_qiXbnfhaXJ4c54vvVd2qDsnujibwZrstRzhPo_lo_rsG7ftfSvrK5q1M4_DzCcTo81TSrFON-tkMBFfWpMIsgrJY9bUUMdWMO32AtRFQcVPgHtQapokrgWpxhyQ6IlwaS9wZh4vPVp59KXoznDjlU6auLvhxvHZZ9eV3-fwYoAJ-uAYKrCO9DxEGepkDuhgCKTrrSGGJq3HS5ndxpisBDbum-NpJdC1mPyjCHTZdStRMW2casfmKMwQplhTkwP7R_IqRmXL6JTbOFQurZX5IBG57DXFeu3000";

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        UDrawable result = this.getGraphicStrings();
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, HtmlColorUtils.WHITE, this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    private UDrawable getGraphicStrings() throws IOException {
        final List<TextBlock> cols = PSystemDonors.getCols(this.getDonors(), 6, 6);
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                TextBlockBackcolored header = GraphicStrings.createBlackOnWhite(Arrays.asList("<b>Special thanks to our sponsors and donors !"));
                header.drawU(ug);
                StringBounder stringBounder = ug.getStringBounder();
                ug = ug.apply(new UTranslate(0.0, header.calculateDimension(stringBounder).getHeight()));
                double x = 0.0;
                double lastX = 0.0;
                double y = 0.0;
                for (TextBlock tb : cols) {
                    Dimension2D dim = tb.calculateDimension(stringBounder);
                    tb.drawU(ug.apply(new UTranslate(x, 0.0)));
                    lastX = x;
                    x += dim.getWidth() + 10.0;
                    y = Math.max(y, dim.getHeight());
                }
                UImage logo = new UImage(PSystemVersion.getPlantumlImage());
                ug.apply(new UTranslate(lastX, y - (double)logo.getHeight())).draw(logo);
            }
        };
    }

    public static List<TextBlock> getCols(List<String> lines, int nbCol, int reserved) throws IOException {
        ArrayList<TextBlock> result = new ArrayList<TextBlock>();
        int maxLine = (lines.size() + (nbCol - 1) + reserved) / nbCol;
        for (int i = 0; i < lines.size(); i += maxLine) {
            List<String> current = lines.subList(i, Math.min(lines.size(), i + maxLine));
            result.add(GraphicStrings.createBlackOnWhite(current));
        }
        return result;
    }

    private List<String> getDonors() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        TranscoderImpl t = new TranscoderImpl(new AsciiEncoder(), new StringCompressorNone(), new CompressionBrotli());
        String s = t.decode(DONORS).replace('*', '.');
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreTokens()) {
            lines.add(st.nextToken());
        }
        return lines;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Donors)");
    }

    public static PSystemDonors create() {
        return new PSystemDonors();
    }
}

