/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public final class ConcurrentStateImage
extends AbstractTextBlock
implements IEntityImage {
    private final List<IEntityImage> inners = new ArrayList<IEntityImage>();
    private final Separator separator;
    private final ISkinParam skinParam;
    private final HtmlColor backColor;

    private HtmlColor getColor(ColorParam colorParam) {
        return new Rose().getHtmlColor(this.skinParam, colorParam);
    }

    public ConcurrentStateImage(Collection<IEntityImage> images, char concurrentSeparator, ISkinParam skinParam, HtmlColor backColor) {
        this.separator = Separator.fromChar(concurrentSeparator);
        this.skinParam = skinParam;
        this.backColor = skinParam.getBackgroundColor();
        this.inners.addAll(images);
    }

    @Override
    public void drawU(UGraphic ug) {
        System.err.println("drawing " + this.inners.size());
        HtmlColor dotColor = this.getColor(ColorParam.stateBorder);
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        for (int i = 0; i < this.inners.size(); ++i) {
            IEntityImage inner = this.inners.get(i);
            inner.drawU(ug);
            Dimension2D dim = inner.calculateDimension(stringBounder);
            ug = ug.apply(this.separator.move(dim));
            if (i >= this.inners.size() - 1) continue;
            this.separator.drawSeparator(ug.apply(new UChangeColor(dotColor)), dimTotal);
        }
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D result = new Dimension2DDouble(0.0, 0.0);
        for (IEntityImage inner : this.inners) {
            Dimension2D dim = inner.calculateDimension(stringBounder);
            result = this.separator.add(result, dim);
        }
        return result;
    }

    @Override
    public HtmlColor getBackcolor() {
        return this.backColor;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return Margins.NONE;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        return 0.0;
    }

    static enum Separator {
        VERTICAL,
        HORIZONTAL;


        static Separator fromChar(char sep) {
            if (sep == '|') {
                return VERTICAL;
            }
            if (sep == '-') {
                return HORIZONTAL;
            }
            throw new IllegalArgumentException();
        }

        UTranslate move(Dimension2D dim) {
            if (this == VERTICAL) {
                return new UTranslate(dim.getWidth(), 0.0);
            }
            return new UTranslate(0.0, dim.getHeight());
        }

        Dimension2D add(Dimension2D orig, Dimension2D other) {
            if (this == VERTICAL) {
                return new Dimension2DDouble(orig.getWidth() + other.getWidth(), Math.max(orig.getHeight(), other.getHeight()));
            }
            return new Dimension2DDouble(Math.max(orig.getWidth(), other.getWidth()), orig.getHeight() + other.getHeight());
        }

        void drawSeparator(UGraphic ug, Dimension2D dimTotal) {
            double THICKNESS_BORDER = 1.5;
            int DASH = 8;
            ug = ug.apply(new UStroke(8.0, 10.0, 1.5));
            if (this == VERTICAL) {
                ug.draw(new ULine(0.0, dimTotal.getHeight() + 8.0));
            } else {
                ug.draw(new ULine(dimTotal.getWidth() + 8.0, 0.0));
            }
        }
    }
}

