/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class ExtremityCircle
extends Extremity {
    private static final double radius = 6.0;
    private final Point2D dest;
    private final boolean fill;

    @Override
    public Point2D somePoint() {
        return this.dest;
    }

    public static UDrawable create(Point2D center, boolean fill) {
        return new ExtremityCircle(center.getX(), center.getY(), fill);
    }

    private ExtremityCircle(double x, double y, boolean fill) {
        this.dest = new Point2D.Double(x, y);
        this.fill = fill;
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(new UStroke(1.5));
        ug = this.fill ? ug.apply(new UChangeBackColor(ug.getParam().getColor())) : ug.apply(new UChangeBackColor(HtmlColorUtils.WHITE));
        ug = ug.apply(new UTranslate(this.dest.getX() - 6.0, this.dest.getY() - 6.0));
        ug.draw(new UEllipse(12.0, 12.0));
    }
}

