/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.DocumentFormatMapper;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentFormatUpdater {
    private static final Logger logger = LoggerFactory.getLogger(DocumentFormatUpdater.class);
    @Nonnull
    private final DocumentFormatMapper formatMapper;

    public DocumentFormatUpdater(@Nonnull DocumentFormatMapper formatMapper) {
        this.formatMapper = (DocumentFormatMapper)Preconditions.checkNotNull((Object)formatMapper);
    }

    public void updateFormat(@Nonnull OWLOntology ontology) {
        Preconditions.checkNotNull((Object)ontology);
        OWLOntologyManager man = ontology.getOWLOntologyManager();
        OWLDocumentFormat format = man.getOntologyFormat(ontology);
        if (format == null) {
            return;
        }
        OWLDocumentFormat mappedFormat = this.formatMapper.mapFormat(format);
        man.setOntologyFormat(ontology, mappedFormat);
        if (mappedFormat != format) {
            logger.info("Updated document format class from: {} to: {}", (Object)format.getClass().getName(), (Object)mappedFormat.getClass().getName());
        }
    }
}

