/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.cls;

import java.awt.Component;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JOptionPane;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLWorkspace;
import org.protege.editor.owl.ui.editor.OWLGeneralAxiomEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.cls.OWLClassGeneralClassAxiomFrameSectionRow;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OWLAxiomVisitorExAdapter;

public class OWLClassGeneralClassAxiomFrameSection
extends AbstractOWLFrameSection<OWLClass, OWLClassAxiom, OWLClassAxiom> {
    public OWLClassGeneralClassAxiomFrameSection(OWLEditorKit editorKit, OWLFrame<? extends OWLClass> frame) {
        super(editorKit, "General class axioms", "General class axiom", frame);
    }

    @Override
    protected OWLClassAxiom createAxiom(OWLClassAxiom object) {
        return object;
    }

    @Override
    public OWLObjectEditor<OWLClassAxiom> getObjectEditor() {
        return new OWLGeneralAxiomEditor(this.getOWLEditorKit());
    }

    @Override
    public void handleEditingFinished(Set<OWLClassAxiom> editedObjects) {
        OWLClassGeneralClassAxiomFrameSection.checkEditedAxiom(this.getOWLEditorKit(), editedObjects, (OWLClass)this.getRootObject());
        super.handleEditingFinished(editedObjects);
    }

    static void checkEditedAxiom(OWLEditorKit editorKit, Set<OWLClassAxiom> editedObjects, OWLClass root) {
        if (editedObjects.isEmpty()) {
            return;
        }
        OWLClassAxiom axiom = editedObjects.iterator().next();
        if (!axiom.containsEntityInSignature((OWLEntity)root)) {
            String classesInSigRendering = "";
            Iterator it = axiom.getClassesInSignature().iterator();
            while (it.hasNext()) {
                OWLClass cls = (OWLClass)it.next();
                classesInSigRendering = classesInSigRendering + editorKit.getModelManager().getRendering((OWLObject)cls);
                if (!it.hasNext()) continue;
                classesInSigRendering = classesInSigRendering + ",\n";
            }
            JOptionPane.showMessageDialog((Component)((Object)editorKit.getOWLWorkspace()), "The axiom that you edited has been added to the ontology.  However, it will not be visible in the view below as it does not mention the selected class (" + editorKit.getOWLModelManager().getRendering((OWLObject)root) + ").\nTo view the axiom, select any of the classes it mentions: \n" + classesInSigRendering);
        }
    }

    @Override
    protected void refill(OWLOntology ontology) {
        OWLWorkspace workspace = this.getOWLEditorKit().getOWLWorkspace();
        OWLClass cls = workspace.getOWLSelectionModel().getLastSelectedClass();
        if (cls == null) {
            return;
        }
        for (OWLClassAxiom ax : ontology.getGeneralClassAxioms()) {
            if (!ax.containsEntityInSignature((OWLEntity)cls)) continue;
            this.addRow(new OWLClassGeneralClassAxiomFrameSectionRow(this.getOWLEditorKit(), this, ontology, (OWLClass)this.getRootObject(), ax));
        }
    }

    @Override
    protected void clear() {
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLClass, OWLClassAxiom, OWLClassAxiom>> getRowComparator() {
        return null;
    }

    @Override
    protected boolean isResettingChange(OWLOntologyChange change) {
        if (!change.isAxiomChange()) {
            return false;
        }
        if (!change.getSignature().contains(this.getRootObject())) {
            return false;
        }
        OWLAxiom axiom = change.getAxiom();
        return (Boolean)axiom.accept((OWLAxiomVisitorEx)new OWLAxiomVisitorExAdapter<Boolean>(Boolean.valueOf(false)){

            public Boolean visit(OWLSubClassOfAxiom axiom) {
                return axiom.isGCI();
            }

            public Boolean visit(OWLEquivalentClassesAxiom axiom) {
                return !axiom.contains((OWLClassExpression)OWLClassGeneralClassAxiomFrameSection.this.getRootObject());
            }

            public Boolean visit(OWLDisjointClassesAxiom axiom) {
                return !axiom.contains((OWLClassExpression)OWLClassGeneralClassAxiomFrameSection.this.getRootObject());
            }
        });
    }
}

