/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import net.sf.sdedit.ui.components.Stainable;
import net.sf.sdedit.ui.components.navigator.ContextActionsProvider;
import net.sf.sdedit.ui.components.navigator.TreeNavigatorControl;
import net.sf.sdedit.ui.components.navigator.TreeNavigatorModel;
import net.sf.sdedit.ui.components.navigator.TreeNavigatorNode;
import net.sf.sdedit.ui.components.navigator.TreeNavigatorNodeRenderer;
import net.sf.sdedit.ui.components.navigator.TreeNavigatorPaneListener;
import net.sf.sdedit.util.Utilities;
import net.sf.sdedit.util.collection.IndexedList;
import net.sf.sdedit.util.tree.BreadthFirstSearch;

public class TreeNavigatorPane
extends JPanel {
    private static final long serialVersionUID = -610209631378617019L;
    private final JSplitPane splitPane;
    private final JScrollPane navigationScrollPane;
    private final JTree navigationTree;
    private JComponent selected;
    private final JPanel contentPanel;
    private final TreeNavigatorNodeRenderer renderer;
    private final TreeNavigatorModel treeModel;
    private final TreeNavigatorControl ctrl;
    private final LinkedList<TreeNavigatorPaneListener> listeners;
    private final IndexedList<JComponent> componentHistory;
    private final Set<String> categories;
    private boolean historyEnabled;
    private boolean setSelectedComponentEntered = false;

    public TreeNavigatorPane(double resizeWeight) {
        this.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane(1);
        this.splitPane.setOneTouchExpandable(true);
        this.treeModel = new TreeNavigatorModel();
        this.navigationTree = new JTree(this.treeModel);
        this.navigationTree.setRootVisible(false);
        this.ctrl = new TreeNavigatorControl(this, this.treeModel);
        this.navigationTree.addMouseListener(this.ctrl);
        this.navigationTree.addTreeSelectionListener(this.ctrl);
        this.renderer = new TreeNavigatorNodeRenderer();
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.listeners = new LinkedList();
        this.navigationTree.setCellRenderer(this.renderer);
        this.navigationScrollPane = new JScrollPane(this.navigationTree);
        this.add((Component)this.splitPane, "Center");
        this.splitPane.setLeftComponent(this.navigationScrollPane);
        this.splitPane.setRightComponent(this.contentPanel);
        this.splitPane.setResizeWeight(resizeWeight);
        this.categories = new HashSet<String>();
        this.componentHistory = new IndexedList();
        this.historyEnabled = true;
    }

    protected JTree getTree() {
        return this.navigationTree;
    }

    public void addListener(TreeNavigatorPaneListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TreeNavigatorPaneListener listener) {
        this.listeners.remove(listener);
    }

    public void addRootCategory(String category, ImageIcon icon) {
        TreeNavigatorNode rootNode = new TreeNavigatorNode(category, icon, null);
        this.categories.add(category);
        this.treeModel.addChild(this.treeModel.getRoot(), rootNode, null);
    }

    public TreeNavigatorNode getNode(JComponent component) {
        if (component == null) {
            return null;
        }
        return this.treeModel.find(component);
    }

    public void addComponent(String title, JComponent comp, Icon icon, String rootCategory, boolean selectIt, JComponent previousSibling) {
        TreeNavigatorNode node = new TreeNavigatorNode(title, icon, comp);
        TreeNavigatorNode categoryNode = this.treeModel.getCategoryNode(rootCategory);
        this.treeModel.addChild(categoryNode, node, this.getNode(previousSibling));
        if (comp instanceof Stainable) {
            ((Stainable)((Object)comp)).addStainedListener(this.ctrl);
        }
        if (selectIt) {
            this.setSelectedComponent(comp);
        }
    }

    public void addComponent(String title, JComponent child, Icon icon, JComponent parent, boolean selectIt, JComponent previousSibling) {
        TreeNavigatorNode node = new TreeNavigatorNode(title, icon, child);
        TreeNavigatorNode parentNode = parent != null ? this.treeModel.find(parent) : this.treeModel.getRoot();
        this.treeModel.addChild(parentNode, node, this.getNode(previousSibling));
        if (child instanceof Stainable) {
            ((Stainable)((Object)child)).addStainedListener(this.ctrl);
        }
        if (selectIt) {
            this.setSelectedComponent(child);
        }
    }

    public JComponent[] removeComponent(JComponent comp, boolean removeDescendants) {
        JComponent[] selected = this.getSelectedComponents();
        LinkedList<JComponent> list = new LinkedList<JComponent>();
        TreeNavigatorNode node = this.treeModel.find(comp);
        if (node != null) {
            if (removeDescendants) {
                TreePath current;
                BreadthFirstSearch bfs = new BreadthFirstSearch(this.treeModel, node);
                LinkedList<Object> nodes = new LinkedList<Object>();
                do {
                    if ((current = bfs.next()) == null) continue;
                    nodes.add(current.getLastPathComponent());
                } while (current != null);
                while (!nodes.isEmpty()) {
                    TreeNavigatorNode last = (TreeNavigatorNode)nodes.removeLast();
                    list.add(last.getComponent());
                    this.removeNode(last);
                }
            } else {
                this.removeNode(node);
                list.add(comp);
            }
        }
        boolean isSelected = false;
        for (JComponent cmp : list) {
            isSelected |= Utilities.in(cmp, selected);
            this.componentHistory.remove(cmp);
        }
        if (isSelected && !this.componentHistory.isEmpty()) {
            this.setSelectedComponent(this.componentHistory.getLast());
        }
        return list.toArray(new JComponent[list.size()]);
    }

    private void removeNode(TreeNavigatorNode node) {
        if (node.getChildCount() > 0) {
            TreeNavigatorNode parent = node.getParent();
            for (TreeNavigatorNode child : node.getChildren()) {
                this.treeModel.addChild(parent, child, null);
                this.treeModel.removeChild(node, child);
            }
        }
        this.treeModel.removeChild(node.getParent(), node);
    }

    public boolean existsCategory(String category) {
        return this.categories.contains(category);
    }

    public boolean setSelectedComponent(JComponent comp) {
        return this.setSelectedComponent(comp, true, true);
    }

    public void setContextActionsProvider(ContextActionsProvider provider) {
        this.ctrl.setContextActionsProvider(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setSelectedComponent(final JComponent comp, boolean selectInTree, boolean updateHistory) {
        if (this.setSelectedComponentEntered) {
            return true;
        }
        if (this.historyEnabled && updateHistory) {
            this.componentHistory.remove(comp);
            this.componentHistory.add(comp);
        }
        this.setSelectedComponentEntered = true;
        try {
            this.selected = comp;
            TreeNavigatorNode node = this.treeModel.find(comp);
            if (node == null) {
                boolean bl = false;
                return bl;
            }
            if (selectInTree) {
                TreePath path = node.getTreePath();
                this.navigationTree.setSelectionPath(path);
            }
            this.contentPanel.removeAll();
            this.contentPanel.add((Component)comp, "Center");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeNavigatorPane.this.navigationTree.revalidate();
                    TreeNavigatorPane.this.contentPanel.revalidate();
                    TreeNavigatorPane.this.repaint();
                    for (TreeNavigatorPaneListener listener : TreeNavigatorPane.this.listeners) {
                        listener.componentSelected(comp);
                    }
                }
            });
            boolean bl = true;
            return bl;
        }
        finally {
            this.setSelectedComponentEntered = false;
        }
    }

    public JComponent getSelectedComponent() {
        return this.selected;
    }

    public JComponent[] getSelectedComponents() {
        LinkedList<JComponent> list = new LinkedList<JComponent>();
        TreePath[] paths = this.navigationTree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                TreeNavigatorNode node = (TreeNavigatorNode)path.getLastPathComponent();
                if (node.getComponent() == null) continue;
                list.add(node.getComponent());
            }
        }
        return list.toArray(new JComponent[list.size()]);
    }

    public void setTitle(JComponent comp, String title) {
        TreeNavigatorNode node = this.treeModel.find(comp);
        if (node != null) {
            this.treeModel.setTitle(node, title);
        }
        this.navigationTree.repaint();
    }

    public List<String> getAllTitles() {
        return this.treeModel.getAllTitles();
    }

    public int getCompCount() {
        return this.treeModel.getComponents().size();
    }

    public List<JComponent> getAllComponents() {
        return this.treeModel.getComponents();
    }

    public List<JComponent> getSuccessors(JComponent comp) {
        TreeNavigatorNode node = this.treeModel.find(comp);
        TreeNavigatorNode[] children = node.getChildren();
        LinkedList<JComponent> succs = new LinkedList<JComponent>();
        for (TreeNavigatorNode child : children) {
            succs.add(child.getComponent());
        }
        return succs;
    }

    public List<JComponent> getDescendants(JComponent root) {
        TreePath desc;
        TreeNavigatorNode rootNode = this.treeModel.find(root);
        BreadthFirstSearch bfs = new BreadthFirstSearch(this.treeModel, rootNode);
        LinkedList<JComponent> descendants = new LinkedList<JComponent>();
        while ((desc = bfs.next()) != null) {
            TreeNavigatorNode current = (TreeNavigatorNode)desc.getLastPathComponent();
            if (current == rootNode) continue;
            descendants.add(current.getComponent());
        }
        return descendants;
    }

    public JComponent getParentComponent(JComponent comp) {
        TreeNavigatorNode node = this.treeModel.find(comp);
        return node.getParent().getComponent();
    }

    public void goToNextComponent() {
        JComponent next = this.componentHistory.next(this.selected);
        if (next != null) {
            this.setSelectedComponent(next, true, false);
        }
    }

    public boolean nextComponentExists() {
        return this.componentHistory.contains(this.selected) && this.componentHistory.next(this.selected) != null;
    }

    public void goToPreviousComponent() {
        JComponent previous = this.componentHistory.previous(this.selected);
        if (previous != null) {
            this.setSelectedComponent(previous, true, false);
        }
    }

    public boolean previousComponentExists() {
        return this.componentHistory.contains(this.selected) && this.componentHistory.previous(this.selected) != null;
    }

    public void enableHistory() {
        this.historyEnabled = true;
    }

    public void disableHistory() {
        this.historyEnabled = false;
    }

    public TreePath getPathFor(MouseEvent e) {
        int y;
        int x = e.getX();
        TreePath path = this.navigationTree.getClosestPathForLocation(x, y = e.getY());
        Rectangle rect = this.navigationTree.getPathBounds(path);
        if (rect.contains(x, y)) {
            return path;
        }
        return null;
    }
}

