/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.context;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.gephi.desktop.context.ContextPanel;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.ui.utils.UIUtils;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ContextTopComponent", persistenceType=0)
public final class ContextTopComponent
extends TopComponent {
    private final transient ContextPanel contextPanel = new ContextPanel();
    private JPanel mainPanel;

    public ContextTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(ContextTopComponent.class, (String)"CTL_ContextTopComponent"));
        this.putClientProperty("netbeans.winsys.tc.maximization_disabled", Boolean.TRUE);
        if (UIUtils.isAquaLookAndFeel()) {
            this.mainPanel.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.mainPanel.add((Component)this.contextPanel, "Center");
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        pc.addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
            }

            public void select(Workspace workspace) {
                GraphController gc = (GraphController)Lookup.getDefault().lookup(GraphController.class);
                GraphModel gm = gc.getGraphModel(workspace);
                ContextTopComponent.this.contextPanel.refreshModel(gm);
            }

            public void unselect(Workspace workspace) {
            }

            public void close(Workspace workspace) {
            }

            public void disable() {
                ContextTopComponent.this.contextPanel.refreshModel(null);
            }
        });
        if (pc.getCurrentWorkspace() != null) {
            GraphModel gm = (GraphModel)pc.getCurrentWorkspace().getLookup().lookup(GraphModel.class);
            this.contextPanel.refreshModel(gm);
        }
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new BorderLayout());
        this.add(this.mainPanel, "Center");
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

