/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.protege.editor.owl.ui.editor.IRITextEditor;
import org.protege.editor.owl.ui.editor.OWLClassSelectorWrapper;
import org.protege.editor.owl.ui.editor.OWLDatatypeSelectionEditor;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;

public class OWLAnnotationPropertyRangeEditor
extends AbstractOWLObjectEditor<IRI> {
    private OWLEditorKit editorKit;
    private JComponent editingComponent;
    private JTabbedPane tabs;
    private OWLClassSelectorWrapper classSelectionEditor;
    private OWLDatatypeSelectionEditor datatypeSelectionEditor;
    private IRITextEditor iriTextEditor;

    public OWLAnnotationPropertyRangeEditor(OWLEditorKit editorKit) {
        this.editorKit = editorKit;
        this.classSelectionEditor = new OWLClassSelectorWrapper();
        this.classSelectionEditor.setup("class.hierarchy", "Class Hierarchy Selection Editor", editorKit);
        this.classSelectionEditor.initialise();
        this.datatypeSelectionEditor = new OWLDatatypeSelectionEditor(editorKit);
        this.iriTextEditor = new IRITextEditor(editorKit);
        this.tabs = new JTabbedPane();
        this.tabs.addTab("Select Class", this.classSelectionEditor.getComponent());
        this.tabs.addTab("Select datatype", this.datatypeSelectionEditor.getEditorComponent());
        this.tabs.addTab("Edit raw IRI", this.iriTextEditor.getEditorComponent());
        this.editingComponent = new JPanel(new BorderLayout());
        this.editingComponent.setPreferredSize(new Dimension(500, 500));
        this.editingComponent.add(this.tabs);
    }

    @Override
    @Nonnull
    public String getEditorTypeName() {
        return "Annotation Property domain Editor";
    }

    @Override
    public boolean canEdit(Object object) {
        return object instanceof OWLAnnotationProperty;
    }

    @Override
    @Nonnull
    public JComponent getEditorComponent() {
        return this.editingComponent;
    }

    @Override
    @Nullable
    public IRI getEditedObject() {
        Component component = this.tabs.getSelectedComponent();
        if (component == this.classSelectionEditor.getComponent()) {
            for (OWLClassExpression ce : this.classSelectionEditor.getClassExpressions()) {
                if (ce.isAnonymous()) continue;
                return ce.asOWLClass().getIRI();
            }
        } else {
            if (component == this.datatypeSelectionEditor.getEditorComponent()) {
                OWLDatatype dt = this.datatypeSelectionEditor.getEditedObject();
                return dt != null ? dt.getIRI() : null;
            }
            if (component == this.iriTextEditor.getEditorComponent()) {
                return this.iriTextEditor.getEditedObject();
            }
        }
        return null;
    }

    @Override
    public boolean setEditedObject(IRI editedObject) {
        if (editedObject == null) {
            return false;
        }
        OWLDataFactory factory = this.editorKit.getOWLModelManager().getOWLDataFactory();
        OWLClass cls = factory.getOWLClass(editedObject);
        OWLDatatype dt = factory.getOWLDatatype(editedObject);
        boolean classFound = cls.isBuiltIn();
        boolean datatypeFound = dt.isBuiltIn();
        for (OWLOntology o : this.editorKit.getOWLModelManager().getActiveOntologies()) {
            if (o.containsEntityInSignature((OWLEntity)cls)) {
                classFound = true;
            }
            if (o.containsEntityInSignature((OWLEntity)dt)) {
                datatypeFound = true;
            }
            if (!classFound || !datatypeFound) continue;
            break;
        }
        if (classFound) {
            this.classSelectionEditor.setDescription((OWLClassExpression)cls);
        }
        if (datatypeFound) {
            this.datatypeSelectionEditor.setEditedObject(dt);
        }
        this.iriTextEditor.setEditedObject(editedObject);
        return true;
    }

    @Override
    public void dispose() {
        if (this.classSelectionEditor != null) {
            this.classSelectionEditor.dispose();
            this.iriTextEditor.dispose();
            this.datatypeSelectionEditor.dispose();
            this.classSelectionEditor = null;
            this.iriTextEditor = null;
            this.datatypeSelectionEditor = null;
        }
    }
}

