/*
 * Decompiled with CFR 0.152.
 */
package org.protege.xmlcatalog.redirect;

import java.io.IOException;
import java.net.URI;
import org.apache.log4j.Logger;
import org.protege.xmlcatalog.EntryVisitor;
import org.protege.xmlcatalog.XMLCatalog;
import org.protege.xmlcatalog.entry.DelegatePublicEntry;
import org.protege.xmlcatalog.entry.DelegateSystemEntry;
import org.protege.xmlcatalog.entry.DelegateUriEntry;
import org.protege.xmlcatalog.entry.Entry;
import org.protege.xmlcatalog.entry.GroupEntry;
import org.protege.xmlcatalog.entry.NextCatalogEntry;
import org.protege.xmlcatalog.entry.PublicEntry;
import org.protege.xmlcatalog.entry.RewriteSystemEntry;
import org.protege.xmlcatalog.entry.RewriteUriEntry;
import org.protege.xmlcatalog.entry.SystemEntry;
import org.protege.xmlcatalog.entry.UriEntry;

public class UriRedirectVisitor
implements EntryVisitor {
    private static Logger log = Logger.getLogger(UriRedirectVisitor.class);
    private URI original;
    private URI redirect;

    public UriRedirectVisitor(URI original) {
        this.original = original;
    }

    public URI getRedirect() {
        return this.redirect;
    }

    @Override
    public void visit(GroupEntry entry) {
        for (Entry subEntry : entry.getEntries()) {
            subEntry.accept(this);
            if (this.redirect == null) continue;
            break;
        }
    }

    @Override
    public void visit(PublicEntry entry) {
    }

    @Override
    public void visit(SystemEntry entry) {
    }

    @Override
    public void visit(RewriteSystemEntry entry) {
    }

    @Override
    public void visit(DelegatePublicEntry entry) {
    }

    @Override
    public void visit(DelegateSystemEntry entry) {
    }

    @Override
    public void visit(UriEntry entry) {
        if (this.original.equals(URI.create(entry.getName()))) {
            this.redirect = entry.getAbsoluteURI();
        }
    }

    @Override
    public void visit(RewriteUriEntry entry) {
        try {
            String originalString = this.original.toString();
            if (originalString.startsWith(entry.getUriStartString())) {
                String suffix = originalString.substring(entry.getUriStartString().length());
                this.redirect = URI.create(entry.getRewritePrefix().toString() + suffix);
            }
        }
        catch (Throwable e) {
            log.error((Object)("Exception caught trying to resolve " + this.original), e);
        }
    }

    @Override
    public void visit(DelegateUriEntry entry) {
        try {
            String originalString;
            if (this.original.isAbsolute() && (originalString = this.original.toString()).startsWith(entry.getUriStartString())) {
                this.visitCatalog(entry.getParsedCatalog());
            }
        }
        catch (IOException ioe) {
            log.error((Object)("Exception caught trying to resolve " + this.original), (Throwable)ioe);
        }
    }

    @Override
    public void visit(NextCatalogEntry entry) {
        try {
            this.visitCatalog(entry.getParsedCatalog());
        }
        catch (IOException ioe) {
            log.error((Object)("Exception caught trying to resolve " + this.original), (Throwable)ioe);
        }
    }

    private void visitCatalog(XMLCatalog catalog) {
        for (Entry subEntry : catalog.getEntries()) {
            subEntry.accept(this);
            if (this.redirect == null) continue;
            break;
        }
    }
}

