/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.v2.ProfilerFeature;
import org.netbeans.modules.profiler.v2.impl.Bundle;

public class FeaturesView
extends JPanel {
    private JTabbedPane tabs;
    private final Component defaultView;
    private JLabel hintLabel;
    private final Color hintColor;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>();
    private static final int XMAR = 40;
    private static final int YMAR = 40;

    public FeaturesView(Component component, String string) {
        Serializable serializable;
        if (UIUtils.isOracleLookAndFeel()) {
            this.setOpaque(true);
            this.setBackground(UIUtils.getProfilerResultsBackground());
        } else {
            this.setOpaque(false);
        }
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout(0, 0));
        if (component != null) {
            serializable = new JScrollPane(component, 20, 31){

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
            ((JScrollPane)serializable).getVerticalScrollBar().setUnitIncrement(20);
            ((JComponent)serializable).setBorder(null);
            ((JScrollPane)serializable).setViewportBorder(null);
            this.defaultView = serializable;
            this.add(this.defaultView, "Center");
        } else {
            this.defaultView = null;
        }
        if (string != null) {
            this.hintLabel = new JLabel();
            this.hintLabel.setIcon(Icons.getIcon((String)"GeneralIcons.Info"));
            this.hintLabel.setIconTextGap(this.hintLabel.getIconTextGap() + 1);
            this.hintLabel.setOpaque(false);
            serializable = new JToolTip().getFont();
            Color color = this.hintLabel.getForeground();
            int n = color.getRed() + 70;
            n = n > 255 ? color.getRed() - 70 : Math.min(n, 70);
            int n2 = color.getGreen() + 70;
            n2 = n2 > 255 ? color.getRed() - 70 : Math.min(n2, 70);
            int n3 = color.getBlue() + 70;
            n3 = n3 > 255 ? color.getRed() - 70 : Math.min(n3, 70);
            this.hintLabel.setText("<html><body text=\"rgb(" + n + ", " + n2 + ", " + n3 + ")\" style=\"font-size: " + ((Font)serializable).getSize() + "pt; font-family: " + ((Font)serializable).getName() + ";\">" + Bundle.FeaturesView_noData("<b>" + string + "</b>") + "</body></html>");
            this.hintLabel.setSize(this.hintLabel.getPreferredSize());
            Color color2 = UIUtils.getProfilerResultsBackground();
            this.hintColor = Utils.checkedColor((Color)new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), 245));
        } else {
            this.hintColor = null;
        }
    }

    public final void resetNoDataHint() {
        this.hintLabel = null;
        this.repaint();
    }

    public final void addFeature(ProfilerFeature profilerFeature) {
        if (this.tabs == null) {
            if (this.defaultView != null) {
                this.remove(this.defaultView);
            }
            this.tabs = this.createTabs();
            this.add((Component)this.tabs, "Center");
        }
        JPanel jPanel = this.createContainer(profilerFeature);
        this.tabs.addTab(profilerFeature.getName(), profilerFeature.getIcon(), jPanel, null);
        this.doLayout();
        this.repaint();
        this.fireViewOrIndexChanged();
    }

    private JPanel createContainer(ProfilerFeature profilerFeature) {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.putClientProperty(ProfilerFeature.class, profilerFeature);
        JPanel jPanel2 = profilerFeature.getResultsUI();
        JPanel jPanel3 = new JPanel(new BorderLayout()){

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (FeaturesView.this.hintLabel != null) {
                    Dimension dimension = FeaturesView.this.hintLabel.getSize();
                    int n = (this.getWidth() - dimension.width) / 2;
                    int n2 = (this.getHeight() - dimension.height) / 2;
                    graphics.setColor(FeaturesView.this.hintColor);
                    graphics.fillRect(n - 40, n2 - 40, dimension.width + 80, dimension.height + 80);
                    graphics.setColor(Color.LIGHT_GRAY);
                    graphics.drawRect(n - 40, n2 - 40, dimension.width + 80, dimension.height + 80);
                    graphics.translate(n, n2);
                    FeaturesView.this.hintLabel.paint(graphics);
                    graphics.translate(-n, -n2);
                }
            }
        };
        jPanel3.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel4 = profilerFeature.getSettingsUI();
        if (jPanel4 != null) {
            JPanel jPanel5 = new JPanel(new BorderLayout(0, 0)){

                @Override
                public void setVisible(boolean bl) {
                    super.setVisible(bl);
                    for (Component component : this.getComponents()) {
                        component.setVisible(bl);
                    }
                }
            };
            jPanel5.setOpaque(true);
            jPanel5.setBackground(UIUtils.getProfilerResultsBackground());
            jPanel5.add((Component)jPanel4, "Center");
            JSeparator jSeparator = UIUtils.createHorizontalLine((Color)jPanel5.getBackground());
            jPanel5.add((Component)jSeparator, "South");
            jPanel5.setVisible(jPanel4.isVisible());
            jPanel.add((Component)jPanel5, "North");
        }
        return jPanel;
    }

    public final void removeFeature(ProfilerFeature profilerFeature) {
        if (this.tabs != null) {
            this.tabs.remove(profilerFeature.getResultsUI());
            this.doLayout();
            this.repaint();
            if (this.tabs.getTabCount() == 0) {
                this.removeFeatures();
            } else {
                this.fireViewOrIndexChanged();
            }
        }
    }

    public final void removeFeatures() {
        this.removeAll();
        this.tabs = null;
        if (this.defaultView != null) {
            this.add(this.defaultView, "Center");
        }
        this.doLayout();
        this.repaint();
        this.fireViewOrIndexChanged();
    }

    public final ProfilerFeature getSelectedFeature() {
        if (this.tabs == null) {
            return null;
        }
        JPanel jPanel = (JPanel)this.tabs.getSelectedComponent();
        return (ProfilerFeature)jPanel.getClientProperty(ProfilerFeature.class);
    }

    public final void selectFeature(ProfilerFeature profilerFeature) {
        if (this.tabs == null) {
            return;
        }
        for (Component component : this.tabs.getComponents()) {
            if (((JComponent)component).getClientProperty(ProfilerFeature.class) != profilerFeature) continue;
            this.tabs.setSelectedComponent(component);
        }
    }

    public final void selectFeature(int n) {
        if (this.tabs == null) {
            return;
        }
        this.tabs.setSelectedIndex(n);
    }

    public final void selectPreviousFeature() {
        if (this.tabs == null) {
            return;
        }
        int n = UIUtils.getPreviousSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex());
        this.tabs.setSelectedIndex(n);
    }

    public final void selectNextFeature() {
        if (this.tabs == null) {
            return;
        }
        int n = UIUtils.getNextSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex());
        this.tabs.setSelectedIndex(n);
    }

    public final void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public final void fireViewOrIndexChanged() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private JTabbedPane createTabs() {
        JTabbedPane jTabbedPane = new JTabbedPane(3){

            @Override
            protected final void fireStateChanged() {
                super.fireStateChanged();
                FeaturesView.this.fireViewOrIndexChanged();
            }
        };
        jTabbedPane.setOpaque(false);
        if (UIUtils.isAquaLookAndFeel()) {
            jTabbedPane.setBorder(BorderFactory.createEmptyBorder(-13, -11, 0, -10));
        } else {
            jTabbedPane.setBorder(BorderFactory.createEmptyBorder());
            Insets insets = UIManager.getInsets("TabbedPane.contentBorderInsets");
            int n = 0;
            if (UIUtils.isMetalLookAndFeel()) {
                n = -insets.bottom + 1;
            } else if (UIUtils.isWindowsLookAndFeel()) {
                n = -insets.bottom;
            }
            if (insets != null) {
                jTabbedPane.setBorder(BorderFactory.createEmptyBorder(-insets.top, -insets.left, n, -insets.right));
            }
        }
        jTabbedPane.getActionMap().getParent().remove("navigatePageUp");
        jTabbedPane.getActionMap().getParent().remove("navigatePageDown");
        this.getActionMap().put("PreviousViewAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FeaturesView.this.selectPreviousFeature();
            }
        });
        this.getActionMap().put("NextViewAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FeaturesView.this.selectNextFeature();
            }
        });
        return jTabbedPane;
    }
}

