/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.java;

import com.sun.tools.visualvm.heapviewer.HeapContext;
import com.sun.tools.visualvm.heapviewer.java.Bundle;
import com.sun.tools.visualvm.heapviewer.java.JavaHeapFragment;
import com.sun.tools.visualvm.heapviewer.java.StackFrameNode;
import com.sun.tools.visualvm.heapviewer.model.DataType;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerActions;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerNodeAction;
import java.awt.event.ActionEvent;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.api.GoToSource;

public class JavaGoToSourceAction
extends HeapViewerNodeAction.Provider {
    @Override
    public boolean supportsView(HeapContext context, String viewID) {
        return GoToSource.isAvailable() && JavaHeapFragment.isJavaHeap(context);
    }

    @Override
    public HeapViewerNodeAction[] getActions(HeapViewerNode node, HeapContext context, HeapViewerActions actions) {
        GoToSourceAction action;
        if (node instanceof StackFrameNode) {
            action = new GoToSourceAction((StackFrameNode)node);
        } else {
            JavaClass javaClass = HeapViewerNode.getValue(node, DataType.CLASS, context.getFragment().getHeap());
            action = new GoToSourceAction(javaClass);
        }
        return new HeapViewerNodeAction[]{action};
    }

    private static class GoToSourceAction
    extends HeapViewerNodeAction {
        private final String className;
        private final String methodName;
        private final int line;

        private GoToSourceAction(JavaClass javaClass) {
            super(Bundle.JavaGoToSourceAction_GoToSource(), 210);
            this.className = javaClass == null ? null : javaClass.getName();
            this.methodName = null;
            this.line = -1;
            this.setEnabled(this.className != null);
        }

        private GoToSourceAction(StackFrameNode sfNode) {
            super(Bundle.JavaGoToSourceAction_GoToSource(), 210);
            String name = sfNode.getName();
            int fileIdx = name.indexOf("(");
            String methodName = name.substring(0, fileIdx);
            String fileName = name.substring(fileIdx);
            int classIdx = methodName.lastIndexOf(46);
            this.className = methodName.substring(0, classIdx);
            this.methodName = methodName.substring(classIdx + 1);
            int lineIdxS = fileName.indexOf(58);
            int lineIdxE = fileName.indexOf(41);
            this.line = lineIdxS == -1 ? -1 : Integer.parseInt(fileName.substring(lineIdxS + 1, lineIdxE));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.line == -1) {
                GoToSource.openSource(null, (String)this.className, (String)this.methodName, null);
            } else {
                GoToSource.openSource(null, (String)this.className, (String)this.methodName, (int)this.line);
            }
        }
    }
}

