/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.attribute.FileTime;
import java.util.jar.JarEntry;
import jnr.posix.FileStat;
import org.jruby.util.DummyResourceStat;
import org.jruby.util.FileResource;
import org.jruby.util.JarCache;
import org.jruby.util.JarDirectoryResource;
import org.jruby.util.JarFileResource;
import org.jruby.util.StringSupport;

abstract class JarResource
implements FileResource,
DummyResourceStat.FileResourceExt {
    private static final JarCache jarCache = new JarCache();
    private final CharSequence jarPrefix;
    private transient String absolutePath;
    private transient FileStat fileStat;

    public static JarResource create(String pathname2) {
        JarResource resource2;
        int bang = pathname2.indexOf(33);
        if (bang == -1) {
            return null;
        }
        if (pathname2.startsWith("jar:")) {
            if (pathname2.startsWith("file:", 4)) {
                pathname2 = pathname2.substring(9);
                bang -= 9;
            } else {
                pathname2 = pathname2.substring(4);
                bang -= 4;
            }
        } else if (pathname2.startsWith("file:")) {
            pathname2 = pathname2.substring(5);
            bang -= 5;
        }
        String jarPath = pathname2.substring(0, bang);
        String entryPath = pathname2.substring(bang + 1);
        if (StringSupport.startsWith(entryPath, '/', '/')) {
            entryPath = entryPath.substring(1);
        }
        if ((resource2 = JarResource.createJarResource(jarPath, entryPath, false)) == null && StringSupport.startsWith((CharSequence)entryPath, '/')) {
            resource2 = JarResource.createJarResource(jarPath, entryPath.substring(1), true);
        }
        return resource2;
    }

    private static JarResource createJarResource(String jarPath, String entryPath, boolean rootSlashPrefix) {
        String[] entries2;
        JarCache.JarIndex index2 = jarCache.getIndex(jarPath);
        if (index2 == null) {
            try {
                jarPath = URLDecoder.decode(jarPath, "UTF-8");
                entryPath = URLDecoder.decode(entryPath, "UTF-8");
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
            index2 = jarCache.getIndex(jarPath);
            if (index2 == null) {
                return null;
            }
        }
        if ((entries2 = index2.getDirEntries(entryPath)) != null) {
            return new JarDirectoryResource(jarPath, rootSlashPrefix, entryPath, entries2);
        }
        if (entryPath.length() > 1 && entryPath.endsWith("/") && (entries2 = index2.getDirEntries(entryPath.substring(0, entryPath.length() - 1))) != null) {
            return new JarDirectoryResource(jarPath, rootSlashPrefix, entryPath, entries2);
        }
        JarEntry jarEntry = index2.getJarEntry(entryPath);
        if (jarEntry != null) {
            return new JarFileResource(jarPath, rootSlashPrefix, index2, jarEntry);
        }
        return null;
    }

    public static boolean removeJarResource(String jarPath) {
        return jarCache.remove(jarPath);
    }

    JarResource(String jarPath, boolean rootSlashPrefix) {
        StringBuilder prefix = new StringBuilder(jarPath.length() + 2);
        prefix.append(jarPath).append('!');
        this.jarPrefix = rootSlashPrefix ? prefix.append('/') : prefix;
    }

    @Override
    public final String absolutePath() {
        String path2 = this.absolutePath;
        if (path2 != null) {
            return path2;
        }
        this.absolutePath = this.jarPrefix + this.entryName();
        return this.absolutePath;
    }

    @Override
    public String canonicalPath() {
        return this.absolutePath();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean canExecute() {
        return false;
    }

    @Override
    public boolean isSymLink() {
        return false;
    }

    @Override
    public FileStat stat() {
        FileStat fileStat = this.fileStat;
        if (fileStat != null) {
            return fileStat;
        }
        this.fileStat = new DummyResourceStat(this);
        return this.fileStat;
    }

    @Override
    public FileStat lstat() {
        return this.stat();
    }

    @Override
    public int errno() {
        return 0;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public abstract FileTime creationTime() throws IOException;

    @Override
    public abstract FileTime lastAccessTime() throws IOException;

    @Override
    public abstract FileTime lastModifiedTime() throws IOException;

    @Override
    public long lastModified() {
        FileTime mod = null;
        try {
            mod = this.lastModifiedTime();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mod == null ? 0L : mod.toMillis();
    }

    abstract String entryName();

    public String toString() {
        return this.getClass().getName() + '{' + this.absolutePath() + '}';
    }

    public boolean equals(Object obj) {
        if (obj instanceof JarResource) {
            JarResource that = (JarResource)obj;
            return this.absolutePath().equals(that.absolutePath());
        }
        return false;
    }

    public int hashCode() {
        return 11 * this.entryName().hashCode();
    }
}

