/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import org.python.google.common.annotations.GwtCompatible;
import org.python.google.common.base.Objects;
import org.python.google.common.base.Preconditions;
import org.python.google.common.collect.CollectPreconditions;
import org.python.google.common.collect.Multiset;
import org.python.google.common.collect.Multisets;
import org.python.google.common.collect.ObjectArrays;
import org.python.google.common.collect.Sets;
import org.python.google.errorprone.annotations.CanIgnoreReturnValue;

@GwtCompatible(serializable=true, emulated=true)
abstract class AbstractObjectCountMap<K> {
    transient Object[] keys;
    transient int[] values;
    static final int UNSET = -1;
    transient int size;
    transient int modCount;
    private transient Set<K> keySetView;
    private transient Set<Multiset.Entry<K>> entrySetView;

    AbstractObjectCountMap() {
    }

    @CanIgnoreReturnValue
    abstract int put(@Nullable K var1, int var2);

    abstract int get(@Nullable Object var1);

    @CanIgnoreReturnValue
    abstract int remove(@Nullable Object var1);

    abstract void clear();

    abstract boolean containsKey(@Nullable Object var1);

    Set<K> keySet() {
        return this.keySetView == null ? (this.keySetView = this.createKeySet()) : this.keySetView;
    }

    int size() {
        return this.size;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    abstract int indexOf(@Nullable Object var1);

    @CanIgnoreReturnValue
    abstract int removeEntry(int var1);

    Set<K> createKeySet() {
        return new KeySetView();
    }

    K getKey(int index) {
        Preconditions.checkElementIndex(index, this.size);
        return (K)this.keys[index];
    }

    int getValue(int index) {
        Preconditions.checkElementIndex(index, this.size);
        return this.values[index];
    }

    Multiset.Entry<K> getEntry(int index) {
        Preconditions.checkElementIndex(index, this.size);
        return new MapEntry(index);
    }

    int firstIndex() {
        return 0;
    }

    int nextIndex(int index) {
        return index + 1 < this.size ? index + 1 : -1;
    }

    Set<Multiset.Entry<K>> entrySet() {
        return this.entrySetView == null ? (this.entrySetView = this.createEntrySet()) : this.entrySetView;
    }

    abstract Set<Multiset.Entry<K>> createEntrySet();

    class MapEntry
    extends Multisets.AbstractEntry<K> {
        @Nullable
        final K key;
        int lastKnownIndex;

        MapEntry(int index) {
            this.key = AbstractObjectCountMap.this.keys[index];
            this.lastKnownIndex = index;
        }

        @Override
        public K getElement() {
            return this.key;
        }

        void updateLastKnownIndex() {
            if (this.lastKnownIndex == -1 || this.lastKnownIndex >= AbstractObjectCountMap.this.size() || !Objects.equal(this.key, AbstractObjectCountMap.this.keys[this.lastKnownIndex])) {
                this.lastKnownIndex = AbstractObjectCountMap.this.indexOf(this.key);
            }
        }

        @Override
        public int getCount() {
            this.updateLastKnownIndex();
            return this.lastKnownIndex == -1 ? 0 : AbstractObjectCountMap.this.values[this.lastKnownIndex];
        }

        @CanIgnoreReturnValue
        public int setCount(int count2) {
            this.updateLastKnownIndex();
            if (this.lastKnownIndex == -1) {
                AbstractObjectCountMap.this.put(this.key, count2);
                return 0;
            }
            int old = AbstractObjectCountMap.this.values[this.lastKnownIndex];
            AbstractObjectCountMap.this.values[this.lastKnownIndex] = count2;
            return old;
        }
    }

    abstract class EntrySetView
    extends Sets.ImprovedAbstractSet<Multiset.Entry<K>> {
        EntrySetView() {
        }

        @Override
        public boolean contains(@Nullable Object o) {
            if (o instanceof Multiset.Entry) {
                Multiset.Entry entry = (Multiset.Entry)o;
                int index = AbstractObjectCountMap.this.indexOf(entry.getElement());
                return index != -1 && AbstractObjectCountMap.this.values[index] == entry.getCount();
            }
            return false;
        }

        @Override
        public boolean remove(@Nullable Object o) {
            Multiset.Entry entry;
            int index;
            if (o instanceof Multiset.Entry && (index = AbstractObjectCountMap.this.indexOf((entry = (Multiset.Entry)o).getElement())) != -1 && AbstractObjectCountMap.this.values[index] == entry.getCount()) {
                AbstractObjectCountMap.this.removeEntry(index);
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return AbstractObjectCountMap.this.size;
        }
    }

    abstract class Itr<T>
    implements Iterator<T> {
        int expectedModCount;
        boolean nextCalled;
        int index;

        Itr() {
            this.expectedModCount = AbstractObjectCountMap.this.modCount;
            this.nextCalled = false;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < AbstractObjectCountMap.this.size;
        }

        abstract T getOutput(int var1);

        @Override
        public T next() {
            this.checkForConcurrentModification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.nextCalled = true;
            return this.getOutput(this.index++);
        }

        @Override
        public void remove() {
            this.checkForConcurrentModification();
            CollectPreconditions.checkRemove(this.nextCalled);
            ++this.expectedModCount;
            --this.index;
            AbstractObjectCountMap.this.removeEntry(this.index);
            this.nextCalled = false;
        }

        void checkForConcurrentModification() {
            if (AbstractObjectCountMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    class KeySetView
    extends Sets.ImprovedAbstractSet<K> {
        KeySetView() {
        }

        @Override
        public Object[] toArray() {
            return ObjectArrays.copyAsObjectArray(AbstractObjectCountMap.this.keys, 0, AbstractObjectCountMap.this.size);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return ObjectArrays.toArrayImpl(AbstractObjectCountMap.this.keys, 0, AbstractObjectCountMap.this.size, a);
        }

        @Override
        public Iterator<K> iterator() {
            return new Itr<K>(){

                @Override
                K getOutput(int entry) {
                    return AbstractObjectCountMap.this.keys[entry];
                }
            };
        }

        @Override
        public int size() {
            return AbstractObjectCountMap.this.size;
        }
    }
}

