/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.function.settings.AddMapSourceDialog;
import tim.prune.function.settings.MapSourceListModel;
import tim.prune.gui.map.MapSource;
import tim.prune.gui.map.MapSourceLibrary;

public class SetMapBgFunction
extends GenericFunction {
    private JDialog _dialog = null;
    private JList<String> _list = null;
    private MapSourceListModel _listModel = null;
    private String _initialSource = null;
    private JButton _okButton = null;
    private JButton _cancelButton = null;
    private JButton _deleteButton = null;
    private JButton _editButton = null;
    private AddMapSourceDialog _addDialog = null;
    private boolean _sourcesEdited = false;

    public SetMapBgFunction(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.setmapbg";
    }

    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this.initValues();
        this.enableButtons();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(8, 8));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.setmapbg.intro"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 4, 1, 4));
        jPanel.add((Component)jLabel, "North");
        this._listModel = new MapSourceListModel();
        this._list = new JList<String>(this._listModel);
        this._list.setSelectionMode(0);
        jPanel.add((Component)new JScrollPane(this._list), "Center");
        this._list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SetMapBgFunction.this.enableButtons();
            }
        });
        this._list.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                super.keyReleased(keyEvent);
                if (keyEvent.getKeyCode() == 27) {
                    SetMapBgFunction.this._dialog.dispose();
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JButton jButton = new JButton(I18nManager.getText("button.addnew"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetMapBgFunction.this.addNewSource();
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(Box.createVerticalStrut(5));
        this._editButton = new JButton(I18nManager.getText("button.edit"));
        this._editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetMapBgFunction.this.editMapSource();
            }
        });
        jPanel2.add(this._editButton);
        jPanel2.add(Box.createVerticalStrut(5));
        this._deleteButton = new JButton(I18nManager.getText("button.delete"));
        this._deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetMapBgFunction.this.deleteMapSource();
            }
        });
        jPanel2.add(this._deleteButton);
        jPanel.add((Component)jPanel2, "East");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetMapBgFunction.this.finish();
            }
        };
        this._okButton.addActionListener(actionListener);
        jPanel3.add(this._okButton);
        this._cancelButton = new JButton(I18nManager.getText("button.cancel"));
        this._cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetMapBgFunction.this._dialog.dispose();
            }
        });
        jPanel3.add(this._cancelButton);
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    private void initValues() {
        this.updateList();
        int n = Config.getConfigInt("prune.mapsource");
        if (n < 0 || n >= this._listModel.getSize()) {
            n = 0;
        }
        this._initialSource = this._listModel.getSource(n).getSiteStrings();
        this._list.setSelectedIndex(n);
        this._list.ensureIndexIsVisible(n);
        this._sourcesEdited = false;
    }

    private int getSelectedServer() {
        return this._list.getSelectedIndex();
    }

    private void enableButtons() {
        int n = this.getSelectedServer();
        this._okButton.setEnabled(n >= 0 && n < this._listModel.getSize() && (this._sourcesEdited || !this._listModel.getSource(n).getSiteStrings().equals(this._initialSource)));
        boolean bl = n >= MapSourceLibrary.getNumFixedSources() && n < this._listModel.getSize();
        this._editButton.setEnabled(bl);
        this._deleteButton.setEnabled(bl);
        this._cancelButton.setEnabled(!this._sourcesEdited);
    }

    private void addNewSource() {
        this.addSource(null);
    }

    private void addSource(MapSource mapSource) {
        if (this._addDialog == null) {
            this._addDialog = new AddMapSourceDialog(this._dialog, this);
        }
        this._addDialog.showDialog(mapSource);
    }

    private void deleteMapSource() {
        int n = this.getSelectedServer();
        MapSourceLibrary.deleteSource(n);
        this.updateList();
        this.enableButtons();
    }

    private void editMapSource() {
        this.addSource(this._listModel.getSource(this.getSelectedServer()));
    }

    public void updateList() {
        this._listModel.fireChanged();
        this._sourcesEdited = true;
        Config.setConfigString("prune.mapsourcelist", MapSourceLibrary.getConfigString());
        this.enableButtons();
    }

    private void finish() {
        int n = this.getSelectedServer();
        if (n < 0) {
            n = 0;
        }
        Config.setConfigInt("prune.mapsource", n);
        UpdateMessageBroker.informSubscribers((byte)64);
        this._dialog.dispose();
    }
}

