/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.transformations.inlining;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jruby.RubyModule;
import org.jruby.dirgra.Edge;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.Tuple;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.ModuleVersionGuardInstr;
import org.jruby.ir.instructions.YieldInstr;
import org.jruby.ir.interpreter.FullInterpreterContext;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class CFGInliner {
    public static final Logger LOG = LoggerFactory.getLogger(CFGInliner.class);
    private static final boolean debug = IRManager.IR_INLINER_VERBOSE;
    private final FullInterpreterContext fullInterpreterContext;
    private final CFG cfg;
    private final IRScope hostScope;

    public CFGInliner(FullInterpreterContext fullInterpreterContext) {
        this.fullInterpreterContext = fullInterpreterContext;
        this.cfg = fullInterpreterContext.getCFG();
        this.hostScope = this.cfg.getScope();
    }

    private SimpleCloneInfo cloneHostInstrs() {
        SimpleCloneInfo ii = new SimpleCloneInfo(this.hostScope, false);
        for (BasicBlock b2 : this.cfg.getBasicBlocks()) {
            b2.cloneInstrs(ii);
        }
        return ii;
    }

    private CFG cloneSelf(InlineCloneInfo ii) {
        CFG selfClone = new CFG(this.hostScope);
        for (BasicBlock b2 : this.cfg.getBasicBlocks()) {
            if (b2.isEntryBB() || b2.isExitBB()) continue;
            selfClone.addBasicBlock(b2.cloneForInlining(ii));
        }
        for (BasicBlock b2 : this.cfg.getBasicBlocks()) {
            if (b2.isEntryBB() || b2.isExitBB()) continue;
            BasicBlock rb = ii.getRenamedBB(b2);
            for (Edge<BasicBlock> e : this.cfg.getOutgoingEdges(b2)) {
                BasicBlock destination = e.getDestination().getData();
                if (destination.isExitBB()) continue;
                selfClone.addEdge(rb, ii.getRenamedBB(destination), e.getType());
            }
        }
        return selfClone;
    }

    private boolean isRecursiveInline(IRScope methodScope) {
        return this.hostScope.getNearestMethod() == methodScope;
    }

    private Variable getReceiverVariable(Operand receiver2) {
        return receiver2 instanceof Variable ? (Variable)receiver2 : this.hostScope.createTemporaryVariable();
    }

    public BasicBlock findCallsiteBB(CallBase call2) {
        long callSiteId = call2.getCallSiteId();
        if (debug) {
            LOG.info("LOOKING FOR CALLSITEID: " + callSiteId, new Object[0]);
        }
        for (BasicBlock bb : this.cfg.getBasicBlocks()) {
            for (Instr i2 : bb.getInstrs()) {
                if (!(i2 instanceof CallBase) || ((CallBase)i2).getCallSiteId() != callSiteId) continue;
                if (debug) {
                    LOG.info("Found it!!!! -- " + call2 + ", i: " + i2, new Object[0]);
                }
                return bb;
            }
        }
        if (debug) {
            LOG.info("Did not find it", new Object[0]);
        }
        return null;
    }

    private void printInlineDebugPrologue(IRScope scopeToInline, CallBase call2) {
        LOG.info("---------------------------------- PROLOGUE (start) --------", new Object[0]);
        LOG.info("Looking for: " + call2.getCallSiteId() + ":\n    > " + call2 + "\n", new Object[0]);
        this.printInlineCFG(this.cfg, "host of inline");
        LOG.info("method to inline cfg:\n" + scopeToInline.getCFG().toStringGraph(), new Object[0]);
        LOG.info("method to inline instrs:\n" + scopeToInline.getCFG().toStringInstrs(), new Object[0]);
        LOG.info("---------------------------------- PROLOGUE (end) -----------", new Object[0]);
    }

    private void printInlineFoundBB(BasicBlock bb) {
        LOG.info("---------------------------------- callBB (start) -----------", new Object[0]);
        LOG.info(bb.toStringInstrs(), new Object[0]);
        LOG.info("---------------------------------- callBB (end) -------------", new Object[0]);
    }

    private void printInlineCannotFindCallsiteBB(CallBase call2) {
        LOG.info("----------------------------------", new Object[0]);
        LOG.info("Did not find BB with call: " + call2, new Object[0]);
        this.printInlineCFG(this.cfg, "");
        LOG.info("----------------------------------", new Object[0]);
    }

    private void printInlineCFG(CFG aCFG, String label2) {
        LOG.info(label2 + " cfg:\n" + aCFG.toStringGraph(), new Object[0]);
        LOG.info(label2 + " instrs:\n" + aCFG.toStringInstrs(), new Object[0]);
    }

    private void printInlineEpilogue() {
        LOG.info("---------------------------------- EPILOGUE (start) --------", new Object[0]);
        this.printInlineCFG(this.cfg, "");
        LOG.info("---------------------------------- EPILOGUE (end) -----------", new Object[0]);
    }

    private void printInlineSplitBBs(BasicBlock beforeBB, BasicBlock afterBB) {
        LOG.info("---------------------------------- SPLIT BB (start) --------", new Object[0]);
        LOG.info("Before:" + beforeBB.getLabel(), new Object[0]);
        LOG.info(beforeBB.toStringInstrs(), new Object[0]);
        LOG.info("After:" + afterBB.getLabel(), new Object[0]);
        LOG.info(afterBB.toStringInstrs(), new Object[0]);
        this.printInlineCFG(this.cfg, "");
        LOG.info("---------------------------------- SPLIT BB (end) -----------", new Object[0]);
    }

    public String inlineMethod(IRScope scopeToInline, RubyModule implClass, int classToken, BasicBlock callBB, CallBase call2, boolean cloneHost) {
        if (this.isRecursiveInline(scopeToInline)) {
            return "cannot inline recursive scopes";
        }
        if (debug) {
            this.printInlineDebugPrologue(scopeToInline, call2);
        }
        if (callBB == null) {
            callBB = this.findCallsiteBB(call2);
            if (callBB == null) {
                if (debug) {
                    this.printInlineCannotFindCallsiteBB(call2);
                }
                return "cannot find callsite in host scope: " + call2;
            }
            if (debug) {
                this.printInlineFoundBB(callBB);
            }
        }
        Label splitBBLabel = this.hostScope.getNewLabel();
        BasicBlock afterInlineBB = callBB.splitAtInstruction(call2, splitBBLabel, false);
        BasicBlock beforeInlineBB = callBB;
        this.connectOuterEdges(beforeInlineBB, afterInlineBB);
        if (debug) {
            this.printInlineSplitBBs(beforeInlineBB, afterInlineBB);
        }
        SimpleCloneInfo hostCloneInfo = cloneHost ? this.cloneHostInstrs() : null;
        Variable callReceiverVar = this.getReceiverVariable(call2.getReceiver());
        InlineCloneInfo ii = new InlineCloneInfo(call2, this.cfg, callReceiverVar, scopeToInline);
        CFG methodToInline = scopeToInline.getCFG();
        ArrayList<BasicBlock> methodBBs = new ArrayList<BasicBlock>(methodToInline.getBasicBlocks());
        if (this.isRecursiveInline(scopeToInline)) {
            Iterator<Object> selfClone = this.cloneSelf(ii);
            for (BasicBlock b2 : ((CFG)((Object)selfClone)).getBasicBlocks()) {
                this.cfg.addBasicBlock(b2);
                for (Edge<BasicBlock> e : ((CFG)((Object)selfClone)).getOutgoingEdges(b2)) {
                    this.cfg.addEdge(b2, e.getDestination().getData(), e.getType());
                }
            }
        } else {
            for (BasicBlock basicBlock : methodToInline.getBasicBlocks()) {
                if (basicBlock.isEntryBB() || basicBlock.isExitBB()) continue;
                this.cfg.addBasicBlock(basicBlock.cloneForInlining(ii));
            }
            for (BasicBlock basicBlock : methodToInline.getBasicBlocks()) {
                if (basicBlock.isEntryBB() || basicBlock.isExitBB()) continue;
                BasicBlock rx = ii.getRenamedBB(basicBlock);
                for (Edge<BasicBlock> e : methodToInline.getOutgoingEdges(basicBlock)) {
                    BasicBlock b4 = e.getDestination().getData();
                    if (b4.isExitBB()) continue;
                    this.cfg.addEdge(rx, ii.getRenamedBB(b4), e.getType());
                }
            }
        }
        assert (methodToInline.outDegree(methodToInline.getEntryBB()) == 2) : "Entry BB of inlinee method does not have outdegree 2: " + methodToInline.toStringGraph();
        for (BasicBlock basicBlock : methodToInline.getOutgoingDestinations(methodToInline.getEntryBB())) {
            if (basicBlock.isExitBB()) continue;
            BasicBlock dstBB = ii.getRenamedBB(basicBlock);
            if (call2.getReceiver() != callReceiverVar) {
                dstBB.insertInstr(new CopyInstr(callReceiverVar, call2.getReceiver()));
            }
            if (!ii.canMapArgsStatically()) {
                return "cannot assign non-statically assigned method arguments";
            }
            this.cfg.addEdge(beforeInlineBB, dstBB, (Object)CFG.EdgeType.FALL_THROUGH);
        }
        for (Edge edge : methodToInline.getIncomingEdges(methodToInline.getExitBB())) {
            BasicBlock source2 = (BasicBlock)edge.getSource().getData();
            if (source2.isEntryBB()) continue;
            BasicBlock clonedSource = ii.getRenamedBB(source2);
            if (edge.getType() == CFG.EdgeType.EXCEPTION) {
                BasicBlock rescuerOfSplitBB = this.cfg.getRescuerBBFor(afterInlineBB);
                if (rescuerOfSplitBB != null) {
                    this.cfg.addEdge(clonedSource, rescuerOfSplitBB, (Object)CFG.EdgeType.EXCEPTION);
                    continue;
                }
                this.cfg.addEdge(clonedSource, this.cfg.getExitBB(), (Object)CFG.EdgeType.EXIT);
                continue;
            }
            this.cfg.addEdge(clonedSource, afterInlineBB, edge.getType());
        }
        BasicBlock callBBrescuer = this.cfg.getRescuerBBFor(beforeInlineBB);
        if (callBBrescuer != null) {
            this.cfg.setRescuerBB(afterInlineBB, callBBrescuer);
        }
        for (BasicBlock x : methodBBs) {
            if (x.isEntryBB() || x.isExitBB()) continue;
            BasicBlock xRenamed = ii.getRenamedBB(x);
            BasicBlock xProtector = methodToInline.getRescuerBBFor(x);
            if (xProtector != null) {
                this.cfg.setRescuerBB(xRenamed, ii.getRenamedBB(xProtector));
                continue;
            }
            if (callBBrescuer == null) continue;
            this.cfg.setRescuerBB(xRenamed, callBBrescuer);
        }
        this.fullInterpreterContext.generateInstructionsForInterpretation();
        Label label2 = this.hostScope.getNewLabel();
        beforeInlineBB.addInstr(new ModuleVersionGuardInstr(implClass, classToken, call2.getReceiver(), label2));
        BasicBlock failurePathBB = new BasicBlock(this.cfg, label2);
        this.cfg.addBasicBlock(failurePathBB);
        failurePathBB.addInstr(call2);
        failurePathBB.addInstr(new JumpInstr(hostCloneInfo == null ? splitBBLabel : hostCloneInfo.getRenamedLabel(splitBBLabel)));
        call2.blockInlining();
        this.cfg.addEdge(beforeInlineBB, failurePathBB, (Object)CFG.EdgeType.REGULAR);
        this.cfg.addEdge(failurePathBB, afterInlineBB, (Object)CFG.EdgeType.REGULAR);
        Operand closureArg = call2.getClosureArg(null);
        List yieldSites = ii.getYieldSites();
        if (closureArg != null && !yieldSites.isEmpty()) {
            if (yieldSites.size() > 1) {
                return "cannot inline a scope with two or more yields";
            }
            if (!(closureArg instanceof WrappedIRClosure)) {
                throw new RuntimeException("Encountered a dynamic closure arg.  Cannot inline it here!  Convert the yield to a call by converting the closure into a dummy method (have to convert all frame vars to call arguments, or at least convert the frame into a call arg");
            }
            Tuple t = (Tuple)yieldSites.get(0);
            this.inlineClosureAtYieldSite(ii, ((WrappedIRClosure)closureArg).getClosure(), (BasicBlock)t.a, (YieldInstr)t.b);
        }
        ArrayList<BasicBlock> returnBBs = new ArrayList<BasicBlock>();
        for (BasicBlock basicBlock : this.cfg.getBasicBlocks()) {
            for (Instr instr : basicBlock.getInstrs()) {
                if (!instr.getOperation().isReturn()) continue;
                returnBBs.add(basicBlock);
            }
        }
        this.cfg.optimize(returnBBs);
        this.addMissingJumps();
        if (debug) {
            this.printInlineEpilogue();
        }
        return null;
    }

    private void addMissingJumps() {
        for (BasicBlock bb : this.cfg.getBasicBlocks()) {
            Instr lastInstr;
            boolean fallThrough = false;
            Label jumpLabel = null;
            for (Edge<BasicBlock> edge : this.cfg.getOutgoingEdges(bb)) {
                if (edge.getType() == CFG.EdgeType.FALL_THROUGH) {
                    fallThrough = true;
                    continue;
                }
                if (edge.getType() != CFG.EdgeType.REGULAR && edge.getType() != CFG.EdgeType.EXIT || fallThrough) continue;
                jumpLabel = edge.getDestination().getData().getLabel();
            }
            if (fallThrough || jumpLabel == null || (lastInstr = bb.getLastInstr()) == null || lastInstr.transfersControl()) continue;
            bb.addInstr(new JumpInstr(jumpLabel));
        }
    }

    private void connectOuterEdges(BasicBlock beforeInlineBB, BasicBlock afterInlineBB) {
        this.cfg.addBasicBlock(afterInlineBB);
        for (Edge<BasicBlock> e : this.cfg.getOutgoingEdges(beforeInlineBB)) {
            this.cfg.addEdge(afterInlineBB, e.getDestination().getData(), e.getType());
        }
        this.cfg.removeAllOutgoingEdgesForBB(beforeInlineBB);
    }

    private void inlineClosureAtYieldSite(InlineCloneInfo ii, IRClosure cl, BasicBlock yieldBB, YieldInstr yield2) {
        BasicBlock afterInlineBB = yieldBB.splitAtInstruction(yield2, this.hostScope.getNewLabel(), false);
        BasicBlock beforeInlineBB = yieldBB;
        this.connectOuterEdges(beforeInlineBB, afterInlineBB);
        if (debug) {
            this.printInlineSplitBBs(beforeInlineBB, afterInlineBB);
        }
        ii = ii.cloneForInliningClosure(cl);
        ii.setupYieldArgsAndYieldResult(yield2, beforeInlineBB, cl.getBlockBody().getSignature().arityValue());
        CFG closureCFG = cl.getCFG();
        BasicBlock closureGEB = closureCFG.getGlobalEnsureBB();
        for (BasicBlock basicBlock : closureCFG.getBasicBlocks()) {
            if (basicBlock.isEntryBB() || basicBlock.isExitBB() || basicBlock == closureGEB) continue;
            this.cfg.addBasicBlock(basicBlock.cloneForInlining(ii));
        }
        for (BasicBlock basicBlock : closureCFG.getBasicBlocks()) {
            if (basicBlock.isEntryBB() || basicBlock.isExitBB()) continue;
            BasicBlock bClone = ii.getRenamedBB(basicBlock);
            for (Edge<BasicBlock> e : closureCFG.getOutgoingEdges(basicBlock)) {
                BasicBlock edst = e.getDestination().getData();
                if (edst.isExitBB() || edst == closureGEB) continue;
                this.cfg.addEdge(bClone, ii.getRenamedBB(edst), e.getType());
            }
        }
        for (Edge edge : closureCFG.getOutgoingEdges(closureCFG.getEntryBB())) {
            BasicBlock destination = (BasicBlock)edge.getDestination().getData();
            if (destination.isExitBB() || destination == closureGEB) continue;
            this.cfg.addEdge(beforeInlineBB, ii.getRenamedBB(destination), (Object)CFG.EdgeType.FALL_THROUGH);
        }
        for (Edge edge : closureCFG.getIncomingEdges(closureCFG.getExitBB())) {
            BasicBlock source2 = (BasicBlock)edge.getSource().getData();
            if (source2.isEntryBB()) continue;
            BasicBlock clonedSource = ii.getRenamedBB(source2);
            if (edge.getType() == CFG.EdgeType.EXCEPTION) {
                BasicBlock rescuerOfSplitBB = this.cfg.getRescuerBBFor(afterInlineBB);
                if (rescuerOfSplitBB != null) {
                    this.cfg.addEdge(clonedSource, rescuerOfSplitBB, (Object)CFG.EdgeType.EXCEPTION);
                    continue;
                }
                this.cfg.addEdge(clonedSource, this.cfg.getExitBB(), (Object)CFG.EdgeType.EXIT);
                continue;
            }
            if (source2 == closureGEB) continue;
            this.cfg.addEdge(clonedSource, afterInlineBB, edge.getType());
        }
        BasicBlock yieldBBrescuer = this.cfg.getRescuerBBFor(beforeInlineBB);
        if (yieldBBrescuer != null) {
            this.cfg.setRescuerBB(afterInlineBB, yieldBBrescuer);
        }
        for (BasicBlock cb : closureCFG.getBasicBlocks()) {
            if (cb.isEntryBB() || cb.isExitBB() || cb == closureGEB) continue;
            BasicBlock cbProtector = ii.getRenamedBB(closureCFG.getRescuerBBFor(cb));
            if (cbProtector != null) {
                this.cfg.setRescuerBB(ii.getRenamedBB(cb), cbProtector);
                continue;
            }
            if (yieldBBrescuer == null) continue;
            this.cfg.setRescuerBB(ii.getRenamedBB(cb), yieldBBrescuer);
        }
    }
}

