/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.ivy.util.url.URLHandler;

public abstract class AbstractURLHandler
implements URLHandler {
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("%25([0-9a-fA-F][0-9a-fA-F])");
    private static int requestMethod = 2;

    @Override
    public boolean isReachable(URL uRL) {
        return this.getURLInfo(uRL).isReachable();
    }

    @Override
    public boolean isReachable(URL uRL, int n) {
        return this.getURLInfo(uRL, n).isReachable();
    }

    @Override
    public long getContentLength(URL uRL) {
        return this.getURLInfo(uRL).getContentLength();
    }

    @Override
    public long getContentLength(URL uRL, int n) {
        return this.getURLInfo(uRL, n).getContentLength();
    }

    @Override
    public long getLastModified(URL uRL) {
        return this.getURLInfo(uRL).getLastModified();
    }

    @Override
    public long getLastModified(URL uRL, int n) {
        return this.getURLInfo(uRL, n).getLastModified();
    }

    protected void validatePutStatusCode(URL uRL, int n, String string) throws IOException {
        switch (n) {
            case 200: 
            case 201: 
            case 202: 
            case 204: {
                break;
            }
            case 401: 
            case 403: {
                throw new IOException("Access to URL " + uRL + " was refused by the server" + (string == null ? "" : ": " + string));
            }
            default: {
                throw new IOException("PUT operation to URL " + uRL + " failed with status code " + n + (string == null ? "" : ": " + string));
            }
        }
    }

    @Override
    public void setRequestMethod(int n) {
        requestMethod = n;
    }

    public int getRequestMethod() {
        return requestMethod;
    }

    protected String normalizeToString(URL uRL) throws IOException {
        if (!"http".equals(uRL.getProtocol()) && !"https".equals(uRL.getProtocol())) {
            return uRL.toExternalForm();
        }
        try {
            URI uRI = new URI(uRL.getProtocol(), uRL.getAuthority(), uRL.getPath(), uRL.getQuery(), uRL.getRef());
            String string = uRI.normalize().toASCIIString();
            string = string.replaceAll("\\+", "%2B");
            return ESCAPE_PATTERN.matcher(string).replaceAll("%$1");
        }
        catch (URISyntaxException uRISyntaxException) {
            MalformedURLException malformedURLException = new MalformedURLException("Couldn't convert '" + uRL.toString() + "' to a valid URI");
            malformedURLException.initCause(uRISyntaxException);
            throw malformedURLException;
        }
    }

    protected URL normalizeToURL(URL uRL) throws IOException {
        if (!"http".equals(uRL.getProtocol()) && !"https".equals(uRL.getProtocol())) {
            return uRL;
        }
        return new URL(this.normalizeToString(uRL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getDecodingInputStream(String string, InputStream inputStream) throws IOException {
        InputStream inputStream2 = null;
        if ("gzip".equals(string) || "x-gzip".equals(string)) {
            inputStream2 = new GZIPInputStream(inputStream);
        } else if ("deflate".equals(string)) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            bufferedInputStream.mark(100);
            byte[] byArray = new byte[100];
            int n = bufferedInputStream.read(byArray);
            bufferedInputStream.reset();
            Inflater inflater = new Inflater();
            inflater.setInput(byArray, 0, n);
            try {
                inflater.inflate(new byte[1000]);
                inputStream2 = new InflaterInputStream(bufferedInputStream);
            }
            catch (DataFormatException dataFormatException) {
                inputStream2 = new InflaterInputStream(bufferedInputStream, new Inflater(true));
            }
            finally {
                inflater.end();
            }
        } else {
            inputStream2 = inputStream;
        }
        return inputStream2;
    }
}

