/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.io;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import sbt.internal.io.MilliNative;

public final class WinMilli$
extends MilliNative<WinBase.FILETIME> {
    public static WinMilli$ MODULE$;

    static {
        new WinMilli$();
    }

    private WinNT.HANDLE getHandle(String lpFileName, int dwDesiredAccess, int dwShareMode) {
        WinNT.HANDLE hFile;
        WinNT.HANDLE hANDLE = hFile = Kernel32.INSTANCE.CreateFile(new StringBuilder(4).append("\\\\?\\").append(lpFileName).toString(), dwDesiredAccess, dwShareMode, null, 3, 0x2000000, null);
        WinNT.HANDLE hANDLE2 = WinBase.INVALID_HANDLE_VALUE;
        if (!(hANDLE != null ? !hANDLE.equals(hANDLE2) : hANDLE2 != null)) {
            int err = Kernel32.INSTANCE.GetLastError();
            if (err == 2 || err == 3) {
                throw new FileNotFoundException(new StringBuilder(11).append("Not found: ").append(lpFileName).toString());
            }
            if (err == 5) {
                throw new FileNotFoundException(new StringBuilder(15).append("Access denied: ").append(lpFileName).toString());
            }
            throw new IOException(new StringBuilder(31).append("CreateFile() failed with error ").append(Kernel32.INSTANCE.GetLastError()).toString());
        }
        return hFile;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public WinBase.FILETIME getModifiedTimeNative(String filePath) {
        void var3_5;
        WinBase.FILETIME.ByReference byReference;
        WinNT.HANDLE hFile = this.getHandle(filePath, 128, 7);
        try {
            WinBase.FILETIME.ByReference modifiedTime = new WinBase.FILETIME.ByReference();
            if (!Kernel32.INSTANCE.GetFileTime(hFile, null, null, (WinBase.FILETIME)modifiedTime)) {
                throw new IOException(new StringBuilder(42).append("GetFileTime() failed with error ").append(Kernel32.INSTANCE.GetLastError()).append(" for file ").append(filePath).toString());
            }
            byReference = modifiedTime;
        }
        finally {
            if (!Kernel32.INSTANCE.CloseHandle(hFile)) {
                throw new IOException(new StringBuilder(62).append("CloseHandle() after GetFileTime() failed with error ").append(Kernel32.INSTANCE.GetLastError()).append(" for file ").append(filePath).toString());
            }
        }
        WinBase.FILETIME.ByReference mtime = byReference;
        return var3_5;
    }

    @Override
    public void setModifiedTimeNative(String filePath, WinBase.FILETIME fileTime) {
        WinNT.HANDLE hFile = this.getHandle(filePath, 256, 7);
        try {
            if (Kernel32.INSTANCE.SetFileTime(hFile, null, null, fileTime) == 0) {
                throw new IOException(new StringBuilder(42).append("SetFileTime() failed with error ").append(Kernel32.INSTANCE.GetLastError()).append(" for file ").append(filePath).toString());
            }
        }
        finally {
            if (!Kernel32.INSTANCE.CloseHandle(hFile)) {
                throw new IOException(new StringBuilder(62).append("CloseHandle() after SetFileTime() failed with error ").append(Kernel32.INSTANCE.GetLastError()).append(" for file ").append(filePath).toString());
            }
        }
    }

    @Override
    public long fromNative(WinBase.FILETIME mtimeNative) {
        return mtimeNative.toTime();
    }

    @Override
    public WinBase.FILETIME toNative(long mtime) {
        return new WinBase.FILETIME(new Date(mtime));
    }

    private WinMilli$() {
        MODULE$ = this;
    }
}

