/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model.ivy;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.model.AbstractLazyModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.DefaultConfigurationMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.external.model.ivy.DefaultMutableIvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.ivy.IvyConfigurationHelper;
import org.gradle.internal.component.external.model.ivy.IvyDependencyDescriptor;
import org.gradle.internal.component.external.model.ivy.IvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.ivy.MutableIvyModuleResolveMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.util.CollectionUtils;

public class DefaultIvyModuleResolveMetadata
extends AbstractLazyModuleComponentResolveMetadata
implements IvyModuleResolveMetadata {
    private final ImmutableMap<String, Configuration> configurationDefinitions;
    private final ImmutableList<IvyDependencyDescriptor> dependencies;
    private final ImmutableList<Artifact> artifactDefinitions;
    private final ImmutableList<Exclude> excludes;
    private final ImmutableMap<NamespaceId, String> extraAttributes;
    private final String branch;
    private Map<Artifact, ModuleComponentArtifactMetadata> artifacts;

    DefaultIvyModuleResolveMetadata(DefaultMutableIvyModuleResolveMetadata metadata) {
        super(metadata);
        this.configurationDefinitions = metadata.getConfigurationDefinitions();
        this.branch = metadata.getBranch();
        this.artifactDefinitions = metadata.getArtifactDefinitions();
        this.dependencies = metadata.getDependencies();
        this.excludes = metadata.getExcludes();
        this.extraAttributes = metadata.getExtraAttributes();
    }

    private DefaultIvyModuleResolveMetadata(DefaultIvyModuleResolveMetadata metadata, ModuleSource source) {
        super(metadata, source);
        this.configurationDefinitions = metadata.configurationDefinitions;
        this.branch = metadata.branch;
        this.artifactDefinitions = metadata.artifactDefinitions;
        this.dependencies = metadata.dependencies;
        this.excludes = metadata.excludes;
        this.extraAttributes = metadata.extraAttributes;
        this.copyCachedState(metadata);
    }

    private DefaultIvyModuleResolveMetadata(DefaultIvyModuleResolveMetadata metadata, List<IvyDependencyDescriptor> dependencies) {
        super(metadata, metadata.getSource());
        this.configurationDefinitions = metadata.configurationDefinitions;
        this.branch = metadata.branch;
        this.artifactDefinitions = metadata.artifactDefinitions;
        this.dependencies = ImmutableList.copyOf(dependencies);
        this.excludes = metadata.excludes;
        this.extraAttributes = metadata.extraAttributes;
    }

    @Override
    protected DefaultConfigurationMetadata createConfiguration(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableSet<String> hierarchy, VariantMetadataRules componentMetadataRules) {
        if (this.artifacts == null) {
            this.artifacts = new IdentityHashMap<Artifact, ModuleComponentArtifactMetadata>();
        }
        IvyConfigurationHelper configurationHelper = new IvyConfigurationHelper(this.artifactDefinitions, this.artifacts, this.excludes, this.dependencies, componentId);
        ImmutableList<ModuleComponentArtifactMetadata> artifacts = configurationHelper.filterArtifacts(name, (Collection<String>)hierarchy);
        ImmutableList<ExcludeMetadata> excludesForConfiguration = configurationHelper.filterExcludes(hierarchy);
        DefaultConfigurationMetadata configuration = new DefaultConfigurationMetadata(componentId, name, transitive, visible, hierarchy, (ImmutableList<? extends ModuleComponentArtifactMetadata>)ImmutableList.copyOf(artifacts), componentMetadataRules, excludesForConfiguration, this.getAttributes().asImmutable());
        configuration.setDependencies((List<ModuleDependencyMetadata>)configurationHelper.filterDependencies(configuration));
        return configuration;
    }

    @Override
    public DefaultIvyModuleResolveMetadata withSource(ModuleSource source) {
        return new DefaultIvyModuleResolveMetadata(this, source);
    }

    @Override
    public MutableIvyModuleResolveMetadata asMutable() {
        return new DefaultMutableIvyModuleResolveMetadata(this);
    }

    @Override
    public ImmutableMap<String, Configuration> getConfigurationDefinitions() {
        return this.configurationDefinitions;
    }

    @Override
    public ImmutableList<Artifact> getArtifactDefinitions() {
        return this.artifactDefinitions;
    }

    @Override
    public ImmutableList<Exclude> getExcludes() {
        return this.excludes;
    }

    @Override
    public String getBranch() {
        return this.branch;
    }

    @Override
    public ImmutableMap<NamespaceId, String> getExtraAttributes() {
        return this.extraAttributes;
    }

    @Override
    public IvyModuleResolveMetadata withDynamicConstraintVersions() {
        List transformed = CollectionUtils.collect(this.getDependencies(), (Transformer)new Transformer<IvyDependencyDescriptor, IvyDependencyDescriptor>(){

            public IvyDependencyDescriptor transform(IvyDependencyDescriptor dependency) {
                ModuleComponentSelector selector = dependency.getSelector();
                String dynamicConstraintVersion = dependency.getDynamicConstraintVersion();
                ModuleComponentSelector newSelector = DefaultModuleComponentSelector.newSelector(selector.getModuleIdentifier(), dynamicConstraintVersion);
                return dependency.withRequested(newSelector);
            }
        });
        return this.withDependencies(transformed);
    }

    private IvyModuleResolveMetadata withDependencies(List<IvyDependencyDescriptor> transformed) {
        return new DefaultIvyModuleResolveMetadata(this, transformed);
    }

    @Override
    public ImmutableList<IvyDependencyDescriptor> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultIvyModuleResolveMetadata that = (DefaultIvyModuleResolveMetadata)o;
        return Objects.equal(this.dependencies, that.dependencies) && Objects.equal(this.artifactDefinitions, that.artifactDefinitions) && Objects.equal(this.excludes, that.excludes) && Objects.equal(this.extraAttributes, that.extraAttributes) && Objects.equal((Object)this.branch, (Object)that.branch) && Objects.equal(this.artifacts, that.artifacts);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.dependencies, this.artifactDefinitions, this.excludes, this.extraAttributes, this.branch, this.artifacts});
    }
}

