/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.conversion.CoordinateFormatManager;
import org.openstreetmap.josm.data.coor.conversion.LatLonParser;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class LatLonDialog
extends ExtendedDialog {
    private static final Color BG_COLOR_ERROR = new Color(255, 224, 224);
    public JTabbedPane tabs;
    private JosmTextField tfLatLon;
    private JosmTextField tfEastNorth;
    private LatLon latLonCoordinates;
    private EastNorth eastNorthCoordinates;

    protected JPanel buildLatLon() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnl.add((Component)new JLabel(I18n.tr("Coordinates:", new Object[0])), GBC.std().insets(0, 10, 5, 0));
        this.tfLatLon = new JosmTextField(24);
        pnl.add((Component)this.tfLatLon, GBC.eol().insets(0, 10, 0, 0).fill(2).weight(1.0, 0.0));
        pnl.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
        pnl.add((Component)new HtmlPanel(Utils.join("<br/>", Arrays.asList(I18n.tr("Enter the coordinates for the new node.", new Object[0]), I18n.tr("You can separate longitude and latitude with space, comma or semicolon.", new Object[0]), I18n.tr("Use positive numbers or N, E characters to indicate North or East cardinal direction.", new Object[0]), I18n.tr("For South and West cardinal directions you can use either negative numbers or S, W characters.", new Object[0]), I18n.tr("Coordinate value can be in one of three formats:", new Object[0]))) + Utils.joinAsHtmlUnorderedList(Arrays.asList(I18n.tr("<i>degrees</i><tt>&deg;</tt>", new Object[0]), I18n.tr("<i>degrees</i><tt>&deg;</tt> <i>minutes</i><tt>&#39;</tt>", new Object[0]), I18n.tr("<i>degrees</i><tt>&deg;</tt> <i>minutes</i><tt>&#39;</tt> <i>seconds</i><tt>&quot</tt>", new Object[0]))) + Utils.join("<br/><br/>", Arrays.asList(I18n.tr("Symbols <tt>&deg;</tt>, <tt>&#39;</tt>, <tt>&prime;</tt>, <tt>&quot;</tt>, <tt>&Prime;</tt> are optional.", new Object[0]), I18n.tr("You can also use the syntax <tt>lat=\"...\" lon=\"...\"</tt> or <tt>lat=''...'' lon=''...''</tt>.", new Object[0]), I18n.tr("Some examples:", new Object[0]))) + "<table><tr><td>" + Utils.joinAsHtmlUnorderedList(Arrays.asList("49.29918 19.24788", "49.29918, 19.24788", "49.29918&deg; 19.24788&deg;", "N 49.29918 E 19.24788", "W 49&deg;29.918&#39; S 19&deg;24.788&#39;", "N 49&deg;29&#39;04&quot; E 19&deg;24&#39;43&quot;", "49.29918 N, 19.24788 E", "49&deg;29&#39;21&quot; N 19&deg;24&#39;38&quot; E", "49 29 51, 19 24 18", "49 29, 19 24")) + "</td><td>" + Utils.joinAsHtmlUnorderedList(Arrays.asList("E 49 29, N 19 24", "49&deg; 29; 19&deg; 24", "N 49&deg; 29, W 19&deg; 24", "49&deg; 29.5 S, 19&deg; 24.6 E", "N 49 29.918 E 19 15.88", "49 29.4 19 24.5", "-49 29.4 N -19 24.5 W", "48 deg 42&#39; 52.13\" N, 21 deg 11&#39; 47.60\" E", "lat=\"49.29918\" lon=\"19.24788\"", "lat='49.29918' lon='19.24788'")) + "</td></tr></table>"), GBC.eol().fill().weight(1.0, 1.0));
        LatLonInputVerifier inputVerifier = new LatLonInputVerifier();
        this.tfLatLon.getDocument().addDocumentListener(inputVerifier);
        TextFieldFocusHandler focusHandler = new TextFieldFocusHandler();
        this.tfLatLon.addFocusListener(focusHandler);
        return pnl;
    }

    private JPanel buildEastNorth() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnl.add((Component)new JLabel(I18n.tr("Projected coordinates:", new Object[0])), GBC.std().insets(0, 10, 5, 0));
        this.tfEastNorth = new JosmTextField(24);
        pnl.add((Component)this.tfEastNorth, GBC.eol().insets(0, 10, 0, 0).fill(2).weight(1.0, 0.0));
        pnl.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
        pnl.add((Component)new HtmlPanel(I18n.tr("Enter easting and northing (x and y) separated by space, comma or semicolon.", new Object[0])), GBC.eol().fill(2));
        pnl.add(GBC.glue(1, 1), GBC.eol().fill().weight(1.0, 1.0));
        EastNorthInputVerifier inputVerifier = new EastNorthInputVerifier();
        this.tfEastNorth.getDocument().addDocumentListener(inputVerifier);
        TextFieldFocusHandler focusHandler = new TextFieldFocusHandler();
        this.tfEastNorth.addFocusListener(focusHandler);
        return pnl;
    }

    protected void build() {
        this.tabs = new JTabbedPane();
        this.tabs.addTab(I18n.tr("Lat/Lon", new Object[0]), this.buildLatLon());
        this.tabs.addTab(I18n.tr("East/North", new Object[0]), this.buildEastNorth());
        this.tabs.getModel().addChangeListener(e -> {
            switch (this.tabs.getModel().getSelectedIndex()) {
                case 0: {
                    this.parseLatLonUserInput();
                    break;
                }
                case 1: {
                    this.parseEastNorthUserInput();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        });
        this.setContent(this.tabs, false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                LatLonDialog.this.tfLatLon.requestFocusInWindow();
            }
        });
    }

    public LatLonDialog(Component parent, String title, String help) {
        super(parent, title, I18n.tr("Ok", new Object[0]), I18n.tr("Cancel", new Object[0]));
        this.setButtonIcons("ok", "cancel");
        this.configureContextsensitiveHelp(help, true);
        this.build();
        this.setCoordinates(null);
    }

    public boolean isLatLon() {
        return this.tabs.getModel().getSelectedIndex() == 0;
    }

    public void setCoordinates(LatLon ll) {
        LatLon llc = Optional.ofNullable(ll).orElse(LatLon.ZERO);
        this.tfLatLon.setText(CoordinateFormatManager.getDefaultFormat().latToString(llc) + ' ' + CoordinateFormatManager.getDefaultFormat().lonToString(llc));
        EastNorth en = ProjectionRegistry.getProjection().latlon2eastNorth(llc);
        this.tfEastNorth.setText(Double.toString(en.east()) + ' ' + Double.toString(en.north()));
        this.latLonCoordinates = llc;
        this.eastNorthCoordinates = en;
        this.setOkEnabled(true);
    }

    public LatLon getCoordinates() {
        if (this.isLatLon()) {
            return this.latLonCoordinates;
        }
        if (this.eastNorthCoordinates == null) {
            return null;
        }
        return ProjectionRegistry.getProjection().eastNorth2latlon(this.eastNorthCoordinates);
    }

    public LatLon getLatLonCoordinates() {
        return this.latLonCoordinates;
    }

    public EastNorth getEastNorthCoordinates() {
        return this.eastNorthCoordinates;
    }

    protected void setErrorFeedback(JosmTextField tf, String message) {
        tf.setBorder(BorderFactory.createLineBorder(Color.RED, 1));
        tf.setToolTipText(message);
        tf.setBackground(BG_COLOR_ERROR);
    }

    protected void clearErrorFeedback(JosmTextField tf, String message) {
        tf.setBorder(UIManager.getBorder("TextField.border"));
        tf.setToolTipText(message);
        tf.setBackground(UIManager.getColor("TextField.background"));
    }

    protected void parseLatLonUserInput() {
        LatLon latLon;
        try {
            latLon = LatLonParser.parse(this.tfLatLon.getText());
            if (!LatLon.isValidLat(latLon.lat()) || !LatLon.isValidLon(latLon.lon())) {
                latLon = null;
            }
        }
        catch (IllegalArgumentException e) {
            Logging.trace(e);
            latLon = null;
        }
        if (latLon == null) {
            this.setErrorFeedback(this.tfLatLon, I18n.tr("Please enter a GPS coordinates", new Object[0]));
            this.latLonCoordinates = null;
            this.setOkEnabled(false);
        } else {
            this.clearErrorFeedback(this.tfLatLon, I18n.tr("Please enter a GPS coordinates", new Object[0]));
            this.latLonCoordinates = latLon;
            this.setOkEnabled(true);
        }
    }

    protected void parseEastNorthUserInput() {
        EastNorth en;
        try {
            en = LatLonDialog.parseEastNorth(this.tfEastNorth.getText());
        }
        catch (IllegalArgumentException e) {
            Logging.trace(e);
            en = null;
        }
        if (en == null) {
            this.setErrorFeedback(this.tfEastNorth, I18n.tr("Please enter a Easting and Northing", new Object[0]));
            this.latLonCoordinates = null;
            this.setOkEnabled(false);
        } else {
            this.clearErrorFeedback(this.tfEastNorth, I18n.tr("Please enter a Easting and Northing", new Object[0]));
            this.eastNorthCoordinates = en;
            this.setOkEnabled(true);
        }
    }

    private void setOkEnabled(boolean b) {
        if (this.buttons != null && !this.buttons.isEmpty()) {
            ((JButton)this.buttons.get(0)).setEnabled(b);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        String preferenceKey = this.getClass().getName() + ".geometry";
        if (visible) {
            new WindowGeometry(preferenceKey, WindowGeometry.centerInWindow(this.getParent(), this.getSize())).applySafe(this);
        } else {
            new WindowGeometry(this).remember(preferenceKey);
        }
        super.setVisible(visible);
    }

    public static EastNorth parseEastNorth(String s) {
        String[] en = s.split("[;, ]+");
        if (en.length != 2) {
            return null;
        }
        try {
            double east = Double.parseDouble(en[0]);
            double north = Double.parseDouble(en[1]);
            return new EastNorth(east, north);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public String getLatLonText() {
        return this.tfLatLon.getText();
    }

    public void setLatLonText(String text) {
        this.tfLatLon.setText(text);
    }

    public String getEastNorthText() {
        return this.tfEastNorth.getText();
    }

    public void setEastNorthText(String text) {
        this.tfEastNorth.setText(text);
    }

    static class TextFieldFocusHandler
    implements FocusListener {
        TextFieldFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Component c = e.getComponent();
            if (c instanceof JosmTextField) {
                JosmTextField tf = (JosmTextField)c;
                tf.selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    class EastNorthInputVerifier
    implements DocumentListener {
        EastNorthInputVerifier() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            LatLonDialog.this.parseEastNorthUserInput();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            LatLonDialog.this.parseEastNorthUserInput();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            LatLonDialog.this.parseEastNorthUserInput();
        }
    }

    class LatLonInputVerifier
    implements DocumentListener {
        LatLonInputVerifier() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            LatLonDialog.this.parseLatLonUserInput();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            LatLonDialog.this.parseLatLonUserInput();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            LatLonDialog.this.parseLatLonUserInput();
        }
    }
}

