/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.awt.Color;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxDistance;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.mapcss.ExpressionFactory;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.RightAndLefthandTraffic;
import org.openstreetmap.josm.tools.RotationAngle;
import org.openstreetmap.josm.tools.Territories;
import org.openstreetmap.josm.tools.Utils;

public final class Functions {
    private Functions() {
    }

    public static Object eval(Object o) {
        return o;
    }

    public static float plus(float ... args) {
        float res = 0.0f;
        for (float f : args) {
            res += f;
        }
        return res;
    }

    public static Float minus(float ... args) {
        if (args.length == 0) {
            return Float.valueOf(0.0f);
        }
        if (args.length == 1) {
            return Float.valueOf(-args[0]);
        }
        float res = args[0];
        for (int i = 1; i < args.length; ++i) {
            res -= args[i];
        }
        return Float.valueOf(res);
    }

    public static float times(float ... args) {
        float res = 1.0f;
        for (float f : args) {
            res *= f;
        }
        return res;
    }

    public static Float divided_by(float ... args) {
        if (args.length == 0) {
            return Float.valueOf(1.0f);
        }
        float res = args[0];
        for (int i = 1; i < args.length; ++i) {
            if (args[i] == 0.0f) {
                return null;
            }
            res /= args[i];
        }
        return Float.valueOf(res);
    }

    public static List<Object> list(Object ... args) {
        return Arrays.asList(args);
    }

    public static Integer count(List<?> lst) {
        return lst.size();
    }

    @ExpressionFactory.NullableArguments
    public static Object any(Object ... args) {
        return Utils.firstNonNull(args);
    }

    public static Object get(List<?> lst, float n) {
        int idx = Math.round(n);
        if (idx >= 0 && idx < lst.size()) {
            return lst.get(idx);
        }
        return null;
    }

    public static List<String> split(String sep, String toSplit) {
        return Arrays.asList(toSplit.split(Pattern.quote(sep), -1));
    }

    public static Color rgb(float r, float g, float b) {
        try {
            return new Color(r, g, b);
        }
        catch (IllegalArgumentException e) {
            Logging.trace(e);
            return null;
        }
    }

    public static Color rgba(float r, float g, float b, float alpha) {
        try {
            return new Color(r, g, b, alpha);
        }
        catch (IllegalArgumentException e) {
            Logging.trace(e);
            return null;
        }
    }

    public static Color hsb_color(float h, float s, float b) {
        try {
            return Color.getHSBColor(h, s, b);
        }
        catch (IllegalArgumentException e) {
            Logging.trace(e);
            return null;
        }
    }

    public static Color html2color(String html) {
        return ColorHelper.html2color(html);
    }

    public static String color2html(Color c) {
        return ColorHelper.color2html(c);
    }

    public static float red(Color c) {
        return Utils.colorInt2float(c.getRed()).floatValue();
    }

    public static float green(Color c) {
        return Utils.colorInt2float(c.getGreen()).floatValue();
    }

    public static float blue(Color c) {
        return Utils.colorInt2float(c.getBlue()).floatValue();
    }

    public static float alpha(Color c) {
        return Utils.colorInt2float(c.getAlpha()).floatValue();
    }

    @ExpressionFactory.NullableArguments
    public static String concat(Object ... args) {
        return Utils.join("", Arrays.asList(args));
    }

    @ExpressionFactory.NullableArguments
    public static String join(String ... args) {
        return Utils.join(args[0], Arrays.asList(args).subList(1, args.length));
    }

    public static String join_list(String separator, List<String> values) {
        return Utils.join(separator, values);
    }

    public static Object prop(Environment env, String key) {
        return Functions.prop(env, key, null);
    }

    public static Object prop(Environment env, String key, String layer) {
        return env.getCascade(layer).get(key);
    }

    public static Boolean is_prop_set(Environment env, String key) {
        return Functions.is_prop_set(env, key, null);
    }

    public static Boolean is_prop_set(Environment env, String key, String layer) {
        return env.getCascade(layer).containsKey(key);
    }

    public static String tag(Environment env, String key) {
        return env.osm == null ? null : env.osm.get(key);
    }

    public static List<String> tag_regex(Environment env, String keyRegex) {
        return Functions.tag_regex(env, keyRegex, "");
    }

    public static List<String> tag_regex(Environment env, String keyRegex, String flags) {
        int f = Functions.parse_regex_flags(flags);
        Pattern compiled = Pattern.compile(keyRegex, f);
        return env.osm.getKeys().entrySet().stream().filter(object -> compiled.matcher((CharSequence)object.getKey()).find()).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private static int parse_regex_flags(String flags) {
        int f = 0;
        if (flags.contains("i")) {
            f |= 2;
        }
        if (flags.contains("s")) {
            f |= 0x20;
        }
        if (flags.contains("m")) {
            f |= 8;
        }
        return f;
    }

    public static String parent_tag(Environment env, String key) {
        if (env.parent == null) {
            if (env.osm != null) {
                for (IPrimitive iPrimitive : env.osm.getReferrers()) {
                    String value = iPrimitive.get(key);
                    if (value == null) continue;
                    return value;
                }
            }
            return null;
        }
        return env.parent.get(key);
    }

    public static List<String> parent_tags(Environment env, String key) {
        if (env.parent == null) {
            if (env.osm != null) {
                TreeSet<String> tags = new TreeSet<String>(AlphanumComparator.getInstance());
                for (IPrimitive iPrimitive : env.osm.getReferrers()) {
                    String value = iPrimitive.get(key);
                    if (value == null) continue;
                    tags.add(value);
                }
                return new ArrayList<String>(tags);
            }
            return Collections.emptyList();
        }
        return Collections.singletonList(env.parent.get(key));
    }

    public static String child_tag(Environment env, String key) {
        return env.child == null ? null : env.child.get(key);
    }

    public static Long parent_osm_id(Environment env) {
        return env.parent == null ? null : Long.valueOf(env.parent.getUniqueId());
    }

    public static double gpx_distance(Environment env) {
        if (env.osm instanceof OsmPrimitive) {
            return MainApplication.getLayerManager().getAllGpxData().stream().mapToDouble(gpx -> GpxDistance.getLowestDistance((OsmPrimitive)env.osm, gpx)).min().orElse(Double.MAX_VALUE);
        }
        return Double.MAX_VALUE;
    }

    public static boolean has_tag_key(Environment env, String key) {
        return env.osm.hasKey(key);
    }

    public static Float index(Environment env) {
        if (env.index == null) {
            return null;
        }
        return Float.valueOf((float)env.index.intValue() + 1.0f);
    }

    public static List<String> sort(String ... sortables) {
        Arrays.parallelSort((Comparable[])sortables);
        return Arrays.asList(sortables);
    }

    public static List<String> sort_list(List<String> sortables) {
        Collections.sort(sortables);
        return sortables;
    }

    public static List<String> uniq(String ... values) {
        return Functions.uniq_list(Arrays.asList(values));
    }

    public static List<String> uniq_list(List<String> values) {
        return values.stream().distinct().collect(Collectors.toList());
    }

    public static String role(Environment env) {
        return env.getRole();
    }

    public static int count_roles(Environment env, String ... roles) {
        int rValue = 0;
        if (env.osm instanceof Relation) {
            List<String> roleList = Arrays.asList(roles);
            Relation rel = (Relation)env.osm;
            for (RelationMember member : rel.getMembers()) {
                if (!roleList.contains(member.getRole())) continue;
                ++rValue;
            }
        }
        return rValue;
    }

    public static Float areasize(Environment env) {
        Double area = Geometry.computeArea(env.osm);
        return area == null ? null : Float.valueOf(area.floatValue());
    }

    public static Float waylength(Environment env) {
        if (env.osm instanceof Way) {
            return Float.valueOf((float)((Way)env.osm).getLength());
        }
        return null;
    }

    public static boolean not(boolean b) {
        return !b;
    }

    public static boolean greater_equal(float a, float b) {
        return a >= b;
    }

    public static boolean less_equal(float a, float b) {
        return a <= b;
    }

    public static boolean greater(float a, float b) {
        return a > b;
    }

    public static boolean less(float a, float b) {
        return a < b;
    }

    public static double degree_to_radians(double degree) {
        return Utils.toRadians(degree);
    }

    public static Double cardinal_to_radians(String cardinal) {
        try {
            return RotationAngle.parseCardinalRotation(cardinal);
        }
        catch (IllegalArgumentException ignore) {
            Logging.trace(ignore);
            return null;
        }
    }

    public static boolean equal(Object a, Object b) {
        if (a.getClass() == b.getClass()) {
            return a.equals(b);
        }
        if (a.equals(Cascade.convertTo(b, a.getClass()))) {
            return true;
        }
        return b.equals(Cascade.convertTo(a, b.getClass()));
    }

    public static boolean not_equal(Object a, Object b) {
        return !Functions.equal(a, b);
    }

    public static Boolean JOSM_search(Environment env, String searchStr) {
        SearchCompiler.Match m;
        try {
            m = SearchCompiler.compile(searchStr);
        }
        catch (SearchParseError ex) {
            Logging.trace(ex);
            return null;
        }
        return m.match(env.osm);
    }

    public static String JOSM_pref(Environment env, String key, String def) {
        return MapPaintStyles.getStyles().getPreferenceCached(key, def);
    }

    public static boolean regexp_test(String pattern, String target) {
        return Pattern.matches(pattern, target);
    }

    public static boolean regexp_test(String pattern, String target, String flags) {
        int f = Functions.parse_regex_flags(flags);
        return Pattern.compile(pattern, f).matcher(target).matches();
    }

    public static List<String> regexp_match(String pattern, String target, String flags) {
        int f = Functions.parse_regex_flags(flags);
        return Utils.getMatches(Pattern.compile(pattern, f).matcher(target));
    }

    public static List<String> regexp_match(String pattern, String target) {
        return Utils.getMatches(Pattern.compile(pattern).matcher(target));
    }

    public static long osm_id(Environment env) {
        return env.osm.getUniqueId();
    }

    public static String osm_user_name(Environment env) {
        return env.osm.getUser().getName();
    }

    public static long osm_user_id(Environment env) {
        return env.osm.getUser().getId();
    }

    public static int osm_version(Environment env) {
        return env.osm.getVersion();
    }

    public static int osm_changeset_id(Environment env) {
        return env.osm.getChangesetId();
    }

    public static int osm_timestamp(Environment env) {
        return env.osm.getRawTimestamp();
    }

    @ExpressionFactory.NullableArguments
    public static String tr(String ... args) {
        String text = args[0];
        System.arraycopy(args, 1, args, 0, args.length - 1);
        return I18n.tr(text, args);
    }

    public static String substring(String s, float begin) {
        return s == null ? null : s.substring((int)begin);
    }

    public static String substring(String s, float begin, float end) {
        return s == null ? null : s.substring((int)begin, (int)end);
    }

    public static String replace(String s, String target, String replacement) {
        return s == null ? null : s.replace(target, replacement);
    }

    public static String upper(String s) {
        return s == null ? null : s.toUpperCase(Locale.ENGLISH);
    }

    public static String lower(String s) {
        return s == null ? null : s.toLowerCase(Locale.ENGLISH);
    }

    public static String trim(String s) {
        return Utils.strip(s);
    }

    public static List<String> trim_list(List<String> strings) {
        return strings.stream().map(Utils::strip).filter(str -> !str.isEmpty()).collect(Collectors.toList());
    }

    public static boolean is_similar(String string1, String string2) {
        return Utils.isSimilar(string1, string2);
    }

    public static String URL_decode(String s) {
        if (s == null) {
            return null;
        }
        try {
            return Utils.decodeUrl(s);
        }
        catch (IllegalStateException e) {
            Logging.debug(e);
            return s;
        }
    }

    public static String URL_encode(String s) {
        return s == null ? null : Utils.encodeUrl(s);
    }

    public static String XML_encode(String s) {
        return s == null ? null : XmlWriter.encode(s);
    }

    public static long CRC32_checksum(String s) {
        CRC32 cs = new CRC32();
        cs.update(s.getBytes(StandardCharsets.UTF_8));
        return cs.getValue();
    }

    public static boolean is_right_hand_traffic(Environment env) {
        return RightAndLefthandTraffic.isRightHandTraffic(Functions.center(env));
    }

    public static boolean is_clockwise(Environment env) {
        if (!(env.osm instanceof Way)) {
            return false;
        }
        Way way = (Way)env.osm;
        return way.isClosed() && Geometry.isClockwise(way) || !way.isClosed() && way.getNodesCount() > 2 && Geometry.angleIsClockwise(way.getNode(0), way.getNode(1), way.lastNode());
    }

    public static boolean is_anticlockwise(Environment env) {
        if (!(env.osm instanceof Way)) {
            return false;
        }
        Way way = (Way)env.osm;
        return way.isClosed() && !Geometry.isClockwise(way) || !way.isClosed() && way.getNodesCount() > 2 && !Geometry.angleIsClockwise(way.getNode(0), way.getNode(1), way.lastNode());
    }

    @ExpressionFactory.NullableArguments
    public static Object print(Object o) {
        System.out.print(o == null ? "none" : o.toString());
        return o;
    }

    @ExpressionFactory.NullableArguments
    public static Object println(Object o) {
        System.out.println(o == null ? "none" : o.toString());
        return o;
    }

    public static int number_of_tags(Environment env) {
        return env.osm.getNumKeys();
    }

    public static Object setting(Environment env, String key) {
        return env.source.settingValues.get(key);
    }

    public static LatLon center(Environment env) {
        return env.osm instanceof Node ? ((Node)env.osm).getCoor() : env.osm.getBBox().getCenter();
    }

    public static boolean inside(Environment env, String codes) {
        for (String code : codes.toUpperCase(Locale.ENGLISH).split(",")) {
            if (!Territories.isIso3166Code(code.trim(), Functions.center(env))) continue;
            return true;
        }
        return false;
    }

    public static boolean outside(Environment env, String codes) {
        return !Functions.inside(env, codes);
    }

    public static boolean at(Environment env, double lat, double lon) {
        return new LatLon(lat, lon).equalsEpsilon(Functions.center(env));
    }
}

